/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.type;

import java.io.Serializable;
import net.sf.saxon.om.FunctionItem;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.StandardNames;
import net.sf.saxon.pattern.AnyNodeTest;
import net.sf.saxon.pattern.CombinedNodeTest;
import net.sf.saxon.pattern.ContentTypeTest;
import net.sf.saxon.pattern.DocumentNodeTest;
import net.sf.saxon.pattern.EmptySequenceTest;
import net.sf.saxon.pattern.NameTest;
import net.sf.saxon.pattern.NodeKindTest;
import net.sf.saxon.pattern.NodeTest;
import net.sf.saxon.tree.iter.AxisIterator;
import net.sf.saxon.type.AnyItemType;
import net.sf.saxon.type.AnyType;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.BuiltInType;
import net.sf.saxon.type.ExternalObjectType;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.SchemaType;
import net.sf.saxon.type.SimpleType;
import net.sf.saxon.type.TypeHierarchy;
import net.sf.saxon.type.Untyped;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.ObjectValue;

public abstract class Type
implements Serializable {
    public static final short ELEMENT = 1;
    public static final short ATTRIBUTE = 2;
    public static final short TEXT = 3;
    public static final short WHITESPACE_TEXT = 4;
    public static final short PROCESSING_INSTRUCTION = 7;
    public static final short COMMENT = 8;
    public static final short DOCUMENT = 9;
    public static final short NAMESPACE = 13;
    public static final short STOPPER = 11;
    public static final short PARENT_POINTER = 12;
    public static final short NODE = 0;
    public static final ItemType NODE_TYPE = AnyNodeTest.getInstance();
    public static final short ITEM = 88;
    public static final ItemType ITEM_TYPE = AnyItemType.getInstance();
    public static final short FUNCTION = 99;
    public static final short MAX_NODE_TYPE = 13;
    public static final short EMPTY = 15;

    private Type() {
    }

    public static boolean isNodeType(ItemType type) {
        return type instanceof NodeTest;
    }

    public static ItemType getItemType(Item item, TypeHierarchy th) {
        if (item == null) {
            return AnyItemType.getInstance();
        }
        if (item instanceof AtomicValue) {
            return ((AtomicValue)item).getItemType();
        }
        if (item instanceof NodeInfo) {
            NodeInfo node = (NodeInfo)item;
            if (th == null) {
                th = node.getConfiguration().getTypeHierarchy();
            }
            switch (node.getNodeKind()) {
                case 9: {
                    Object n;
                    AxisIterator iter = node.iterateAxis((byte)3);
                    ItemType elementType = null;
                    while ((n = iter.next()) != null) {
                        int kind = n.getNodeKind();
                        if (kind == 3) {
                            elementType = null;
                            break;
                        }
                        if (kind != 1) continue;
                        if (elementType != null) {
                            elementType = null;
                            break;
                        }
                        elementType = Type.getItemType(n, th);
                    }
                    if (elementType == null) {
                        return NodeKindTest.DOCUMENT;
                    }
                    return new DocumentNodeTest((NodeTest)elementType);
                }
                case 1: {
                    SchemaType eltype = node.getSchemaType();
                    if (eltype.equals(Untyped.getInstance()) || eltype.equals(AnyType.getInstance())) {
                        return new NameTest(1, node.getFingerprint(), node.getNamePool());
                    }
                    return new CombinedNodeTest(new NameTest(1, node.getFingerprint(), node.getNamePool()), 23, new ContentTypeTest(1, eltype, node.getConfiguration(), false));
                }
                case 2: {
                    SchemaType attype = node.getSchemaType();
                    if (attype.equals(BuiltInAtomicType.UNTYPED_ATOMIC)) {
                        return new NameTest(2, node.getFingerprint(), node.getNamePool());
                    }
                    return new CombinedNodeTest(new NameTest(2, node.getFingerprint(), node.getNamePool()), 23, new ContentTypeTest(2, attype, node.getConfiguration(), false));
                }
                case 3: {
                    return NodeKindTest.TEXT;
                }
                case 8: {
                    return NodeKindTest.COMMENT;
                }
                case 7: {
                    return NodeKindTest.PROCESSING_INSTRUCTION;
                }
                case 13: {
                    return NodeKindTest.NAMESPACE;
                }
            }
            throw new IllegalArgumentException("Unknown node kind " + node.getNodeKind());
        }
        if (item instanceof ObjectValue) {
            return ((ObjectValue)item).getItemType(th);
        }
        return ((FunctionItem)item).getFunctionItemType(th);
    }

    public static String displayTypeName(Item item) {
        if (item instanceof NodeInfo) {
            NodeInfo node = (NodeInfo)item;
            switch (node.getNodeKind()) {
                case 9: {
                    return "document-node()";
                }
                case 1: {
                    SchemaType annotation = node.getSchemaType();
                    return "element(" + ((NodeInfo)item).getDisplayName() + ", " + annotation.getDisplayName() + ')';
                }
                case 2: {
                    SchemaType annotation2 = node.getSchemaType();
                    return "attribute(" + ((NodeInfo)item).getDisplayName() + ", " + annotation2.getDisplayName() + ')';
                }
                case 3: {
                    return "text()";
                }
                case 8: {
                    return "comment()";
                }
                case 7: {
                    return "processing-instruction()";
                }
                case 13: {
                    return "namespace()";
                }
            }
            return "";
        }
        if (item instanceof ObjectValue) {
            return ((ObjectValue)item).displayTypeName();
        }
        if (item instanceof AtomicValue) {
            return ((AtomicValue)item).getItemType().toString();
        }
        if (item instanceof FunctionItem) {
            return "function(*)";
        }
        return item.getClass().toString();
    }

    public static ItemType getBuiltInItemType(String namespace, String localName) {
        SchemaType t = BuiltInType.getSchemaType(StandardNames.getFingerprint(namespace, localName));
        if (t instanceof ItemType) {
            return (ItemType)((Object)t);
        }
        return null;
    }

    public static SimpleType getBuiltInSimpleType(String namespace, String localName) {
        SchemaType t = BuiltInType.getSchemaType(StandardNames.getFingerprint(namespace, localName));
        if (t instanceof SimpleType && ((SimpleType)t).isBuiltInType()) {
            return (SimpleType)t;
        }
        return null;
    }

    public static ItemType getCommonSuperType(ItemType t1, ItemType t2, TypeHierarchy th) {
        if (t1 == t2) {
            return t1;
        }
        if (t1 instanceof EmptySequenceTest) {
            return t2;
        }
        if (t2 instanceof EmptySequenceTest) {
            return t1;
        }
        if (t1 instanceof ExternalObjectType && t2 instanceof ExternalObjectType) {
            Class c1 = ((ExternalObjectType)t1).getJavaClass();
            Class c2 = ((ExternalObjectType)t2).getJavaClass();
            return new ExternalObjectType(Type.leastCommonSuperClass(c1, c2));
        }
        int r = th.relationship(t1, t2);
        if (r == 0) {
            return t1;
        }
        if (r == 2) {
            return t2;
        }
        if (r == 1) {
            return t1;
        }
        ItemType st = t2.getSuperType(th);
        if (st == null) {
            return AnyItemType.getInstance();
        }
        return Type.getCommonSuperType(st, t1, th);
    }

    public static ItemType getCommonSuperType(ItemType t1, ItemType t2) {
        ItemType p2;
        if (t1 == t2) {
            return t1;
        }
        if (t1 instanceof EmptySequenceTest) {
            return t2;
        }
        if (t2 instanceof EmptySequenceTest) {
            return t1;
        }
        if (t1 == AnyItemType.getInstance() || t2 == AnyItemType.getInstance()) {
            return AnyItemType.getInstance();
        }
        ItemType p1 = t1.getPrimitiveItemType();
        if (p1 == (p2 = t2.getPrimitiveItemType())) {
            return p1;
        }
        if (p1 == BuiltInAtomicType.DECIMAL && p2 == BuiltInAtomicType.INTEGER || p2 == BuiltInAtomicType.DECIMAL && p1 == BuiltInAtomicType.INTEGER) {
            return BuiltInAtomicType.DECIMAL;
        }
        if (p1 instanceof BuiltInAtomicType && ((BuiltInAtomicType)p1).isNumericType() && p2 instanceof BuiltInAtomicType && ((BuiltInAtomicType)p2).isNumericType()) {
            return BuiltInAtomicType.NUMERIC;
        }
        if (t1.isAtomicType() && t2.isAtomicType()) {
            return BuiltInAtomicType.ANY_ATOMIC;
        }
        if (t1 instanceof NodeTest && t2 instanceof NodeTest) {
            return AnyNodeTest.getInstance();
        }
        if (t1 instanceof ExternalObjectType && t2 instanceof ExternalObjectType) {
            Class c1 = ((ExternalObjectType)t1).getJavaClass();
            Class c2 = ((ExternalObjectType)t2).getJavaClass();
            return new ExternalObjectType(Type.leastCommonSuperClass(c1, c2));
        }
        return AnyItemType.getInstance();
    }

    private static Class leastCommonSuperClass(Class class1, Class class2) {
        if (class1 == class2) {
            return class1;
        }
        if (class1 == null || class2 == null) {
            return null;
        }
        if (!class1.isArray() && class1.isAssignableFrom(class2)) {
            return class1;
        }
        if (!class2.isArray() && class2.isAssignableFrom(class1)) {
            return class2;
        }
        if (class1.isInterface() || class2.isInterface()) {
            return Object.class;
        }
        return Type.leastCommonSuperClass(class1.getSuperclass(), class2.getSuperclass());
    }

    public static boolean isPrimitiveType(int code) {
        return code >= 0 && (code <= 533 || code == 635 || code == 631 || code == 632 || code == 634 || code == 633 || code == 573);
    }

    public static boolean isGuaranteedComparable(BuiltInAtomicType t1, BuiltInAtomicType t2, boolean ordered) {
        if (t1 == t2) {
            return true;
        }
        if (t1.equals(BuiltInAtomicType.UNTYPED_ATOMIC)) {
            t1 = BuiltInAtomicType.STRING;
        }
        if (t2.equals(BuiltInAtomicType.UNTYPED_ATOMIC)) {
            t2 = BuiltInAtomicType.STRING;
        }
        if (t1.equals(BuiltInAtomicType.ANY_URI)) {
            t1 = BuiltInAtomicType.STRING;
        }
        if (t2.equals(BuiltInAtomicType.ANY_URI)) {
            t2 = BuiltInAtomicType.STRING;
        }
        if (t1.isPrimitiveNumeric()) {
            t1 = BuiltInAtomicType.NUMERIC;
        }
        if (t2.isPrimitiveNumeric()) {
            t2 = BuiltInAtomicType.NUMERIC;
        }
        if (!ordered) {
            if (t1.equals(BuiltInAtomicType.DAY_TIME_DURATION)) {
                t1 = BuiltInAtomicType.DURATION;
            }
            if (t2.equals(BuiltInAtomicType.DAY_TIME_DURATION)) {
                t2 = BuiltInAtomicType.DURATION;
            }
            if (t1.equals(BuiltInAtomicType.YEAR_MONTH_DURATION)) {
                t1 = BuiltInAtomicType.DURATION;
            }
            if (t2.equals(BuiltInAtomicType.YEAR_MONTH_DURATION)) {
                t2 = BuiltInAtomicType.DURATION;
            }
        }
        return t1 == t2;
    }

    public static boolean isPossiblyComparable(BuiltInAtomicType t1, BuiltInAtomicType t2, boolean ordered) {
        if (t1 == t2) {
            return true;
        }
        if (t1.equals(BuiltInAtomicType.ANY_ATOMIC) || t2.equals(BuiltInAtomicType.ANY_ATOMIC)) {
            return true;
        }
        if (t1.equals(BuiltInAtomicType.UNTYPED_ATOMIC)) {
            t1 = BuiltInAtomicType.STRING;
        }
        if (t2.equals(BuiltInAtomicType.UNTYPED_ATOMIC)) {
            t2 = BuiltInAtomicType.STRING;
        }
        if (t1.equals(BuiltInAtomicType.ANY_URI)) {
            t1 = BuiltInAtomicType.STRING;
        }
        if (t2.equals(BuiltInAtomicType.ANY_URI)) {
            t2 = BuiltInAtomicType.STRING;
        }
        if (t1.isPrimitiveNumeric()) {
            t1 = BuiltInAtomicType.NUMERIC;
        }
        if (t2.isPrimitiveNumeric()) {
            t2 = BuiltInAtomicType.NUMERIC;
        }
        if (t1.equals(BuiltInAtomicType.DAY_TIME_DURATION)) {
            t1 = BuiltInAtomicType.DURATION;
        }
        if (t2.equals(BuiltInAtomicType.DAY_TIME_DURATION)) {
            t2 = BuiltInAtomicType.DURATION;
        }
        if (t1.equals(BuiltInAtomicType.YEAR_MONTH_DURATION)) {
            t1 = BuiltInAtomicType.DURATION;
        }
        if (t2.equals(BuiltInAtomicType.YEAR_MONTH_DURATION)) {
            t2 = BuiltInAtomicType.DURATION;
        }
        return t1 == t2;
    }

    public static boolean isGenerallyComparable(BuiltInAtomicType t1, BuiltInAtomicType t2, boolean ordered) {
        return t1.equals(BuiltInAtomicType.ANY_ATOMIC) || t2.equals(BuiltInAtomicType.ANY_ATOMIC) || t1.equals(BuiltInAtomicType.UNTYPED_ATOMIC) || t2.equals(BuiltInAtomicType.UNTYPED_ATOMIC) || Type.isGuaranteedComparable(t1, t2, ordered);
    }

    public static boolean isGuaranteedGenerallyComparable(BuiltInAtomicType t1, BuiltInAtomicType t2, boolean ordered) {
        return !t1.equals(BuiltInAtomicType.ANY_ATOMIC) && !t2.equals(BuiltInAtomicType.ANY_ATOMIC) && Type.isGenerallyComparable(t1, t2, ordered);
    }
}

