/*
 * Decompiled with CFR 0.152.
 */
package sbt.internal.inc;

import com.google.protobuf.CodedInputStream;
import com.google.protobuf.CodedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Serializable;
import java.util.Optional;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import sbt.internal.inc.APIs;
import sbt.internal.inc.Analysis;
import sbt.internal.inc.CompanionsStore;
import sbt.internal.inc.FileAnalysisStore$;
import sbt.internal.inc.JavaInterfaceUtil$;
import sbt.internal.inc.binary.BinaryAnalysisFormat;
import sbt.internal.inc.text.TextAnalysisFormat;
import sbt.io.IO$;
import sbt.io.Using$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.immutable.Map;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.util.control.Exception$;
import xsbti.api.Companions;
import xsbti.compile.AnalysisContents;
import xsbti.compile.AnalysisStore;
import xsbti.compile.CompileAnalysis;
import xsbti.compile.MiniSetup;
import xsbti.compile.analysis.ReadWriteMappers;

@ScalaSignature(bytes="\u0006\u0001\u0005\rw!B\u0001\u0003\u0011\u0003I\u0011!\u0005$jY\u0016\fe.\u00197zg&\u001c8\u000b^8sK*\u00111\u0001B\u0001\u0004S:\u001c'BA\u0003\u0007\u0003!Ig\u000e^3s]\u0006d'\"A\u0004\u0002\u0007M\u0014Go\u0001\u0001\u0011\u0005)YQ\"\u0001\u0002\u0007\u000b1\u0011\u0001\u0012A\u0007\u0003#\u0019KG.Z!oC2L8/[:Ti>\u0014Xm\u0005\u0002\f\u001dA\u0011qBE\u0007\u0002!)\t\u0011#A\u0003tG\u0006d\u0017-\u0003\u0002\u0014!\t1\u0011I\\=SK\u001aDQ!F\u0006\u0005\u0002Y\ta\u0001P5oSRtD#A\u0005\t\u000faY!\u0019!C\u00073\u0005a!)\u001b8FqR,gn]5p]V\t!dD\u0001\u001cC\u0005a\u0012a\u00012j]\"1ad\u0003Q\u0001\u000ei\tQBQ5o\u000bb$XM\\:j_:\u0004\u0003b\u0002\u0011\f\u0005\u0004%i!I\u0001\u0011C:\fG._:jg\u001aKG.\u001a(b[\u0016,\u0012A\t\t\u0003G)r!\u0001\n\u0015\u0011\u0005\u0015\u0002R\"\u0001\u0014\u000b\u0005\u001dB\u0011A\u0002\u001fs_>$h(\u0003\u0002*!\u00051\u0001K]3eK\u001aL!a\u000b\u0017\u0003\rM#(/\u001b8h\u0015\tI\u0003\u0003\u0003\u0004/\u0017\u0001\u0006iAI\u0001\u0012C:\fG._:jg\u001aKG.\u001a(b[\u0016\u0004\u0003b\u0002\u0019\f\u0005\u0004%i!I\u0001\u0013G>l\u0007/\u00198j_:\u001ch)\u001b7f\u001d\u0006lW\r\u0003\u00043\u0017\u0001\u0006iAI\u0001\u0014G>l\u0007/\u00198j_:\u001ch)\u001b7f\u001d\u0006lW\r\t\u0005\u0006i-!\t!N\u0001\u0007E&t\u0017M]=\u0015\u0005Yr\u0004CA\u001c=\u001b\u0005A$BA\u001d;\u0003\u001d\u0019w.\u001c9jY\u0016T\u0011aO\u0001\u0006qN\u0014G/[\u0005\u0003{a\u0012Q\"\u00118bYf\u001c\u0018n]*u_J,\u0007\"B 4\u0001\u0004\u0001\u0015\u0001D1oC2L8/[:GS2,\u0007CA!G\u001b\u0005\u0011%BA\"E\u0003\tIwNC\u0001F\u0003\u0011Q\u0017M^1\n\u0005\u001d\u0013%\u0001\u0002$jY\u0016DQ\u0001N\u0006\u0005\u0002%#2A\u000e&L\u0011\u0015y\u0004\n1\u0001A\u0011\u0015a\u0005\n1\u0001N\u0003\u001di\u0017\r\u001d9feN\u0004\"AT)\u000e\u0003=S!\u0001\u0015\u001d\u0002\u0011\u0005t\u0017\r\\=tSNL!AU(\u0003!I+\u0017\rZ,sSR,W*\u00199qKJ\u001c\b\"\u0002+\f\t\u0003)\u0016\u0001\u0002;fqR$\"A\u000e,\t\u000b]\u001b\u0006\u0019\u0001!\u0002\t\u0019LG.\u001a\u0005\u0006).!\t!\u0017\u000b\u0004mi[\u0006\"B,Y\u0001\u0004\u0001\u0005\"\u0002'Y\u0001\u0004i\u0005\"\u0002+\f\t\u0003iFc\u0001\u001c_?\")q\u000b\u0018a\u0001\u0001\")\u0001\r\u0018a\u0001C\u00061am\u001c:nCR\u0004\"A\u00193\u000e\u0003\rT!\u0001\u0016\u0002\n\u0005\u0015\u001c'A\u0005+fqR\fe.\u00197zg&\u001chi\u001c:nCR4AaZ\u0006\u0007Q\ny!)\u001b8bef4\u0015\u000e\\3Ti>\u0014XmE\u0002gSZ\u0002\"A[7\u000e\u0003-T!\u0001\u001c#\u0002\t1\fgnZ\u0005\u0003].\u0014aa\u00142kK\u000e$\b\u0002C,g\u0005\u0003\u0005\u000b\u0011\u0002!\t\u0011E4'\u0011!Q\u0001\n5\u000b\u0001C]3bI^\u0013\u0018\u000e^3NCB\u0004XM]:\t\u000bU1G\u0011A:\u0015\u0007Q4x\u000f\u0005\u0002vM6\t1\u0002C\u0003Xe\u0002\u0007\u0001\tC\u0003re\u0002\u0007Q\nC\u0004aM\n\u0007IQB=\u0016\u0003i\u0004\"a_?\u000e\u0003qT!\u0001\u000e\u0002\n\u0005yd(\u0001\u0006\"j]\u0006\u0014\u00180\u00118bYf\u001c\u0018n\u001d$pe6\fG\u000fC\u0004\u0002\u0002\u0019\u0004\u000bQ\u0002>\u0002\u000f\u0019|'/\\1uA!I\u0011Q\u00014C\u0002\u00135\u0011qA\u0001\n)6\u0004XI\u001c3j]\u001e,\"!!\u0003\u0010\u0005\u0005-\u0011EAA\u0007\u0003\u0011qC/\u001c9\t\u0011\u0005Ea\r)A\u0007\u0003\u0013\t!\u0002V7q\u000b:$\u0017N\\4!\u0011\u001d\t)B\u001aC!\u0003/\t1aZ3u)\t\tI\u0002\u0005\u0004\u0002\u001c\u0005\u0005\u0012QE\u0007\u0003\u0003;Q1!a\bE\u0003\u0011)H/\u001b7\n\t\u0005\r\u0012Q\u0004\u0002\t\u001fB$\u0018n\u001c8bYB\u0019q'a\n\n\u0007\u0005%\u0002H\u0001\tB]\u0006d\u0017p]5t\u0007>tG/\u001a8ug\"9\u0011Q\u00064\u0005B\u0005=\u0012aA:fiR!\u0011\u0011GA\u001c!\ry\u00111G\u0005\u0004\u0003k\u0001\"\u0001B+oSRD\u0001\"!\u000f\u0002,\u0001\u0007\u0011QE\u0001\tG>tG/\u001a8ug\u001a1\u0011QH\u0006\u0007\u0003\u007f\u0011!CR5mK\n\u000b7/\u001a3Ti>\u0014X-S7qYN!\u00111H57\u0011%9\u00161\bB\u0001B\u0003%\u0001\tC\u0005a\u0003w\u0011\t\u0011)A\u0005C\"9Q#a\u000f\u0005\u0002\u0005\u001dCCBA%\u0003\u0017\ni\u0005E\u0002v\u0003wAaaVA#\u0001\u0004\u0001\u0005B\u00021\u0002F\u0001\u0007\u0011\r\u0003\u0006\u0002R\u0005m\"\u0019!C\u0001\u0003'\nqbY8na\u0006t\u0017n\u001c8t'R|'/Z\u000b\u0003\u0003+\u00022!^A,\r\u0019\tIf\u0003\u0004\u0002\\\tYb)\u001b7f\u0005\u0006\u001cX\rZ\"p[B\fg.[8og6\u000b\u0007o\u0015;pe\u0016\u001cR!a\u0016\u000f\u0003;\u00022ACA0\u0013\r\t\tG\u0001\u0002\u0010\u0007>l\u0007/\u00198j_:\u001c8\u000b^8sK\"Iq+a\u0016\u0003\u0002\u0003\u0006I\u0001\u0011\u0005\nA\u0006]#\u0011!Q\u0001\n\u0005Dq!FA,\t\u0003\tI\u0007\u0006\u0004\u0002V\u0005-\u0014Q\u000e\u0005\u0007/\u0006\u001d\u0004\u0019\u0001!\t\r\u0001\f9\u00071\u0001b\u0011!\t)\"a\u0016\u0005\u0002\u0005EDCAA:!\u0015y\u0011QOA=\u0013\r\t9\b\u0005\u0002\u0007\u001fB$\u0018n\u001c8\u0011\u000f=\tY(a \u0002\u0000%\u0019\u0011Q\u0010\t\u0003\rQ+\b\u000f\\33!\u0019\u0019\u0013\u0011\u0011\u0012\u0002\u0006&\u0019\u00111\u0011\u0017\u0003\u00075\u000b\u0007\u000f\u0005\u0003\u0002\b\u00065UBAAE\u0015\r\tYIO\u0001\u0004CBL\u0017\u0002BAH\u0003\u0013\u0013!bQ8na\u0006t\u0017n\u001c8t\u0011!\t\u0019*a\u0016\u0005\u0002\u0005U\u0015aC4fiVs7-Y;hQR$\"!!\u001f\t\u0013\u0005e\u00151\bQ\u0001\n\u0005U\u0013\u0001E2p[B\fg.[8ogN#xN]3!\u0011!\ti#a\u000f\u0005\u0002\u0005uE\u0003BA\u0019\u0003?C\u0001\"!)\u0002\u001c\u0002\u0007\u0011QE\u0001\u0011C:\fG._:jg\u000e{g\u000e^3oiND\u0001\"!\u0006\u0002<\u0011\u0005\u0011q\u0003\u0005\t\u0003'\u000bY\u0004\"\u0001\u0002(R\u0011\u0011Q\u0005\u0005\b\u0003W[A\u0011BAW\u0003-awn\\6va\u0016sGO]=\u0015\r\u0005E\u0012qVA`\u0011!\t\t,!+A\u0002\u0005M\u0016AA5o!\u0011\t),a/\u000e\u0005\u0005]&\u0002BA]\u0003;\t1A_5q\u0013\u0011\ti,a.\u0003\u001diK\u0007/\u00138qkR\u001cFO]3b[\"9\u0011\u0011YAU\u0001\u0004\u0011\u0013\u0001\u00028b[\u0016\u0004")
public final class FileAnalysisStore {
    public static AnalysisStore text(File file, TextAnalysisFormat textAnalysisFormat) {
        return FileAnalysisStore$.MODULE$.text(file, textAnalysisFormat);
    }

    public static AnalysisStore text(File file, ReadWriteMappers readWriteMappers) {
        return FileAnalysisStore$.MODULE$.text(file, readWriteMappers);
    }

    public static AnalysisStore text(File file) {
        return FileAnalysisStore$.MODULE$.text(file);
    }

    public static AnalysisStore binary(File file, ReadWriteMappers readWriteMappers) {
        return FileAnalysisStore$.MODULE$.binary(file, readWriteMappers);
    }

    public static AnalysisStore binary(File file) {
        return FileAnalysisStore$.MODULE$.binary(file);
    }

    public static final class BinaryFileStore
    implements AnalysisStore {
        private final File file;
        private final BinaryAnalysisFormat format;

        private final BinaryAnalysisFormat format() {
            return this.format;
        }

        private final String TmpEnding() {
            return ".tmp";
        }

        public Optional<AnalysisContents> get() {
            Option nestedRead = Exception$.MODULE$.allCatch().opt((Function0 & Serializable & scala.Serializable)() -> (Option)Using$.MODULE$.zipInputStream().apply((Object)new FileInputStream($this.file), (Function1 & Serializable & scala.Serializable)inputStream -> {
                FileAnalysisStore$.MODULE$.sbt$internal$inc$FileAnalysisStore$$lookupEntry((ZipInputStream)inputStream, FileAnalysisStore$.MODULE$.sbt$internal$inc$FileAnalysisStore$$analysisFileName());
                CodedInputStream reader = CodedInputStream.newInstance((InputStream)inputStream);
                Tuple2<CompileAnalysis, MiniSetup> tuple2 = this.format().read(reader);
                if (tuple2 == null) {
                    throw new MatchError(tuple2);
                }
                CompileAnalysis analysis2 = (CompileAnalysis)tuple2._1();
                MiniSetup miniSetup = (MiniSetup)tuple2._2();
                Tuple2 tuple22 = new Tuple2((Object)analysis2, (Object)miniSetup);
                Tuple2 tuple23 = tuple22;
                CompileAnalysis analysis3 = (CompileAnalysis)tuple23._1();
                MiniSetup miniSetup2 = (MiniSetup)tuple23._2();
                Option analysisWithAPIs = Exception$.MODULE$.allCatch().opt((Function0 & Serializable & scala.Serializable)() -> {
                    FileAnalysisStore$.MODULE$.sbt$internal$inc$FileAnalysisStore$$lookupEntry((ZipInputStream)inputStream, FileAnalysisStore$.MODULE$.sbt$internal$inc$FileAnalysisStore$$companionsFileName());
                    return this.format().readAPIs(reader, analysis3);
                });
                return analysisWithAPIs.map((Function1 & Serializable & scala.Serializable)analysis -> AnalysisContents.create((CompileAnalysis)analysis, (MiniSetup)miniSetup2));
            }));
            return JavaInterfaceUtil$.MODULE$.EnrichOption(nestedRead.flatten(Predef$.MODULE$.$conforms())).toOptional();
        }

        public void set(AnalysisContents contents) {
            CompileAnalysis analysis = contents.getAnalysis();
            MiniSetup setup = contents.getMiniSetup();
            File tmpAnalysisFile = File.createTempFile(this.file.getName(), ".tmp");
            Object object = !this.file.getParentFile().exists() ? BoxesRunTime.boxToBoolean((boolean)this.file.getParentFile().mkdirs()) : BoxedUnit.UNIT;
            FileOutputStream outputStream2 = new FileOutputStream(tmpAnalysisFile);
            Using$.MODULE$.zipOutputStream().apply((Object)outputStream2, (Function1 & Serializable & scala.Serializable)outputStream -> {
                BinaryFileStore.$anonfun$set$1(this, analysis, setup, outputStream);
                return BoxedUnit.UNIT;
            });
            IO$.MODULE$.move(tmpAnalysisFile, this.file);
        }

        public static final /* synthetic */ void $anonfun$set$1(BinaryFileStore $this, CompileAnalysis analysis$2, MiniSetup setup$1, ZipOutputStream outputStream) {
            block0: {
                CodedOutputStream protobufWriter = CodedOutputStream.newInstance((OutputStream)outputStream);
                outputStream.putNextEntry(new ZipEntry(FileAnalysisStore$.MODULE$.sbt$internal$inc$FileAnalysisStore$$analysisFileName()));
                $this.format().write(protobufWriter, analysis$2, setup$1);
                outputStream.closeEntry();
                if (!setup$1.storeApis()) break block0;
                outputStream.putNextEntry(new ZipEntry(FileAnalysisStore$.MODULE$.sbt$internal$inc$FileAnalysisStore$$companionsFileName()));
                $this.format().writeAPIs(protobufWriter, analysis$2);
                outputStream.closeEntry();
            }
        }

        public BinaryFileStore(File file, ReadWriteMappers readWriteMappers) {
            this.file = file;
            this.format = new BinaryAnalysisFormat(readWriteMappers);
        }
    }

    public static final class FileBasedCompanionsMapStore
    implements CompanionsStore {
        private final File file;
        private final TextAnalysisFormat format;

        public Option<Tuple2<Map<String, Companions>, Map<String, Companions>>> get() {
            return Exception$.MODULE$.allCatch().opt((Function0 & Serializable & scala.Serializable)() -> this.getUncaught());
        }

        public Tuple2<Map<String, Companions>, Map<String, Companions>> getUncaught() {
            return (Tuple2)Using$.MODULE$.zipInputStream().apply((Object)new FileInputStream(this.file), (Function1 & Serializable & scala.Serializable)inputStream -> {
                FileAnalysisStore$.MODULE$.sbt$internal$inc$FileAnalysisStore$$lookupEntry((ZipInputStream)inputStream, FileAnalysisStore$.MODULE$.sbt$internal$inc$FileAnalysisStore$$companionsFileName());
                BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)inputStream, IO$.MODULE$.utf8()));
                return $this.format.readCompanionMap(reader);
            });
        }

        public FileBasedCompanionsMapStore(File file, TextAnalysisFormat format) {
            this.file = file;
            this.format = format;
        }
    }

    public static final class FileBasedStoreImpl
    implements AnalysisStore {
        private final File file;
        private final TextAnalysisFormat format;
        private final FileBasedCompanionsMapStore companionsStore;

        public FileBasedCompanionsMapStore companionsStore() {
            return this.companionsStore;
        }

        public void set(AnalysisContents analysisContents) {
            CompileAnalysis analysis = analysisContents.getAnalysis();
            MiniSetup setup = analysisContents.getMiniSetup();
            File tmpAnalysisFile = File.createTempFile(this.file.getName(), ".tmp");
            Object object = !this.file.getParentFile().exists() ? BoxesRunTime.boxToBoolean((boolean)this.file.getParentFile().mkdirs()) : BoxedUnit.UNIT;
            Using$.MODULE$.zipOutputStream().apply((Object)new FileOutputStream(tmpAnalysisFile), (Function1 & Serializable & scala.Serializable)outputStream -> {
                FileBasedStoreImpl.$anonfun$set$2(this, analysis, setup, outputStream);
                return BoxedUnit.UNIT;
            });
            IO$.MODULE$.move(tmpAnalysisFile, this.file);
        }

        public Optional<AnalysisContents> get() {
            return JavaInterfaceUtil$.MODULE$.EnrichOption(Exception$.MODULE$.allCatch().opt((Function0 & Serializable & scala.Serializable)() -> this.getUncaught())).toOptional();
        }

        public AnalysisContents getUncaught() {
            return (AnalysisContents)Using$.MODULE$.zipInputStream().apply((Object)new FileInputStream(this.file), (Function1 & Serializable & scala.Serializable)inputStream -> {
                FileAnalysisStore$.MODULE$.sbt$internal$inc$FileAnalysisStore$$lookupEntry((ZipInputStream)inputStream, FileAnalysisStore$.MODULE$.sbt$internal$inc$FileAnalysisStore$$analysisFileName());
                BufferedReader writer = new BufferedReader(new InputStreamReader((InputStream)inputStream, IO$.MODULE$.utf8()));
                Tuple2<CompileAnalysis, MiniSetup> tuple2 = $this.format.read(writer, this.companionsStore());
                if (tuple2 == null) {
                    throw new MatchError(tuple2);
                }
                CompileAnalysis analysis = (CompileAnalysis)tuple2._1();
                MiniSetup setup = (MiniSetup)tuple2._2();
                Tuple2 tuple22 = new Tuple2((Object)analysis, (Object)setup);
                Tuple2 tuple23 = tuple22;
                CompileAnalysis analysis2 = (CompileAnalysis)tuple23._1();
                MiniSetup setup2 = (MiniSetup)tuple23._2();
                return AnalysisContents.create((CompileAnalysis)analysis2, (MiniSetup)setup2);
            });
        }

        public static final /* synthetic */ void $anonfun$set$2(FileBasedStoreImpl $this, CompileAnalysis analysis$3, MiniSetup setup$2, ZipOutputStream outputStream) {
            block1: {
                BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)outputStream, IO$.MODULE$.utf8()));
                outputStream.putNextEntry(new ZipEntry(FileAnalysisStore$.MODULE$.sbt$internal$inc$FileAnalysisStore$$analysisFileName()));
                $this.format.write(writer, analysis$3, setup$2);
                outputStream.closeEntry();
                if (!setup$2.storeApis()) break block1;
                outputStream.putNextEntry(new ZipEntry(FileAnalysisStore$.MODULE$.sbt$internal$inc$FileAnalysisStore$$companionsFileName()));
                CompileAnalysis compileAnalysis = analysis$3;
                if (!(compileAnalysis instanceof Analysis)) {
                    throw new MatchError((Object)compileAnalysis);
                }
                Analysis analysis = (Analysis)compileAnalysis;
                APIs aPIs = analysis.apis();
                $this.format.writeCompanionMap(writer, aPIs);
                outputStream.closeEntry();
            }
        }

        public FileBasedStoreImpl(File file, TextAnalysisFormat format) {
            this.file = file;
            this.format = format;
            this.companionsStore = new FileBasedCompanionsMapStore(file, format);
        }
    }
}

