/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ivy.core;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Stack;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.ivy.core.IvyPatternHelper$OriginalArtifactNameValue;
import org.apache.ivy.core.cache.ArtifactOrigin;
import org.apache.ivy.core.module.descriptor.Artifact;
import org.apache.ivy.core.module.id.ModuleRevisionId;
import org.apache.ivy.core.settings.IvyVariableContainer;
import org.apache.ivy.core.settings.IvyVariableContainerImpl;

public final class IvyPatternHelper {
    private static final Pattern PARAM_PATTERN = Pattern.compile("\\@\\{(.*?)\\}");
    private static final Pattern VAR_PATTERN = Pattern.compile("\\$\\{(.*?)\\}");

    public static String substitute(String string, ModuleRevisionId moduleRevisionId) {
        return IvyPatternHelper.substitute(string, moduleRevisionId.getOrganisation(), moduleRevisionId.getName(), moduleRevisionId.getBranch(), moduleRevisionId.getRevision(), "ivy", "ivy", "xml", null, null, moduleRevisionId.getQualifiedExtraAttributes(), null);
    }

    public static String substitute(String string, Artifact artifact) {
        Artifact artifact2 = artifact;
        return IvyPatternHelper.substitute(string, artifact2.getModuleRevisionId(), artifact2, null, null);
    }

    public static String substitute(String string, Artifact artifact, ArtifactOrigin artifactOrigin) {
        return IvyPatternHelper.substitute(string, artifact.getModuleRevisionId(), artifact, null, artifactOrigin);
    }

    public static String substitute(String string, ModuleRevisionId moduleRevisionId, Artifact artifact) {
        return IvyPatternHelper.substitute(string, moduleRevisionId, artifact, null, null);
    }

    public static String substitute(String string, ModuleRevisionId moduleRevisionId, Artifact artifact, String string2, ArtifactOrigin artifactOrigin) {
        return IvyPatternHelper.substitute(string, moduleRevisionId.getOrganisation(), moduleRevisionId.getName(), moduleRevisionId.getBranch(), moduleRevisionId.getRevision(), artifact.getName(), artifact.getType(), artifact.getExt(), string2, artifactOrigin, moduleRevisionId.getQualifiedExtraAttributes(), artifact.getQualifiedExtraAttributes());
    }

    public static String substitute(String string, String string2, String string3, String string4, String string5, String string6, String string7) {
        return IvyPatternHelper.substitute(string, string2, string3, null, string4, string5, string6, string7, null, null, null, null);
    }

    private static String substitute(String string, String string2, String string3, String string4, String string5, String string6, String string7, String string8, String string9, ArtifactOrigin artifactOrigin, Map map2, Map map3) {
        String string10;
        HashMap hashMap = new HashMap();
        if (map2 != null) {
            for (Map.Entry entry : map2.entrySet()) {
                string10 = (String)entry.getKey();
                if (string10.indexOf(58) > 0) {
                    string10 = string10.substring(string10.indexOf(58) + 1);
                }
                hashMap.put(string10, entry.getValue());
            }
        }
        if (map3 != null) {
            for (Map.Entry entry : map3.entrySet()) {
                string10 = (String)entry.getKey();
                if (string10.indexOf(58) > 0) {
                    string10 = string10.substring(string10.indexOf(58) + 1);
                }
                hashMap.put(string10, entry.getValue());
            }
        }
        hashMap.put("organisation", string2 == null ? "" : string2);
        hashMap.put("organization", string2 == null ? "" : string2);
        hashMap.put("orgPath", string2 == null ? "" : string2.replace('.', '/'));
        hashMap.put("module", string3 == null ? "" : string3);
        hashMap.put("branch", string4 == null ? "" : string4);
        hashMap.put("revision", string5 == null ? "" : string5);
        hashMap.put("artifact", string6 == null ? string3 : string6);
        hashMap.put("type", string7 == null ? "jar" : string7);
        hashMap.put("ext", string8 == null ? "jar" : string8);
        hashMap.put("conf", string9 == null ? "default" : string9);
        if (artifactOrigin == null) {
            hashMap.put("originalname", new IvyPatternHelper$OriginalArtifactNameValue(string2, string3, string4, string5, string6, string7, string8, map2, map3));
        } else {
            hashMap.put("originalname", new IvyPatternHelper$OriginalArtifactNameValue(artifactOrigin));
        }
        return IvyPatternHelper.substituteTokens(string, hashMap);
    }

    public static String substituteVariables(String string, Map map2) {
        return IvyPatternHelper.substituteVariables(string, new IvyVariableContainerImpl(map2), new Stack());
    }

    public static String substituteVariables(String string, IvyVariableContainer ivyVariableContainer) {
        return IvyPatternHelper.substituteVariables(string, ivyVariableContainer, new Stack());
    }

    private static String substituteVariables(String string, IvyVariableContainer ivyVariableContainer, Stack stack) {
        if (string == null) {
            return null;
        }
        Matcher matcher = VAR_PATTERN.matcher(string);
        boolean bl = false;
        StringBuffer stringBuffer = null;
        while (matcher.find()) {
            String string2;
            String string3;
            if (!bl) {
                bl = true;
                stringBuffer = new StringBuffer();
            }
            if ((string3 = ivyVariableContainer.getVariable(string2 = matcher.group(1))) != null) {
                int n = stack.indexOf(string2);
                if (n != -1) {
                    ArrayList<String> arrayList = new ArrayList<String>(stack.subList(n, stack.size()));
                    arrayList.add(string2);
                    throw new IllegalArgumentException("cyclic variable definition: cycle = " + arrayList);
                }
                stack.push(string2);
                string3 = IvyPatternHelper.substituteVariables(string3, ivyVariableContainer, stack);
                stack.pop();
            } else {
                string3 = matcher.group();
            }
            matcher.appendReplacement(stringBuffer, string3.replaceAll("\\\\", "\\\\\\\\").replaceAll("\\$", "\\\\\\$"));
        }
        if (bl) {
            matcher.appendTail(stringBuffer);
            return stringBuffer.toString();
        }
        return string;
    }

    public static String substituteTokens(String string, Map map2) {
        CharSequence charSequence;
        HashMap hashMap = new HashMap(map2);
        if (hashMap.containsKey("organisation") && !hashMap.containsKey("organization")) {
            hashMap.put("organization", hashMap.get("organisation"));
        }
        if (hashMap.containsKey("organisation") && !hashMap.containsKey("orgPath")) {
            charSequence = (String)hashMap.get("organisation");
            hashMap.put("orgPath", charSequence == null ? "" : ((String)charSequence).replace('.', '/'));
        }
        charSequence = new StringBuffer();
        char[] cArray = string.toCharArray();
        StringBuffer stringBuffer = null;
        StringBuffer stringBuffer2 = null;
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        block6: for (int i = 0; i < cArray.length; ++i) {
            switch (cArray[i]) {
                case '(': {
                    if (bl) {
                        throw new IllegalArgumentException("invalid start of optional part at position " + i + " in pattern " + string);
                    }
                    stringBuffer = new StringBuffer();
                    bl = true;
                    bl3 = false;
                    bl4 = false;
                    continue block6;
                }
                case ')': {
                    if (!bl || bl2) {
                        throw new IllegalArgumentException("invalid end of optional part at position " + i + " in pattern " + string);
                    }
                    if (bl4) {
                        ((StringBuffer)charSequence).append(stringBuffer.toString());
                    } else if (!bl3) {
                        ((StringBuffer)charSequence).append('(').append(stringBuffer.toString()).append(')');
                    }
                    bl = false;
                    continue block6;
                }
                case '[': {
                    if (bl2) {
                        throw new IllegalArgumentException("invalid start of token at position " + i + " in pattern " + string);
                    }
                    stringBuffer2 = new StringBuffer();
                    bl2 = true;
                    continue block6;
                }
                case ']': {
                    String string2;
                    if (!bl2) {
                        throw new IllegalArgumentException("invalid end of token at position " + i + " in pattern " + string);
                    }
                    String string3 = stringBuffer2.toString();
                    Object v = hashMap.get(string3);
                    String string4 = string2 = v == null ? null : v.toString();
                    if (bl) {
                        bl4 = string2 != null && string2.length() > 0;
                        stringBuffer.append(string2);
                    } else {
                        if (string2 == null) {
                            string2 = "[" + string3 + "]";
                        }
                        ((StringBuffer)charSequence).append(string2);
                    }
                    bl2 = false;
                    bl3 = true;
                    continue block6;
                }
                default: {
                    if (bl2) {
                        stringBuffer2.append(cArray[i]);
                        continue block6;
                    }
                    if (bl) {
                        stringBuffer.append(cArray[i]);
                        continue block6;
                    }
                    ((StringBuffer)charSequence).append(cArray[i]);
                }
            }
        }
        if (bl2) {
            throw new IllegalArgumentException("last token hasn't been closed in pattern " + string);
        }
        if (bl) {
            throw new IllegalArgumentException("optional part hasn't been closed in pattern " + string);
        }
        return ((StringBuffer)charSequence).toString();
    }

    public static String substituteToken(String string, String string2, String string3) {
        StringBuffer stringBuffer = new StringBuffer(string);
        IvyPatternHelper.substituteToken(stringBuffer, string2, string3);
        return stringBuffer.toString();
    }

    private static void substituteToken(StringBuffer stringBuffer, String string, String string2) {
        String string3 = IvyPatternHelper.getTokenString(string);
        int n = string3.length();
        int n2 = stringBuffer.indexOf(string3);
        while (n2 != -1) {
            stringBuffer.replace(n2, n2 + n, string2);
            n2 = stringBuffer.indexOf(string3, n2);
        }
    }

    public static String getTokenString(String string) {
        return "[" + string + "]";
    }

    public static String substituteParams(String string, Map map2) {
        return IvyPatternHelper.substituteParams(string, new IvyVariableContainerImpl(map2), new Stack());
    }

    private static String substituteParams(String string, IvyVariableContainer ivyVariableContainer, Stack stack) {
        if (string == null) {
            return null;
        }
        Matcher matcher = PARAM_PATTERN.matcher(string);
        StringBuffer stringBuffer = new StringBuffer();
        while (matcher.find()) {
            String string2 = matcher.group(1);
            String string3 = ivyVariableContainer.getVariable(string2);
            if (string3 != null) {
                int n = stack.indexOf(string2);
                if (n != -1) {
                    ArrayList<String> arrayList = new ArrayList<String>(stack.subList(n, stack.size()));
                    arrayList.add(string2);
                    throw new IllegalArgumentException("cyclic param definition: cycle = " + arrayList);
                }
                stack.push(string2);
                string3 = IvyPatternHelper.substituteVariables(string3, ivyVariableContainer, stack);
                stack.pop();
            } else {
                string3 = matcher.group();
            }
            matcher.appendReplacement(stringBuffer, string3.replaceAll("\\\\", "\\\\\\\\").replaceAll("\\@", "\\\\\\@"));
        }
        matcher.appendTail(stringBuffer);
        return stringBuffer.toString();
    }

    public static String getTokenRoot(String string) {
        int n = string.indexOf(91);
        if (n == -1) {
            return string;
        }
        int n2 = string.indexOf(40);
        if (n2 >= 0) {
            n = Math.min(n, n2);
        }
        return string.substring(0, n);
    }
}

