/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ivy.core.module.descriptor;

import java.net.URL;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.apache.ivy.core.module.descriptor.AbstractArtifact;
import org.apache.ivy.core.module.descriptor.ModuleDescriptor;
import org.apache.ivy.core.module.id.ArtifactRevisionId;
import org.apache.ivy.core.module.id.ModuleRevisionId;

public final class MDArtifact
extends AbstractArtifact {
    private ModuleDescriptor md;
    private String name;
    private String type;
    private String ext;
    private List confs = new ArrayList();
    private Map extraAttributes = null;
    private URL url;

    public MDArtifact(ModuleDescriptor moduleDescriptor, String string, String string2, String string3) {
        this(moduleDescriptor, string, string2, string3, null, null);
    }

    public MDArtifact(ModuleDescriptor moduleDescriptor, String string, String string2, String string3, URL uRL, Map map2) {
        if (moduleDescriptor == null) {
            throw new NullPointerException("null module descriptor not allowed");
        }
        if (string == null) {
            throw new NullPointerException("null name not allowed");
        }
        if (string2 == null) {
            throw new NullPointerException("null type not allowed");
        }
        if (string3 == null) {
            throw new NullPointerException("null ext not allowed");
        }
        this.md = moduleDescriptor;
        this.name = string;
        this.type = string2;
        this.ext = string3;
        this.url = uRL;
        this.extraAttributes = map2;
    }

    @Override
    public final ModuleRevisionId getModuleRevisionId() {
        return this.md.getResolvedModuleRevisionId();
    }

    @Override
    public final Date getPublicationDate() {
        return this.md.getResolvedPublicationDate();
    }

    @Override
    public final ArtifactRevisionId getId() {
        return ArtifactRevisionId.newInstance(this.md.getResolvedModuleRevisionId(), this.name, this.type, this.ext, this.extraAttributes);
    }

    @Override
    public final String getName() {
        return this.name;
    }

    @Override
    public final String getType() {
        return this.type;
    }

    @Override
    public final String getExt() {
        return this.ext;
    }

    public final String[] getConfigurations() {
        return this.confs.toArray(new String[this.confs.size()]);
    }

    public final void addConfiguration(String string) {
        this.confs.add(string);
    }

    @Override
    public final URL getUrl() {
        return this.url;
    }

    @Override
    public final boolean isMetadata() {
        return false;
    }
}

