/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ivy.plugins.parser.m2;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.text.ParseException;
import java.util.Date;
import java.util.Map;
import org.apache.ivy.core.IvyContext;
import org.apache.ivy.core.cache.ArtifactOrigin;
import org.apache.ivy.core.module.descriptor.Artifact;
import org.apache.ivy.core.module.descriptor.Configuration;
import org.apache.ivy.core.module.descriptor.Configuration$Visibility;
import org.apache.ivy.core.module.descriptor.DefaultArtifact;
import org.apache.ivy.core.module.descriptor.DefaultDependencyDescriptor;
import org.apache.ivy.core.module.descriptor.DependencyDescriptor;
import org.apache.ivy.core.module.descriptor.License;
import org.apache.ivy.core.module.descriptor.ModuleDescriptor;
import org.apache.ivy.core.module.id.ModuleRevisionId;
import org.apache.ivy.core.resolve.ResolveData;
import org.apache.ivy.core.resolve.ResolveEngine;
import org.apache.ivy.core.resolve.ResolveOptions;
import org.apache.ivy.core.resolve.ResolvedModuleRevision;
import org.apache.ivy.plugins.namespace.Namespace;
import org.apache.ivy.plugins.parser.ModuleDescriptorParser;
import org.apache.ivy.plugins.parser.ParserSettings;
import org.apache.ivy.plugins.parser.m2.DefaultPomDependencyMgt;
import org.apache.ivy.plugins.parser.m2.PomDependencyMgt;
import org.apache.ivy.plugins.parser.m2.PomModuleDescriptorBuilder;
import org.apache.ivy.plugins.parser.m2.PomModuleDescriptorBuilder$PomDependencyDescriptor;
import org.apache.ivy.plugins.parser.m2.PomReader;
import org.apache.ivy.plugins.parser.m2.PomReader$PomDependencyData;
import org.apache.ivy.plugins.parser.m2.PomReader$PomDependencyMgtElement;
import org.apache.ivy.plugins.parser.xml.UpdateOptions;
import org.apache.ivy.plugins.repository.Resource;
import org.apache.ivy.plugins.repository.url.URLResource;
import org.apache.ivy.plugins.resolver.DependencyResolver;
import org.apache.ivy.util.Message;
import org.xml.sax.SAXException;

public final class PomModuleDescriptorParser
implements ModuleDescriptorParser {
    private static final PomModuleDescriptorParser INSTANCE = new PomModuleDescriptorParser();

    public static PomModuleDescriptorParser getInstance() {
        return INSTANCE;
    }

    private PomModuleDescriptorParser() {
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public final void toIvyFile(InputStream inputStream, Resource resource, File file2, ModuleDescriptor moduleDescriptor) {
        try {
            UpdateOptions.write(moduleDescriptor, file2);
            if (inputStream == null) return;
        }
        catch (Throwable throwable) {
            if (inputStream == null) throw throwable;
            inputStream.close();
            throw throwable;
        }
        inputStream.close();
    }

    @Override
    public final boolean accept(Resource resource) {
        return resource.getName().endsWith(".pom") || resource.getName().endsWith("pom.xml") || resource.getName().endsWith("project.xml");
    }

    public final String toString() {
        return "pom parser";
    }

    @Override
    public final Artifact getMetadataArtifact(ModuleRevisionId moduleRevisionId, Resource resource) {
        return DefaultArtifact.newPomArtifact(moduleRevisionId, new Date(resource.getLastModified()));
    }

    @Override
    public final ModuleDescriptor parseDescriptor(ParserSettings parserSettings, URL uRL, boolean bl) {
        URLResource uRLResource = new URLResource(uRL);
        return this.parseDescriptor(parserSettings, uRL, uRLResource, bl);
    }

    @Override
    public final ModuleDescriptor parseDescriptor(ParserSettings parserSettings, URL uRL, Resource resource, boolean bl) {
        PomModuleDescriptorBuilder pomModuleDescriptorBuilder;
        block39: {
            pomModuleDescriptorBuilder = new PomModuleDescriptorBuilder(this, resource, parserSettings);
            try {
                Object object;
                Object object22;
                Object object3;
                PomReader pomReader = new PomReader(uRL, resource);
                pomReader.setProperty("parent.version", pomReader.getParentVersion());
                pomReader.setProperty("parent.groupId", pomReader.getParentGroupId());
                pomReader.setProperty("project.parent.version", pomReader.getParentVersion());
                pomReader.setProperty("project.parent.groupId", pomReader.getParentGroupId());
                for (Map.Entry object52 : pomReader.getPomProperties().entrySet()) {
                    pomReader.setProperty((String)object52.getKey(), (String)object52.getValue());
                    pomModuleDescriptorBuilder.addProperty((String)object52.getKey(), (String)object52.getValue());
                }
                Object object6 = null;
                if (pomReader.hasParent()) {
                    ModuleRevisionId moduleRevisionId = ModuleRevisionId.newInstance(pomReader.getParentGroupId(), pomReader.getParentArtifactId(), pomReader.getParentVersion());
                    object3 = PomModuleDescriptorParser.parseOtherPom(parserSettings, moduleRevisionId);
                    if (object3 == null) {
                        throw new IOException("Impossible to load parent for " + resource.getName() + ". Parent=" + moduleRevisionId);
                    }
                    object6 = ((ResolvedModuleRevision)object3).getDescriptor();
                    if (object6 != null) {
                        for (Map.Entry entry : PomModuleDescriptorBuilder.extractPomProperties(object6.getExtraInfo()).entrySet()) {
                            pomReader.setProperty((String)entry.getKey(), (String)entry.getValue());
                        }
                    }
                }
                String string = pomReader.getGroupId();
                object3 = pomReader.getArtifactId();
                String string2 = pomReader.getVersion();
                pomModuleDescriptorBuilder.setModuleRevId(string, (String)object3, string2);
                pomModuleDescriptorBuilder.setHomePage(pomReader.getHomePage());
                pomModuleDescriptorBuilder.setDescription(pomReader.getDescription());
                License[] licenseArray = pomReader.getLicenses();
                if (licenseArray != null && licenseArray.length > 0) {
                    pomModuleDescriptorBuilder.setLicenses(licenseArray);
                } else if (object6 != null) {
                    pomModuleDescriptorBuilder.setLicenses(object6.getLicenses());
                }
                ModuleRevisionId moduleRevisionId = pomReader.getRelocation();
                if (moduleRevisionId != null) {
                    if (string != null && object3 != null && ((String)object3).equals(moduleRevisionId.getName()) && string.equals(moduleRevisionId.getOrganisation())) {
                        Message.error("Relocation to an other version number not supported in ivy : " + pomModuleDescriptorBuilder.getModuleDescriptor().getModuleRevisionId() + " relocated to " + moduleRevisionId + ". Please update your dependency to directly use the right version.");
                        Message.warn("Resolution will only pick dependencies of the relocated element.  Artefact and other metadata will be ignored.");
                        ResolvedModuleRevision resolvedModuleRevision = PomModuleDescriptorParser.parseOtherPom(parserSettings, moduleRevisionId);
                        if (resolvedModuleRevision == null) {
                            throw new ParseException("impossible to load module " + moduleRevisionId + " to which " + pomModuleDescriptorBuilder.getModuleDescriptor().getModuleRevisionId() + " has been relocated", 0);
                        }
                        DependencyDescriptor[] dependencyDescriptorArray = resolvedModuleRevision.getDescriptor().getDependencies();
                        for (int i = 0; i < dependencyDescriptorArray.length; ++i) {
                            pomModuleDescriptorBuilder.addDependency(dependencyDescriptorArray[i]);
                        }
                    } else {
                        Message.info(pomModuleDescriptorBuilder.getModuleDescriptor().getModuleRevisionId() + " is relocated to " + moduleRevisionId + ". Please update your dependencies.");
                        Message.verbose("Relocated module will be considered as a dependency");
                        DefaultDependencyDescriptor defaultDependencyDescriptor = new DefaultDependencyDescriptor(pomModuleDescriptorBuilder.getModuleDescriptor(), moduleRevisionId, true, true);
                        Configuration[] configurationArray = PomModuleDescriptorBuilder.MAVEN2_CONFIGURATIONS;
                        for (int i = 0; i < configurationArray.length; ++i) {
                            if (!Configuration$Visibility.PUBLIC.equals(configurationArray[i].getVisibility())) continue;
                            defaultDependencyDescriptor.addDependencyConfiguration(configurationArray[i].getName(), configurationArray[i].getName());
                        }
                        pomModuleDescriptorBuilder.addDependency(defaultDependencyDescriptor);
                    }
                    break block39;
                }
                pomReader.setProperty("project.groupId", string);
                pomReader.setProperty("pom.groupId", string);
                pomReader.setProperty("groupId", string);
                pomReader.setProperty("project.artifactId", (String)object3);
                pomReader.setProperty("pom.artifactId", (String)object3);
                pomReader.setProperty("artifactId", (String)object3);
                pomReader.setProperty("project.version", string2);
                pomReader.setProperty("pom.version", string2);
                pomReader.setProperty("version", string2);
                if (object6 != null) {
                    pomModuleDescriptorBuilder.addExtraInfos(object6.getExtraInfo());
                    for (Object object22 : PomModuleDescriptorBuilder.getDependencyManagements((ModuleDescriptor)object6)) {
                        if (object22 instanceof PomReader$PomDependencyMgtElement) {
                            PomReader pomReader2 = pomReader;
                            pomReader2.getClass();
                            object22 = new PomReader$PomDependencyMgtElement(pomReader2, (PomReader$PomDependencyMgtElement)object22);
                        }
                        pomModuleDescriptorBuilder.addDependencyMgt((PomDependencyMgt)object22);
                    }
                    object22 = PomModuleDescriptorBuilder.getPlugins((ModuleDescriptor)object6).iterator();
                    while (object22.hasNext()) {
                        pomModuleDescriptorBuilder.addPlugin((PomDependencyMgt)object22.next());
                    }
                }
                for (Object object4 : pomReader.getDependencyMgt()) {
                    if ("import".equals(object4.getScope())) {
                        object22 = ModuleRevisionId.newInstance(object4.getGroupId(), object4.getArtifactId(), object4.getVersion());
                        object = PomModuleDescriptorParser.parseOtherPom(parserSettings, (ModuleRevisionId)object22);
                        if (object != null) {
                            for (PomDependencyMgt pomDependencyMgt : PomModuleDescriptorBuilder.getDependencyManagements(((ResolvedModuleRevision)object).getDescriptor())) {
                                pomModuleDescriptorBuilder.addDependencyMgt(new DefaultPomDependencyMgt(pomDependencyMgt.getGroupId(), pomDependencyMgt.getArtifactId(), pomDependencyMgt.getVersion(), pomDependencyMgt.getScope(), pomDependencyMgt.getExcludedModules()));
                            }
                            continue;
                        }
                        throw new IOException("Impossible to import module for " + resource.getName() + ". Import=" + object22);
                    }
                    pomModuleDescriptorBuilder.addDependencyMgt((PomDependencyMgt)object4);
                }
                for (Object object4 : pomReader.getDependencies()) {
                    pomModuleDescriptorBuilder.addDependency$16c309e6((PomReader$PomDependencyData)object4);
                }
                if (object6 != null) {
                    for (int i = 0; i < object6.getDependencies().length; ++i) {
                        Object object4;
                        object4 = object6.getDependencies()[i];
                        if (object4 instanceof PomModuleDescriptorBuilder$PomDependencyDescriptor) {
                            object22 = ((PomModuleDescriptorBuilder$PomDependencyDescriptor)object4).getPomDependencyData();
                            PomReader pomReader3 = pomReader;
                            pomReader3.getClass();
                            object = new PomReader$PomDependencyData(pomReader3, (PomReader$PomDependencyData)object22);
                            pomModuleDescriptorBuilder.addDependency$16c309e6((PomReader$PomDependencyData)object);
                            continue;
                        }
                        pomModuleDescriptorBuilder.addDependency((DependencyDescriptor)object4);
                    }
                }
                for (Object object4 : pomReader.getPlugins()) {
                    pomModuleDescriptorBuilder.addPlugin((PomDependencyMgt)object4);
                }
                pomModuleDescriptorBuilder.addMainArtifact((String)object3, pomReader.getPackaging());
                ParserSettings parserSettings2 = parserSettings;
                PomModuleDescriptorBuilder pomModuleDescriptorBuilder2 = pomModuleDescriptorBuilder;
                if (pomModuleDescriptorBuilder2.getMainArtifact() != null) {
                    ModuleRevisionId moduleRevisionId2 = pomModuleDescriptorBuilder2.getModuleDescriptor().getModuleRevisionId();
                    DependencyResolver dependencyResolver = parserSettings2.getResolver(moduleRevisionId2);
                    if (dependencyResolver == null) {
                        Message.debug("no resolver found for " + moduleRevisionId2 + ": no source or javadoc artifact lookup");
                    } else {
                        ArtifactOrigin artifactOrigin = dependencyResolver.locate(pomModuleDescriptorBuilder2.getMainArtifact());
                        if (!ArtifactOrigin.isUnknown(artifactOrigin)) {
                            ArtifactOrigin artifactOrigin2;
                            String string3 = artifactOrigin.getLocation();
                            ArtifactOrigin artifactOrigin3 = dependencyResolver.locate(pomModuleDescriptorBuilder2.getSourceArtifact());
                            if (!ArtifactOrigin.isUnknown(artifactOrigin3) && !artifactOrigin3.getLocation().equals(string3)) {
                                Message.debug("source artifact found for " + moduleRevisionId2);
                                pomModuleDescriptorBuilder2.addSourceArtifact();
                            } else {
                                artifactOrigin2 = dependencyResolver.locate(pomModuleDescriptorBuilder2.getSrcArtifact());
                                if (!ArtifactOrigin.isUnknown(artifactOrigin2) && !artifactOrigin2.getLocation().equals(string3)) {
                                    Message.debug("source artifact found for " + moduleRevisionId2);
                                    pomModuleDescriptorBuilder2.addSrcArtifact();
                                } else {
                                    Message.debug("no source artifact found for " + moduleRevisionId2);
                                }
                            }
                            artifactOrigin2 = dependencyResolver.locate(pomModuleDescriptorBuilder2.getJavadocArtifact());
                            if (!ArtifactOrigin.isUnknown(artifactOrigin2) && !artifactOrigin2.getLocation().equals(string3)) {
                                Message.debug("javadoc artifact found for " + moduleRevisionId2);
                                pomModuleDescriptorBuilder2.addJavadocArtifact();
                            } else {
                                Message.debug("no javadoc artifact found for " + moduleRevisionId2);
                            }
                        }
                    }
                }
            }
            catch (SAXException sAXException) {
                SAXException sAXException2 = sAXException;
                Message.error(((Throwable)sAXException).getMessage());
                ParseException parseException = new ParseException(((Throwable)sAXException2).getMessage(), 0);
                parseException.initCause(sAXException2);
                throw parseException;
            }
        }
        return pomModuleDescriptorBuilder.getModuleDescriptor();
    }

    private static ResolvedModuleRevision parseOtherPom(ParserSettings parserSettings, ModuleRevisionId moduleRevisionId) {
        Object object;
        DependencyDescriptor dependencyDescriptor = new DefaultDependencyDescriptor(moduleRevisionId, true);
        ResolveData resolveData = IvyContext.getContext().getResolveData();
        if (resolveData == null) {
            object = IvyContext.getContext().getIvy().getResolveEngine();
            ResolveOptions resolveOptions = new ResolveOptions();
            resolveOptions.setDownload$5370cc5a();
            resolveData = new ResolveData((ResolveEngine)object, resolveOptions);
        }
        if ((object = parserSettings.getResolver(moduleRevisionId)) == null) {
            return null;
        }
        Namespace namespace = parserSettings.getContextNamespace();
        dependencyDescriptor = DefaultDependencyDescriptor.transformInstance(dependencyDescriptor, namespace);
        return object.getDependency(dependencyDescriptor, resolveData);
    }
}

