/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ivy.plugins.repository;

import javax.swing.event.EventListenerList;
import org.apache.ivy.plugins.repository.Repository;
import org.apache.ivy.plugins.repository.Resource;
import org.apache.ivy.plugins.repository.TransferEvent;
import org.apache.ivy.plugins.repository.TransferListener;

public abstract class AbstractRepository
implements Repository {
    private EventListenerList listeners = new EventListenerList();
    private String name;
    private TransferEvent evt;

    @Override
    public final void addTransferListener(TransferListener transferListener) {
        this.listeners.add(TransferListener.class, transferListener);
    }

    @Override
    public final void removeTransferListener(TransferListener transferListener) {
        this.listeners.remove(TransferListener.class, transferListener);
    }

    protected final void fireTransferInitiated$553fe46a(Resource resource) {
        this.evt = new TransferEvent(resource, 5);
        this.fireTransferEvent(this.evt);
    }

    protected final void fireTransferStarted() {
        this.evt.setEventType(1);
        this.fireTransferEvent(this.evt);
    }

    protected final void fireTransferStarted(long l) {
        this.evt.setEventType(1);
        this.evt.setTotalLength(l);
        this.evt.setTotalLengthSet$1385ff();
        this.fireTransferEvent(this.evt);
    }

    protected final void fireTransferProgress(long l) {
        this.evt.setEventType(3);
        if (!this.evt.isTotalLengthSet()) {
            this.evt.setTotalLength(this.evt.getTotalLength() + l);
        }
        this.fireTransferEvent(this.evt);
    }

    protected final void fireTransferCompleted() {
        this.evt.setEventType(2);
        if (this.evt.getTotalLength() > 0L && !this.evt.isTotalLengthSet()) {
            this.evt.setTotalLengthSet$1385ff();
        }
        this.fireTransferEvent(this.evt);
    }

    protected final void fireTransferError$698b7e31() {
        this.evt.setEventType(4);
        this.fireTransferEvent(this.evt);
    }

    private void fireTransferEvent(TransferEvent transferEvent) {
        Object[] objectArray = this.listeners.getListenerList();
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != TransferListener.class) continue;
            ((TransferListener)objectArray[i + 1]).transferProgress(transferEvent);
        }
    }

    @Override
    public String getFileSeparator() {
        return "/";
    }

    @Override
    public String standardize(String string) {
        return string.replace('\\', '/');
    }

    @Override
    public final String getName() {
        return this.name;
    }

    public final void setName(String string) {
        this.name = string;
    }

    public String toString() {
        return this.name;
    }
}

