/*
 * Decompiled with CFR 0.152.
 */
package sbt;

import java.io.File;
import java.io.Serializable;
import sbt.internal.inc.Relations;
import sbt.internal.util.Relation;
import sbt.io.IO$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Option$;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.Iterable$;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.immutable.Map$;
import scala.collection.immutable.Set;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.HashSet;
import scala.collection.mutable.HashSet$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;

public final class DotGraph$ {
    public static DotGraph$ MODULE$;

    static {
        new DotGraph$();
    }

    private Function1<File, String> fToString(Iterable<File> roots) {
        return (Function1 & Serializable & scala.Serializable)x -> MODULE$.sourceToString(roots, (File)x);
    }

    public void sources(Relations relations, File outputDirectory, Iterable<File> sourceRoots) {
        Function1<File, String> toString = this.fToString(sourceRoots);
        this.apply(relations, outputDirectory, toString, toString);
    }

    public void packages(Relations relations, File outputDirectory, Iterable<File> sourceRoots) {
        Function1 & Serializable & scala.Serializable packageOnly = (Function1 & Serializable & scala.Serializable)path -> {
            int last = path.lastIndexOf(File.separatorChar);
            String packagePath = (last > 0 ? path.substring(0, last) : path).trim();
            return packagePath.isEmpty() ? "" : packagePath.replace(File.separatorChar, '.');
        };
        Function1 toString = packageOnly.compose(this.fToString(sourceRoots));
        this.apply(relations, outputDirectory, (Function1<File, String>)toString, (Function1<File, String>)toString);
    }

    public void apply(Relations relations, File outputDir, Function1<File, String> sourceToString, Function1<File, String> externalToString) {
        IO$.MODULE$.createDirectory(outputDir);
        this.generateGraph(DotGraph$.file$1("int-class-deps", outputDir), "dependencies", relations.internalClassDep(), (Function1 & Serializable & scala.Serializable)x -> (String)Predef$.MODULE$.identity(x), (Function1 & Serializable & scala.Serializable)x -> (String)Predef$.MODULE$.identity(x));
        this.generateGraph(DotGraph$.file$1("binary-dependencies", outputDir), "externalDependencies", relations.libraryDep(), externalToString, sourceToString);
    }

    public <K, V> void generateGraph(File file, String graphName, Relation<K, V> relation, Function1<K, String> keyToString, Function1<V, String> valueToString) {
        HashMap mappedGraph = new HashMap();
        ((IterableLike)relation.forwardMap().withFilter((Function1 & Serializable & scala.Serializable)check$ifrefutable$1 -> BoxesRunTime.boxToBoolean((boolean)DotGraph$.$anonfun$generateGraph$1(check$ifrefutable$1))).map((Function1 & Serializable & scala.Serializable)x$2 -> {
            Tuple2 tuple2 = x$2;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            Object key = tuple2._1();
            String keyString = (String)keyToString.apply(key);
            Tuple2 tuple22 = new Tuple2((Object)tuple2, (Object)keyString);
            return tuple22;
        }, Map$.MODULE$.canBuildFrom())).foreach((Function1 & Serializable & scala.Serializable)x$3 -> {
            DotGraph$.$anonfun$generateGraph$3(valueToString, mappedGraph, x$3);
            return BoxedUnit.UNIT;
        });
        Seq mappings = (Seq)mappedGraph.toSeq().withFilter((Function1 & Serializable & scala.Serializable)check$ifrefutable$2 -> BoxesRunTime.boxToBoolean((boolean)DotGraph$.$anonfun$generateGraph$6(check$ifrefutable$2))).flatMap((Function1 & Serializable & scala.Serializable)x$4 -> {
            Tuple2 tuple2 = x$4;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            String dependsOn = (String)tuple2._1();
            HashSet dependants = (HashSet)tuple2._2();
            HashSet hashSet = (HashSet)dependants.withFilter((Function1 & Serializable & scala.Serializable)dependant -> BoxesRunTime.boxToBoolean((boolean)DotGraph$.$anonfun$generateGraph$8(dependsOn, dependant))).map((Function1 & Serializable & scala.Serializable)dependant -> new StringBuilder(8).append("\"").append((String)dependant).append("\" -> \"").append(dependsOn).append("\"").toString(), HashSet$.MODULE$.canBuildFrom());
            return hashSet;
        }, Seq$.MODULE$.canBuildFrom());
        String string = new StringBuilder(10).append("digraph ").append(graphName).append(" {").toString();
        Seq lines = (Seq)((SeqLike)mappings.$plus$colon((Object)string, Seq$.MODULE$.canBuildFrom())).$colon$plus((Object)"}", Seq$.MODULE$.canBuildFrom());
        IO$.MODULE$.writeLines(file, lines, IO$.MODULE$.writeLines$default$3(), IO$.MODULE$.writeLines$default$4());
    }

    public String sourceToString(Iterable<File> roots, File source) {
        return new StringOps(Predef$.MODULE$.augmentString(new StringOps(Predef$.MODULE$.augmentString(this.relativized(roots, source).trim())).stripSuffix(".scala"))).stripSuffix(".java");
    }

    private String relativized(Iterable<File> roots, File path) {
        Iterable relativized = (Iterable)roots.flatMap((Function1 & Serializable & scala.Serializable)root -> Option$.MODULE$.option2Iterable(IO$.MODULE$.relativize(root, path)), Iterable$.MODULE$.canBuildFrom());
        int n = Integer.MAX_VALUE;
        int shortest = BoxesRunTime.unboxToInt((Object)relativized.$div$colon((Object)BoxesRunTime.boxToInteger((int)n), (Function2 & Serializable & scala.Serializable)(x$7, x$8) -> BoxesRunTime.boxToInteger((int)RichInt$.MODULE$.min$extension(Predef$.MODULE$.intWrapper(BoxesRunTime.unboxToInt((Object)x$7)), x$8.length()))));
        return (String)relativized.find((Function1 & Serializable & scala.Serializable)x$9 -> BoxesRunTime.boxToBoolean((boolean)DotGraph$.$anonfun$relativized$3(shortest, x$9))).getOrElse((Function0 & Serializable & scala.Serializable)() -> path.getName());
    }

    private static final File file$1(String name, File outputDir$1) {
        return new File(outputDir$1, name);
    }

    public static final /* synthetic */ boolean $anonfun$generateGraph$1(Tuple2 check$ifrefutable$1) {
        Tuple2 tuple2 = check$ifrefutable$1;
        boolean bl = tuple2 != null;
        return bl;
    }

    public static final /* synthetic */ void $anonfun$generateGraph$3(Function1 valueToString$1, HashMap mappedGraph$1, Tuple2 x$3) {
        String keyString;
        Tuple2 tuple2;
        block3: {
            Tuple2 tuple22;
            block2: {
                tuple22 = x$3;
                if (tuple22 == null) break block2;
                tuple2 = (Tuple2)tuple22._1();
                keyString = (String)tuple22._2();
                if (tuple2 != null) break block3;
            }
            throw new MatchError((Object)tuple22);
        }
        Set values = (Set)tuple2._2();
        values.foreach((Function1 & Serializable & scala.Serializable)value -> ((HashSet)mappedGraph$1.getOrElseUpdate((Object)keyString, (Function0 & Serializable & scala.Serializable)() -> new HashSet())).$plus$eq(valueToString$1.apply(value)));
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ boolean $anonfun$generateGraph$6(Tuple2 check$ifrefutable$2) {
        Tuple2 tuple2 = check$ifrefutable$2;
        boolean bl = tuple2 != null;
        return bl;
    }

    public static final /* synthetic */ boolean $anonfun$generateGraph$8(String dependsOn$1, String dependant) {
        String string = dependant;
        String string2 = dependsOn$1;
        return (string == null ? string2 != null : !string.equals(string2)) && !dependsOn$1.isEmpty() && !dependant.isEmpty();
    }

    public static final /* synthetic */ boolean $anonfun$relativized$3(int shortest$1, String x$9) {
        return x$9.length() == shortest$1;
    }

    private DotGraph$() {
        MODULE$ = this;
    }
}

