/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ivy.ant;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import org.apache.ivy.Ivy;
import org.apache.ivy.ant.IvyTask;
import org.apache.ivy.core.module.descriptor.DependencyDescriptor;
import org.apache.ivy.core.module.descriptor.ModuleDescriptor;
import org.apache.ivy.core.module.id.ModuleId;
import org.apache.ivy.core.settings.IvySettings;
import org.apache.ivy.core.sort.SortOptions;
import org.apache.ivy.plugins.parser.ModuleDescriptorParserRegistry;
import org.apache.ivy.util.Message;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.types.FileSet;
import org.apache.tools.ant.types.Path;

public class IvyBuildList
extends IvyTask {
    public static final String DESCRIPTOR_REQUIRED = "required";
    private List buildFileSets = new ArrayList();
    private String reference;
    private boolean haltOnError = true;
    private String onMissingDescriptor = "head";
    private boolean reverse = false;
    private String ivyFilePath;
    private String root = "*";
    private boolean excludeRoot = false;
    private String leaf = "*";
    private String delimiter = ",";
    private boolean excludeLeaf = false;
    private boolean onlydirectdep = false;
    private String restartFrom = "*";

    public void addFileset(FileSet fileSet) {
        this.buildFileSets.add(fileSet);
    }

    public String getReference() {
        return this.reference;
    }

    public void setReference(String string) {
        this.reference = string;
    }

    public String getRoot() {
        return this.root;
    }

    public void setRoot(String string) {
        this.root = string;
    }

    public boolean isExcludeRoot() {
        return this.excludeRoot;
    }

    public void setExcludeRoot(boolean bl) {
        this.excludeRoot = bl;
    }

    public String getLeaf() {
        return this.leaf;
    }

    public void setLeaf(String string) {
        this.leaf = string;
    }

    public boolean isExcludeLeaf() {
        return this.excludeLeaf;
    }

    public void setExcludeLeaf(boolean bl) {
        this.excludeLeaf = bl;
    }

    public String getDelimiter() {
        return this.delimiter;
    }

    public void setDelimiter(String string) {
        this.delimiter = string;
    }

    public boolean getOnlydirectdep() {
        return this.onlydirectdep;
    }

    public void setOnlydirectdep(boolean bl) {
        this.onlydirectdep = bl;
    }

    @Override
    public void doExecute() throws BuildException {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        Object object5;
        Object object6;
        Object object7;
        Object object8;
        Object object9;
        if (this.reference == null) {
            throw new BuildException("reference should be provided in ivy build list");
        }
        if (this.buildFileSets.isEmpty()) {
            throw new BuildException("at least one nested fileset should be provided in ivy build list");
        }
        Ivy ivy = this.getIvyInstance();
        IvySettings ivySettings = ivy.getSettings();
        this.ivyFilePath = this.getProperty(this.ivyFilePath, ivySettings, "ivy.buildlist.ivyfilepath");
        Path path = new Path(this.getProject());
        HashMap<ModuleDescriptor, File> hashMap = new HashMap<ModuleDescriptor, File>();
        ArrayList<ListIterator<ModuleDescriptor>> arrayList = new ArrayList<ListIterator<ModuleDescriptor>>();
        ArrayList arrayList2 = new ArrayList();
        Collection<ModuleDescriptor> collection = new ArrayList();
        LinkedHashSet<String> linkedHashSet = new LinkedHashSet<String>();
        if (!"*".equals(this.root)) {
            object9 = new StringTokenizer(this.root, this.delimiter);
            while (((StringTokenizer)object9).hasMoreTokens()) {
                linkedHashSet.add(((StringTokenizer)object9).nextToken());
            }
        }
        object9 = new LinkedHashSet();
        if (!"*".equals(this.leaf)) {
            object8 = new StringTokenizer(this.leaf, this.delimiter);
            while (((StringTokenizer)object8).hasMoreTokens()) {
                object9.add(((StringTokenizer)object8).nextToken());
            }
        }
        object8 = new LinkedHashSet();
        if (!"*".equals(this.restartFrom)) {
            object7 = new StringTokenizer(this.restartFrom, this.delimiter);
            object8.add(((StringTokenizer)object7).nextToken());
        }
        object7 = this.buildFileSets.listIterator();
        while (object7.hasNext()) {
            object6 = (FileSet)object7.next();
            object5 = object6.getDirectoryScanner(this.getProject());
            object4 = object5.getIncludedFiles();
            for (int i = 0; i < ((String[])object4).length; ++i) {
                object3 = new File(object5.getBasedir(), object4[i]);
                object2 = this.getIvyFileFor((File)object3);
                if (!((File)object2).exists()) {
                    this.onMissingDescriptor((File)object3, (File)object2, arrayList2);
                    continue;
                }
                try {
                    object = ModuleDescriptorParserRegistry.getInstance().parseDescriptor(ivySettings, ((File)object2).toURI().toURL(), this.doValidate(ivySettings));
                    hashMap.put((ModuleDescriptor)object, (File)object3);
                    collection.add((ModuleDescriptor)object);
                    Message.debug("Add " + object.getModuleRevisionId().getModuleId());
                    continue;
                }
                catch (Exception exception) {
                    if (this.haltOnError) {
                        throw new BuildException("impossible to parse ivy file for " + object3 + ": ivyfile=" + object2 + " exception=" + exception, (Throwable)exception);
                    }
                    Message.warn("impossible to parse ivy file for " + object3 + ": ivyfile=" + object2 + " exception=" + exception.getMessage());
                    Message.info("\t=> adding it at the beginning of the path");
                    arrayList.add((ListIterator<ModuleDescriptor>)object3);
                }
            }
        }
        object7 = this.convertModuleNamesToModuleDescriptors(collection, (Set)object9, "leaf");
        object6 = this.convertModuleNamesToModuleDescriptors(collection, linkedHashSet, "root");
        object5 = this.convertModuleNamesToModuleDescriptors(collection, (Set)object8, "restartFrom");
        if (!object6.isEmpty()) {
            Message.info("Filtering modules based on roots " + linkedHashSet);
            collection = this.filterModulesFromRoot(collection, (List)object6);
        }
        if (!object7.isEmpty()) {
            Message.info("Filtering modules based on leafs " + object9);
            collection = this.filterModulesFromLeaf(collection, (List)object7);
        }
        object4 = ivy.sortModuleDescriptors(collection, SortOptions.DEFAULT);
        if (!"tail".equals(this.onMissingDescriptor)) {
            ListIterator listIterator = arrayList2.listIterator();
            while (listIterator.hasNext()) {
                object3 = (File)listIterator.next();
                this.addBuildFile(path, (File)object3);
            }
        }
        ListIterator listIterator = arrayList.listIterator();
        while (listIterator.hasNext()) {
            object3 = (File)listIterator.next();
            this.addBuildFile(path, (File)object3);
        }
        if (this.isReverse()) {
            Collections.reverse(object4);
        }
        if (!object5.isEmpty()) {
            boolean bl = false;
            object3 = new ArrayList();
            object2 = (ModuleDescriptor)object5.get(0);
            object = object4.listIterator();
            while (object.hasNext()) {
                ModuleDescriptor moduleDescriptor = (ModuleDescriptor)object.next();
                if (moduleDescriptor.equals(object2)) {
                    bl = true;
                }
                if (!bl) continue;
                object3.add((ModuleDescriptor)moduleDescriptor);
            }
            object4 = object3;
        }
        StringBuffer stringBuffer = new StringBuffer();
        object3 = object4.listIterator();
        while (object3.hasNext()) {
            object2 = (ModuleDescriptor)object3.next();
            stringBuffer.append(object2.getModuleRevisionId().getModuleId());
            if (object3.hasNext()) {
                stringBuffer.append(", ");
            }
            object = (File)hashMap.get(object2);
            this.addBuildFile(path, (File)object);
        }
        if ("tail".equals(this.onMissingDescriptor)) {
            object3 = arrayList2.listIterator();
            while (object3.hasNext()) {
                object2 = (File)object3.next();
                this.addBuildFile(path, (File)object2);
            }
        }
        this.getProject().addReference(this.getReference(), (Object)path);
        this.getProject().setProperty("ivy.sorted.modules", stringBuffer.toString());
    }

    private void onMissingDescriptor(File file, File file2, List list) {
        if ("skip".equals(this.onMissingDescriptor)) {
            Message.debug("skipping " + file + ": descriptor " + file2 + " doesn't exist");
        } else {
            if ("fail".equals(this.onMissingDescriptor)) {
                throw new BuildException("a module has no module descriptor and onMissingDescriptor=fail. Build file: " + file + ". Expected descriptor: " + file2);
            }
            if ("warn".equals(this.onMissingDescriptor)) {
                Message.warn("a module has no module descriptor. Build file: " + file + ". Expected descriptor: " + file2);
            }
            Message.verbose("no descriptor for " + file + ": descriptor=" + file2 + ": adding it at the " + ("tail".equals(this.onMissingDescriptor) ? "tail" : "head of the path"));
            Message.verbose("\t(change onMissingDescriptor if you want to take another action");
            list.add(file);
        }
    }

    private List convertModuleNamesToModuleDescriptors(Collection collection, Set set, String string) {
        String string2;
        ArrayList<Object> arrayList = new ArrayList<Object>();
        HashSet<String> hashSet = new HashSet<String>();
        for (Object object : collection) {
            string2 = object.getModuleRevisionId().getModuleId().getName();
            if (!set.contains(string2)) continue;
            hashSet.add(string2);
            arrayList.add(object);
        }
        if (hashSet.size() < set.size()) {
            Object object;
            HashSet hashSet2 = new HashSet(set);
            hashSet2.removeAll(hashSet);
            object = new StringBuffer();
            string2 = "";
            Iterator iterator = hashSet2.iterator();
            while (iterator.hasNext()) {
                ((StringBuffer)object).append(string2);
                ((StringBuffer)object).append(iterator.next());
                string2 = ", ";
            }
            throw new BuildException("unable to find " + string + " module(s) " + ((StringBuffer)object).toString() + " in build fileset");
        }
        return arrayList;
    }

    private Collection filterModulesFromRoot(Collection collection, List list) {
        Object object3;
        HashMap<ModuleId, Object> hashMap = new HashMap<ModuleId, Object>();
        for (Object object2 : collection) {
            hashMap.put(object2.getModuleRevisionId().getModuleId(), object2);
        }
        LinkedHashSet linkedHashSet = new LinkedHashSet();
        for (Object object3 : list) {
            this.processFilterNodeFromRoot((ModuleDescriptor)object3, linkedHashSet, hashMap);
            if (this.excludeRoot) {
                Message.verbose("Excluded module " + object3.getModuleRevisionId().getModuleId().getName());
                continue;
            }
            linkedHashSet.add(object3);
        }
        object3 = linkedHashSet.iterator();
        while (object3.hasNext()) {
            ModuleDescriptor moduleDescriptor = (ModuleDescriptor)object3.next();
            Message.verbose("Kept module " + moduleDescriptor.getModuleRevisionId().getModuleId().getName());
        }
        return linkedHashSet;
    }

    private void processFilterNodeFromRoot(ModuleDescriptor moduleDescriptor, Set set, Map map) {
        DependencyDescriptor[] dependencyDescriptorArray = moduleDescriptor.getDependencies();
        for (int i = 0; i < dependencyDescriptorArray.length; ++i) {
            ModuleId moduleId = dependencyDescriptorArray[i].getDependencyId();
            ModuleDescriptor moduleDescriptor2 = (ModuleDescriptor)map.get(moduleId);
            if (moduleDescriptor2 == null || set.contains(moduleDescriptor2)) continue;
            set.add(moduleDescriptor2);
            if (this.getOnlydirectdep()) continue;
            this.processFilterNodeFromRoot(moduleDescriptor2, set, map);
        }
    }

    private Collection filterModulesFromLeaf(Collection collection, List list) {
        Object object3;
        HashMap<ModuleId, Object> hashMap = new HashMap<ModuleId, Object>();
        for (Object object2 : collection) {
            hashMap.put(object2.getModuleRevisionId().getModuleId(), object2);
        }
        LinkedHashSet linkedHashSet = new LinkedHashSet();
        for (Object object3 : list) {
            if (this.excludeLeaf) {
                Message.verbose("Excluded module " + object3.getModuleRevisionId().getModuleId().getName());
            } else {
                linkedHashSet.add(object3);
            }
            this.processFilterNodeFromLeaf((ModuleDescriptor)object3, linkedHashSet, hashMap);
        }
        object3 = linkedHashSet.iterator();
        while (object3.hasNext()) {
            ModuleDescriptor moduleDescriptor = (ModuleDescriptor)object3.next();
            Message.verbose("Kept module " + moduleDescriptor.getModuleRevisionId().getModuleId().getName());
        }
        return linkedHashSet;
    }

    private void processFilterNodeFromLeaf(ModuleDescriptor moduleDescriptor, Set set, Map map) {
        for (ModuleDescriptor moduleDescriptor2 : map.values()) {
            DependencyDescriptor[] dependencyDescriptorArray = moduleDescriptor2.getDependencies();
            for (int i = 0; i < dependencyDescriptorArray.length; ++i) {
                ModuleId moduleId = dependencyDescriptorArray[i].getDependencyId();
                if (!moduleDescriptor.getModuleRevisionId().getModuleId().equals(moduleId) || set.contains(moduleDescriptor2)) continue;
                set.add(moduleDescriptor2);
                if (this.getOnlydirectdep()) continue;
                this.processFilterNodeFromLeaf(moduleDescriptor2, set, map);
            }
        }
    }

    private void addBuildFile(Path path, File file) {
        FileSet fileSet = new FileSet();
        fileSet.setFile(file);
        path.addFileset(fileSet);
    }

    private File getIvyFileFor(File file) {
        return new File(file.getParentFile(), this.ivyFilePath);
    }

    public boolean isHaltonerror() {
        return this.haltOnError;
    }

    public void setHaltonerror(boolean bl) {
        this.haltOnError = bl;
    }

    public String getIvyfilepath() {
        return this.ivyFilePath;
    }

    public void setIvyfilepath(String string) {
        this.ivyFilePath = string;
    }

    public String getOnMissingDescriptor() {
        return this.onMissingDescriptor;
    }

    public void setOnMissingDescriptor(String string) {
        this.onMissingDescriptor = string;
    }

    public boolean isSkipbuildwithoutivy() {
        return this.onMissingDescriptor == "skip";
    }

    public void setSkipbuildwithoutivy(boolean bl) {
        Message.deprecated("skipbuildwithoutivy is deprecated, use onMissingDescriptor instead.");
        this.onMissingDescriptor = bl ? "skip" : "fail";
    }

    public boolean isReverse() {
        return this.reverse;
    }

    public void setReverse(boolean bl) {
        this.reverse = bl;
    }

    public String getRestartFrom() {
        return this.restartFrom;
    }

    public void setRestartFrom(String string) {
        this.restartFrom = string;
    }

    public static final class OnMissingDescriptor {
        public static final String HEAD = "head";
        public static final String TAIL = "tail";
        public static final String SKIP = "skip";
        public static final String FAIL = "fail";
        public static final String WARN = "warn";

        private OnMissingDescriptor() {
        }
    }
}

