/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ivy.ant;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.net.URL;
import java.util.Properties;
import org.apache.ivy.Ivy;
import org.apache.ivy.ant.IvyTask;
import org.apache.ivy.core.settings.IvySettings;
import org.apache.tools.ant.BuildException;

public class IvyVar
extends IvyTask {
    private String name;
    private String value;
    private File file;
    private String url;
    private String prefix;

    public File getFile() {
        return this.file;
    }

    public void setFile(File file) {
        this.file = file;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = string;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public void setPrefix(String string) {
        this.prefix = string;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String string) {
        this.url = string;
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String string) {
        this.value = string;
    }

    @Override
    public void doExecute() throws BuildException {
        Ivy ivy = this.getIvyInstance();
        IvySettings ivySettings = ivy.getSettings();
        if (this.getName() != null) {
            ivySettings.setVariable(this.getVarName(this.getName()), this.getValue());
        } else {
            Properties properties = new Properties();
            InputStream inputStream = null;
            try {
                if (this.getFile() != null) {
                    inputStream = new FileInputStream(this.getFile());
                } else if (this.getUrl() != null) {
                    inputStream = new URL(this.getUrl()).openStream();
                } else {
                    throw new BuildException("specify either name or file or url to ivy var task");
                }
                properties.load(inputStream);
            }
            catch (Exception exception) {
                throw new BuildException("impossible to load variables from file: " + exception, (Throwable)exception);
            }
            finally {
                if (inputStream != null) {
                    try {
                        inputStream.close();
                    }
                    catch (Exception exception) {}
                }
            }
            for (String string : properties.keySet()) {
                String string2 = (String)properties.get(string);
                ivySettings.setVariable(this.getVarName(string), string2);
            }
        }
    }

    private String getVarName(String string) {
        String string2 = this.getPrefix();
        if (string2 != null) {
            if (string2.endsWith(".")) {
                return string2 + string;
            }
            return string2 + "." + string;
        }
        return string;
    }
}

