/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ivy.core.event;

import org.apache.ivy.core.event.IvyEvent;
import org.apache.ivy.plugins.matcher.ExactPatternMatcher;
import org.apache.ivy.plugins.matcher.Matcher;
import org.apache.ivy.plugins.matcher.PatternMatcher;
import org.apache.ivy.util.filter.AndFilter;
import org.apache.ivy.util.filter.Filter;
import org.apache.ivy.util.filter.NoFilter;
import org.apache.ivy.util.filter.NotFilter;
import org.apache.ivy.util.filter.OrFilter;

public class IvyEventFilter
implements Filter {
    private static final String NOT = "NOT ";
    private static final String OR = " OR ";
    private static final String AND = " AND ";
    private PatternMatcher matcher;
    private Filter nameFilter;
    private Filter attFilter;

    public IvyEventFilter(String string, String string2, PatternMatcher patternMatcher) {
        PatternMatcher patternMatcher2 = this.matcher = patternMatcher == null ? ExactPatternMatcher.INSTANCE : patternMatcher;
        if (string == null) {
            this.nameFilter = NoFilter.INSTANCE;
        } else {
            final Matcher matcher = this.matcher.getMatcher(string);
            this.nameFilter = new Filter(){

                @Override
                public boolean accept(Object object) {
                    IvyEvent ivyEvent = (IvyEvent)object;
                    return matcher.matches(ivyEvent.getName());
                }
            };
        }
        this.attFilter = string2 == null || string2.trim().length() == 0 ? NoFilter.INSTANCE : this.parseExpression(string2);
    }

    private Filter parseExpression(String string) {
        int n = (string = string.trim()).indexOf(AND);
        if (n == -1) {
            n = string.indexOf(OR);
            if (n == -1) {
                if (string.startsWith(NOT)) {
                    return new NotFilter(this.parseExpression(string.substring(NOT.length())));
                }
                n = string.indexOf("=");
                if (n == -1) {
                    throw new IllegalArgumentException("bad filter expression: " + string + ": no equal sign found");
                }
                final String string2 = string.substring(0, n).trim();
                String[] stringArray = string.substring(n + 1).trim().split(",");
                final Matcher[] matcherArray = new Matcher[stringArray.length];
                for (int i = 0; i < stringArray.length; ++i) {
                    matcherArray[i] = this.matcher.getMatcher(stringArray[i].trim());
                }
                return new Filter(){

                    @Override
                    public boolean accept(Object object) {
                        IvyEvent ivyEvent = (IvyEvent)object;
                        String string = (String)ivyEvent.getAttributes().get(string2);
                        if (string == null) {
                            return false;
                        }
                        for (int i = 0; i < matcherArray.length; ++i) {
                            if (!matcherArray[i].matches(string)) continue;
                            return true;
                        }
                        return false;
                    }
                };
            }
            return new OrFilter(this.parseExpression(string.substring(0, n)), this.parseExpression(string.substring(n + OR.length())));
        }
        return new AndFilter(this.parseExpression(string.substring(0, n)), this.parseExpression(string.substring(n + AND.length())));
    }

    @Override
    public boolean accept(Object object) {
        if (!(object instanceof IvyEvent)) {
            return false;
        }
        return this.nameFilter.accept(object) && this.attFilter.accept(object);
    }
}

