/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ivy.core.module.descriptor;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.apache.ivy.core.module.descriptor.InheritableItem;
import org.apache.ivy.core.module.descriptor.ModuleDescriptor;
import org.apache.ivy.core.module.id.ModuleRevisionId;
import org.apache.ivy.util.extendable.DefaultExtendableItem;

public class Configuration
extends DefaultExtendableItem
implements InheritableItem {
    private String name;
    private String description;
    private String[] extendsFrom;
    private Visibility visibility;
    private boolean transitive = true;
    private String deprecated;
    private ModuleRevisionId sourceModule;

    public static Collection findConfigurationExtending(String string, Configuration[] configurationArray) {
        ArrayList<Configuration> arrayList = new ArrayList<Configuration>();
        for (int i = 0; i < configurationArray.length; ++i) {
            if (configurationArray[i] == null || !Arrays.asList(configurationArray[i].getExtends()).contains(string)) continue;
            arrayList.add(configurationArray[i]);
            arrayList.addAll(Configuration.findConfigurationExtending(configurationArray[i].getName(), configurationArray));
        }
        return arrayList;
    }

    public Configuration(String string) {
        this(string, Visibility.PUBLIC, null, null, true, null);
    }

    public Configuration(Configuration configuration, ModuleRevisionId moduleRevisionId) {
        this(configuration.getAttributes(), configuration.getQualifiedExtraAttributes(), configuration.getName(), configuration.getVisibility(), configuration.getDescription(), configuration.getExtends(), configuration.isTransitive(), configuration.getDeprecated(), moduleRevisionId);
    }

    public Configuration(String string, Visibility visibility, String string2, String[] stringArray, boolean bl, String string3) {
        this(null, null, string, visibility, string2, stringArray, bl, string3, null);
    }

    private Configuration(Map map, Map map2, String string, Visibility visibility, String string2, String[] stringArray, boolean bl, String string3, ModuleRevisionId moduleRevisionId) {
        super(map, map2);
        if (string == null) {
            throw new NullPointerException("null configuration name not allowed");
        }
        if (visibility == null) {
            throw new NullPointerException("null visibility not allowed");
        }
        this.name = string;
        this.visibility = visibility;
        this.description = string2;
        if (stringArray == null) {
            this.extendsFrom = new String[0];
        } else {
            this.extendsFrom = new String[stringArray.length];
            for (int i = 0; i < stringArray.length; ++i) {
                this.extendsFrom[i] = stringArray[i].trim();
            }
        }
        this.transitive = bl;
        this.deprecated = string3;
        this.sourceModule = moduleRevisionId;
    }

    public String getDeprecated() {
        return this.deprecated;
    }

    public String getDescription() {
        return this.description;
    }

    public String[] getExtends() {
        return this.extendsFrom;
    }

    public String getName() {
        return this.name;
    }

    public Visibility getVisibility() {
        return this.visibility;
    }

    public final boolean isTransitive() {
        return this.transitive;
    }

    @Override
    public ModuleRevisionId getSourceModule() {
        return this.sourceModule;
    }

    public String toString() {
        return this.name;
    }

    public boolean equals(Object object) {
        if (!(object instanceof Configuration)) {
            return false;
        }
        return ((Configuration)object).getName().equals(this.getName());
    }

    public int hashCode() {
        return this.getName().hashCode();
    }

    public void replaceWildcards(ModuleDescriptor moduleDescriptor) {
        if (this != moduleDescriptor.getConfiguration(this.name)) {
            throw new IllegalArgumentException("The given ModuleDescriptor doesn't own this configuration!");
        }
        Configuration[] configurationArray = moduleDescriptor.getConfigurations();
        LinkedHashSet<String> linkedHashSet = new LinkedHashSet<String>();
        for (int i = 0; i < this.extendsFrom.length; ++i) {
            if ("*".equals(this.extendsFrom[i])) {
                this.addOther(configurationArray, null, linkedHashSet);
                continue;
            }
            if ("*(public)".equals(this.extendsFrom[i])) {
                this.addOther(configurationArray, Visibility.PUBLIC, linkedHashSet);
                continue;
            }
            if ("*(private)".equals(this.extendsFrom[i])) {
                this.addOther(configurationArray, Visibility.PRIVATE, linkedHashSet);
                continue;
            }
            linkedHashSet.add(this.extendsFrom[i]);
        }
        this.extendsFrom = linkedHashSet.toArray(new String[linkedHashSet.size()]);
    }

    private void addOther(Configuration[] configurationArray, Visibility visibility, Set set) {
        for (int i = 0; i < configurationArray.length; ++i) {
            String string = configurationArray[i].getName();
            if (this.name.equals(string) || visibility != null && !visibility.equals(configurationArray[i].getVisibility())) continue;
            set.add(string);
        }
    }

    public static final class Visibility {
        public static final Visibility PUBLIC = new Visibility("public");
        public static final Visibility PRIVATE = new Visibility("private");
        private String name;

        public static Visibility getVisibility(String string) {
            if ("private".equals(string)) {
                return PRIVATE;
            }
            if ("public".equals(string)) {
                return PUBLIC;
            }
            throw new IllegalArgumentException("unknwon visibility " + string);
        }

        private Visibility(String string) {
            this.name = string;
        }

        public String toString() {
            return this.name;
        }
    }
}

