/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ivy.plugins.repository;

import java.io.File;
import org.apache.ivy.core.event.IvyEvent;
import org.apache.ivy.plugins.repository.Repository;
import org.apache.ivy.plugins.repository.Resource;

public class TransferEvent
extends IvyEvent {
    public static final int TRANSFER_INITIATED = 0;
    public static final int TRANSFER_STARTED = 1;
    public static final int TRANSFER_COMPLETED = 2;
    public static final int TRANSFER_PROGRESS = 3;
    public static final int TRANSFER_ERROR = 4;
    private static final int LAST_EVENT_TYPE = 4;
    public static final int REQUEST_GET = 5;
    public static final int REQUEST_PUT = 6;
    public static final String TRANSFER_INITIATED_NAME = "transfer-initiated";
    public static final String TRANSFER_STARTED_NAME = "transfer-started";
    public static final String TRANSFER_PROGRESS_NAME = "transfer-progress";
    public static final String TRANSFER_COMPLETED_NAME = "transfer-completed";
    public static final String TRANSFER_ERROR_NAME = "transfer-error";
    private Resource resource;
    private int eventType;
    private int requestType;
    private Exception exception;
    private File localFile;
    private Repository repository;
    private long length;
    private long totalLength;
    private boolean isTotalLengthSet = false;
    private long[] timeTracking = new long[5];

    public TransferEvent(Repository repository, Resource resource, int n, int n2) {
        super(TransferEvent.getName(n));
        this.repository = repository;
        this.setResource(resource);
        this.setEventType(n);
        this.setRequestType(n2);
    }

    public TransferEvent(Repository repository, Resource resource, Exception exception, int n) {
        this(repository, resource, 4, n);
        this.exception = exception;
    }

    public TransferEvent(Repository repository, Resource resource, long l, int n) {
        this(repository, resource, 3, n);
        this.length = l;
        this.totalLength = l;
    }

    private static String getName(int n) {
        switch (n) {
            case 0: {
                return TRANSFER_INITIATED_NAME;
            }
            case 1: {
                return TRANSFER_STARTED_NAME;
            }
            case 3: {
                return TRANSFER_PROGRESS_NAME;
            }
            case 2: {
                return TRANSFER_COMPLETED_NAME;
            }
            case 4: {
                return TRANSFER_ERROR_NAME;
            }
        }
        return null;
    }

    public Resource getResource() {
        return this.resource;
    }

    public Exception getException() {
        return this.exception;
    }

    public int getRequestType() {
        return this.requestType;
    }

    protected void setRequestType(int n) {
        switch (n) {
            case 6: {
                break;
            }
            case 5: {
                break;
            }
            default: {
                throw new IllegalArgumentException("Illegal request type: " + n);
            }
        }
        this.requestType = n;
        this.addAttribute("request-type", n == 5 ? "get" : "put");
    }

    public int getEventType() {
        return this.eventType;
    }

    protected void setEventType(int n) {
        this.checkEventType(n);
        if (this.eventType != n) {
            this.eventType = n;
            this.timeTracking[n] = System.currentTimeMillis();
            if (n > 0) {
                this.addAttribute("total-duration", String.valueOf(this.getElapsedTime(0, n)));
                if (n > 1) {
                    this.addAttribute("duration", String.valueOf(this.getElapsedTime(1, n)));
                }
            }
        }
    }

    protected void setResource(Resource resource) {
        this.resource = resource;
        this.addAttribute("resource", this.resource.getName());
    }

    public File getLocalFile() {
        return this.localFile;
    }

    protected void setLocalFile(File file) {
        this.localFile = file;
    }

    public long getLength() {
        return this.length;
    }

    protected void setLength(long l) {
        this.length = l;
    }

    public long getTotalLength() {
        return this.totalLength;
    }

    protected void setTotalLength(long l) {
        this.totalLength = l;
    }

    public void setException(Exception exception) {
        this.exception = exception;
    }

    public boolean isTotalLengthSet() {
        return this.isTotalLengthSet;
    }

    public void setTotalLengthSet(boolean bl) {
        this.isTotalLengthSet = bl;
    }

    public Repository getRepository() {
        return this.repository;
    }

    public long getElapsedTime(int n, int n2) {
        this.checkEventType(n);
        this.checkEventType(n2);
        long l = this.timeTracking[n];
        long l2 = this.timeTracking[n2];
        if (l == 0L || l2 == 0L) {
            return -1L;
        }
        if (l2 < l) {
            return 0L;
        }
        return l2 - l;
    }

    private void checkEventType(int n) {
        if (n < 0 || n > 4) {
            throw new IllegalArgumentException("invalid event type " + n);
        }
    }
}

