/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ivy.plugins.repository.url;

import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import org.apache.ivy.plugins.repository.Resource;
import org.apache.ivy.util.url.URLHandler;
import org.apache.ivy.util.url.URLHandlerRegistry;

public class URLResource
implements Resource {
    private URL url;
    private boolean init = false;
    private long lastModified;
    private long contentLength;
    private boolean exists;

    public URLResource(URL uRL) {
        this.url = uRL;
    }

    @Override
    public String getName() {
        return this.url.toExternalForm();
    }

    @Override
    public Resource clone(String string) {
        try {
            return new URLResource(new URL(string));
        }
        catch (MalformedURLException malformedURLException) {
            throw new IllegalArgumentException("bad clone name provided: not suitable for an URLResource: " + string);
        }
    }

    @Override
    public long getLastModified() {
        if (!this.init) {
            this.init();
        }
        return this.lastModified;
    }

    private void init() {
        URLHandler.URLInfo uRLInfo = URLHandlerRegistry.getDefault().getURLInfo(this.url);
        this.contentLength = uRLInfo.getContentLength();
        this.lastModified = uRLInfo.getLastModified();
        this.exists = uRLInfo.isReachable();
        this.init = true;
    }

    @Override
    public long getContentLength() {
        if (!this.init) {
            this.init();
        }
        return this.contentLength;
    }

    @Override
    public boolean exists() {
        if (!this.init) {
            this.init();
        }
        return this.exists;
    }

    public URL getURL() {
        return this.url;
    }

    public String toString() {
        return this.getName();
    }

    @Override
    public boolean isLocal() {
        return false;
    }

    @Override
    public InputStream openStream() throws IOException {
        return URLHandlerRegistry.getDefault().openStream(this.url);
    }
}

