/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ivy.tools.analyser;

import java.io.File;
import java.io.IOException;
import org.apache.ivy.core.IvyPatternHelper;
import org.apache.ivy.core.module.descriptor.DefaultArtifact;
import org.apache.ivy.core.module.descriptor.ModuleDescriptor;
import org.apache.ivy.plugins.parser.xml.XmlModuleDescriptorWriter;
import org.apache.ivy.tools.analyser.DependencyAnalyser;
import org.apache.ivy.tools.analyser.JarJarDependencyAnalyser;
import org.apache.ivy.tools.analyser.JarModuleFinder;
import org.apache.ivy.util.Message;

public class RepositoryAnalyser {
    public void analyse(String string, DependencyAnalyser dependencyAnalyser) {
        JarModuleFinder jarModuleFinder = new JarModuleFinder(string);
        ModuleDescriptor[] moduleDescriptorArray = dependencyAnalyser.analyze(jarModuleFinder.findJarModules());
        Message.info("found " + moduleDescriptorArray.length + " modules");
        for (int i = 0; i < moduleDescriptorArray.length; ++i) {
            File file = new File(IvyPatternHelper.substitute(string, DefaultArtifact.newIvyArtifact(moduleDescriptorArray[i].getModuleRevisionId(), moduleDescriptorArray[i].getPublicationDate())));
            try {
                Message.info("generating " + file);
                XmlModuleDescriptorWriter.write(moduleDescriptorArray[i], file);
                continue;
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
    }

    public static void main(String[] stringArray) {
        if (stringArray.length != 2) {
            System.out.println("usage: ivyanalyser path/to/jarjar.jar absolute-ivy-repository-pattern");
            return;
        }
        String string = stringArray[0];
        String string2 = stringArray[1];
        JarJarDependencyAnalyser jarJarDependencyAnalyser = new JarJarDependencyAnalyser(new File(string));
        new RepositoryAnalyser().analyse(string2, jarJarDependencyAnalyser);
    }
}

