/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ivy.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Stack;
import java.util.StringTokenizer;
import org.apache.ivy.util.CopyProgressEvent;
import org.apache.ivy.util.CopyProgressListener;
import org.apache.ivy.util.Message;
import org.apache.ivy.util.url.URLHandlerRegistry;

public final class FileUtil {
    private static final int BUFFER_SIZE = 65536;
    private static final byte[] EMPTY_BUFFER = new byte[0];

    private FileUtil() {
    }

    public static void symlink(File file, File file2, CopyProgressListener copyProgressListener, boolean bl) throws IOException {
        try {
            if (file2.exists()) {
                if (!file2.isFile()) {
                    throw new IOException("impossible to copy: destination is not a file: " + file2);
                }
                if (!bl) {
                    Message.verbose(file2 + " already exists, nothing done");
                    return;
                }
            }
            if (file2.getParentFile() != null) {
                file2.getParentFile().mkdirs();
            }
            Runtime runtime = Runtime.getRuntime();
            Message.verbose("executing 'ln -s -f " + file.getAbsolutePath() + " " + file2.getPath() + "'");
            Process process = runtime.exec(new String[]{"ln", "-s", "-f", file.getAbsolutePath(), file2.getPath()});
            if (process.waitFor() != 0) {
                String string;
                InputStream inputStream = process.getErrorStream();
                InputStreamReader inputStreamReader = new InputStreamReader(inputStream);
                BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
                StringBuffer stringBuffer = new StringBuffer();
                while ((string = bufferedReader.readLine()) != null) {
                    stringBuffer.append(string);
                    stringBuffer.append('\n');
                }
                throw new IOException("error symlinking " + file + " to " + file2 + ":\n" + stringBuffer);
            }
            if (!file2.exists()) {
                throw new IOException("error symlinking: " + file2 + " doesn't exists");
            }
            if (file2.getAbsolutePath().equals(file2.getCanonicalPath())) {
                file2.delete();
                throw new IOException("error symlinking: " + file2 + " isn't a symlink");
            }
        }
        catch (IOException iOException) {
            Message.verbose("symlink failed; falling back to copy");
            StringWriter stringWriter = new StringWriter();
            iOException.printStackTrace(new PrintWriter(stringWriter));
            Message.debug(stringWriter.toString());
            FileUtil.copy(file, file2, copyProgressListener, bl);
        }
        catch (InterruptedException interruptedException) {
            Thread.currentThread().interrupt();
        }
    }

    public static boolean copy(File file, File file2, CopyProgressListener copyProgressListener) throws IOException {
        return FileUtil.copy(file, file2, copyProgressListener, false);
    }

    public static boolean copy(File file, File file2, CopyProgressListener copyProgressListener, boolean bl) throws IOException {
        if (file2.exists()) {
            if (!file2.isFile()) {
                throw new IOException("impossible to copy: destination is not a file: " + file2);
            }
            if (bl) {
                if (!file2.canWrite()) {
                    file2.delete();
                }
            } else {
                Message.verbose(file2 + " already exists, nothing done");
                return false;
            }
        }
        FileUtil.copy((InputStream)new FileInputStream(file), file2, copyProgressListener);
        long l = file.length();
        long l2 = file2.length();
        if (l != l2) {
            file2.delete();
            throw new IOException("size of source file " + file.toString() + "(" + l + ") differs from size of dest file " + file2.toString() + "(" + l2 + ") - please retry");
        }
        file2.setLastModified(file.lastModified());
        return true;
    }

    public static void copy(URL uRL, File file, CopyProgressListener copyProgressListener) throws IOException {
        URLHandlerRegistry.getDefault().download(uRL, file, copyProgressListener);
    }

    public static void copy(File file, URL uRL, CopyProgressListener copyProgressListener) throws IOException {
        URLHandlerRegistry.getDefault().upload(file, uRL, copyProgressListener);
    }

    public static void copy(InputStream inputStream, File file, CopyProgressListener copyProgressListener) throws IOException {
        if (file.getParentFile() != null) {
            file.getParentFile().mkdirs();
        }
        FileUtil.copy(inputStream, new FileOutputStream(file), copyProgressListener);
    }

    public static void copy(InputStream inputStream, OutputStream outputStream, CopyProgressListener copyProgressListener) throws IOException {
        FileUtil.copy(inputStream, outputStream, copyProgressListener, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copy(InputStream inputStream, OutputStream outputStream, CopyProgressListener copyProgressListener, boolean bl) throws IOException {
        CopyProgressEvent copyProgressEvent = null;
        if (copyProgressListener != null) {
            copyProgressEvent = new CopyProgressEvent();
        }
        try {
            int n;
            byte[] byArray = new byte[65536];
            long l = 0L;
            if (copyProgressListener != null) {
                copyProgressListener.start(copyProgressEvent);
            }
            while ((n = inputStream.read(byArray)) != -1) {
                if (Thread.currentThread().isInterrupted()) {
                    throw new IOException("transfer interrupted");
                }
                outputStream.write(byArray, 0, n);
                l += (long)n;
                if (copyProgressListener == null) continue;
                copyProgressListener.progress(copyProgressEvent.update(byArray, n, l));
            }
            if (copyProgressListener != null) {
                copyProgressEvent.update(EMPTY_BUFFER, 0, l);
            }
            try {
                outputStream.flush();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            if (bl) {
                inputStream.close();
                outputStream.close();
            }
        }
        finally {
            if (bl) {
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {}
                try {
                    outputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
        if (copyProgressListener != null) {
            copyProgressListener.end(copyProgressEvent);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String readEntirely(BufferedReader bufferedReader) throws IOException {
        try {
            StringBuffer stringBuffer = new StringBuffer();
            String string = bufferedReader.readLine();
            while (string != null) {
                stringBuffer.append(string + "\n");
                string = bufferedReader.readLine();
            }
            String string2 = stringBuffer.toString();
            return string2;
        }
        finally {
            bufferedReader.close();
        }
    }

    public static String readEntirely(File file) throws IOException {
        return FileUtil.readEntirely(new FileInputStream(file));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String readEntirely(InputStream inputStream) throws IOException {
        try {
            int n;
            StringBuffer stringBuffer = new StringBuffer();
            byte[] byArray = new byte[65536];
            while ((n = inputStream.read(byArray)) != -1) {
                stringBuffer.append(new String(byArray, 0, n));
            }
            String string = stringBuffer.toString();
            return string;
        }
        finally {
            inputStream.close();
        }
    }

    public static String concat(String string, String string2) {
        return string + "/" + string2;
    }

    public static boolean forceDelete(File file) {
        File[] fileArray;
        if (!file.exists()) {
            return true;
        }
        if (file.isDirectory() && (fileArray = file.listFiles()) != null) {
            for (int i = 0; i < fileArray.length; ++i) {
                if (FileUtil.forceDelete(fileArray[i])) continue;
                return false;
            }
        }
        return file.delete();
    }

    public static List getPathFiles(File file, File file2) {
        ArrayList<File> arrayList = new ArrayList<File>();
        while (file2 != null && !file2.getAbsolutePath().equals(file.getAbsolutePath())) {
            arrayList.add(file2);
            file2 = file2.getParentFile();
        }
        if (file != null) {
            arrayList.add(file);
        }
        Collections.reverse(arrayList);
        return arrayList;
    }

    public static Collection listAll(File file, Collection collection) {
        return FileUtil.listAll(file, new ArrayList(), collection);
    }

    private static Collection listAll(File file, Collection collection, Collection collection2) {
        if (collection2.contains(file.getName())) {
            return collection;
        }
        if (file.exists()) {
            collection.add(file);
        }
        if (file.isDirectory()) {
            File[] fileArray = file.listFiles();
            for (int i = 0; i < fileArray.length; ++i) {
                FileUtil.listAll(fileArray[i], collection, collection2);
            }
        }
        return collection;
    }

    public static File resolveFile(File file, String string) {
        File file2 = new File(string);
        if (!file2.isAbsolute()) {
            file2 = new File(file, string);
        }
        return FileUtil.normalize(file2.getPath());
    }

    public static File normalize(String string) {
        CharSequence charSequence;
        Stack<CharSequence> stack = new Stack<CharSequence>();
        String[] stringArray = FileUtil.dissect(string);
        stack.push(stringArray[0]);
        StringTokenizer stringTokenizer = new StringTokenizer(stringArray[1], File.separator);
        while (stringTokenizer.hasMoreTokens()) {
            charSequence = stringTokenizer.nextToken();
            if (".".equals(charSequence)) continue;
            if ("..".equals(charSequence)) {
                if (stack.size() < 2) {
                    return new File(string);
                }
                stack.pop();
                continue;
            }
            stack.push(charSequence);
        }
        charSequence = new StringBuffer();
        for (int i = 0; i < stack.size(); ++i) {
            if (i > 1) {
                ((StringBuffer)charSequence).append(File.separatorChar);
            }
            ((StringBuffer)charSequence).append(stack.elementAt(i));
        }
        return new File(((StringBuffer)charSequence).toString());
    }

    private static String[] dissect(String string) {
        char c = File.separatorChar;
        string = string.replace('/', c).replace('\\', c);
        String string2 = null;
        int n = string.indexOf(58);
        if (n > 0) {
            int n2 = n + 1;
            string2 = string.substring(0, n2);
            char[] cArray = string.toCharArray();
            string2 = string2 + c;
            n2 = cArray[n2] == c ? n2 + 1 : n2;
            StringBuffer stringBuffer = new StringBuffer();
            for (int i = n2; i < cArray.length; ++i) {
                if (cArray[i] == c && cArray[i - 1] == c) continue;
                stringBuffer.append(cArray[i]);
            }
            string = stringBuffer.toString();
        } else if (string.length() > 1 && string.charAt(1) == c) {
            int n3 = string.indexOf(c, 2);
            string2 = (n3 = string.indexOf(c, n3 + 1)) > 2 ? string.substring(0, n3 + 1) : string;
            string = string.substring(string2.length());
        } else {
            string2 = File.separator;
            string = string.substring(1);
        }
        return new String[]{string2, string};
    }
}

