/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.client.gui.builders;

import javax.swing.JTabbedPane;
import javax.swing.event.EventListenerList;
import net.sourceforge.squirrel_sql.client.IApplication;
import net.sourceforge.squirrel_sql.client.gui.builders.IUIFactoryListener;
import net.sourceforge.squirrel_sql.client.gui.builders.SquirrelTabbedPane;
import net.sourceforge.squirrel_sql.client.gui.builders.UIFactoryComponentCreatedEvent;
import net.sourceforge.squirrel_sql.client.gui.builders.dndtabbedpane.DnDSquirrelTabbedPane;
import net.sourceforge.squirrel_sql.client.preferences.SquirrelPreferences;

public class UIFactory {
    private static UIFactory s_instance;
    private SquirrelPreferences _prefs;
    private final EventListenerList _listenerList = new EventListenerList();
    private IApplication _app;

    public static UIFactory getInstance() {
        if (s_instance == null) {
            throw new IllegalArgumentException("UIFactory has not been initialized");
        }
        return s_instance;
    }

    public static synchronized void initialize(SquirrelPreferences prefs, IApplication app) {
        if (s_instance != null) {
            throw new IllegalStateException("UIFactory has alerady been initialized");
        }
        s_instance = new UIFactory(prefs, app);
    }

    private UIFactory(SquirrelPreferences prefs, IApplication app) {
        if (prefs == null) {
            throw new IllegalArgumentException("SquirrelPreferences == null");
        }
        this._prefs = prefs;
        this._app = app;
    }

    public JTabbedPane createTabbedPane() {
        return this.createTabbedPane(1);
    }

    public JTabbedPane createTabbedPane(int tabPlacement) {
        return this.createTabbedPane(tabPlacement, false);
    }

    public JTabbedPane createTabbedPane(int tabPlacement, boolean dndTabbedPane) {
        JTabbedPane pnl = dndTabbedPane ? new DnDSquirrelTabbedPane(this._prefs, this._app) : new SquirrelTabbedPane(this._prefs, this._app);
        pnl.setTabPlacement(tabPlacement);
        this.fireTabbedPaneCreated(pnl);
        return pnl;
    }

    public void addListener(IUIFactoryListener lis) {
        this._listenerList.add(IUIFactoryListener.class, lis);
    }

    public void removeListener(IUIFactoryListener lis) {
        this._listenerList.remove(IUIFactoryListener.class, lis);
    }

    private void fireTabbedPaneCreated(JTabbedPane tabPnl) {
        Object[] listeners = this._listenerList.getListenerList();
        UIFactoryComponentCreatedEvent evt = null;
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != IUIFactoryListener.class) continue;
            if (evt == null) {
                evt = new UIFactoryComponentCreatedEvent(this, tabPnl);
            }
            ((IUIFactoryListener)listeners[i + 1]).tabbedPaneCreated(evt);
        }
    }
}

