/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.client.gui.builders.dndtabbedpane;

import java.awt.Point;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragSource;
import java.awt.dnd.DragSourceListener;
import java.awt.dnd.InvalidDnDOperationException;
import net.sourceforge.squirrel_sql.client.gui.builders.dndtabbedpane.DnDTabbedPaneData;
import net.sourceforge.squirrel_sql.client.gui.builders.dndtabbedpane.DndTabUtils;
import net.sourceforge.squirrel_sql.client.gui.builders.dndtabbedpane.GhostGlassPane;

class DndTabbedPaneDragGestureListener
implements DragGestureListener {
    private final Transferable _t;
    private final DragSourceListener _dsl;
    private DnDTabbedPaneData _dnDTabbedPaneData;
    private GhostGlassPane _glassPane;

    public DndTabbedPaneDragGestureListener(Transferable t, DragSourceListener dsl, DnDTabbedPaneData dnDTabbedPaneData, GhostGlassPane glassPane) {
        this._t = t;
        this._dsl = dsl;
        this._dnDTabbedPaneData = dnDTabbedPaneData;
        this._glassPane = glassPane;
    }

    @Override
    public void dragGestureRecognized(DragGestureEvent e) {
        Point tabPt = e.getDragOrigin();
        this._dnDTabbedPaneData.setDragTabIndex(this._dnDTabbedPaneData.getTabbedPane().indexAtLocation(tabPt.x, tabPt.y));
        if (this._dnDTabbedPaneData.getDragTabIndex() < 0 || !this._dnDTabbedPaneData.getTabbedPane().isEnabledAt(this._dnDTabbedPaneData.getDragTabIndex())) {
            return;
        }
        DndTabUtils.initGlassPaneLocal(e.getDragOrigin(), this._dnDTabbedPaneData, this._glassPane);
        try {
            e.startDrag(DragSource.DefaultMoveDrop, this._t, this._dsl);
        }
        catch (InvalidDnDOperationException idoe) {
            idoe.printStackTrace();
        }
    }
}

