/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.client.session;

import java.util.HashMap;
import java.util.prefs.Preferences;
import javax.swing.JFileChooser;
import net.sourceforge.squirrel_sql.fw.util.FileExtensionFilter;

public class FileChooserManager {
    private static final String PREF_PRE_SELECTED_FILE_FILTER = "Squirrel.filechoosermanager.preselfilefilter";
    public static final String FILE_ENDING_TXT = ".txt";
    public static final String FILE_ENDING_SQL = ".sql";
    public static final String FILE_ENDING_NONE = "FILE_ENDING_NONE";
    private JFileChooser _fileChooser;
    private HashMap<FileExtensionFilter, String> _fileAppenixes = new HashMap();

    public FileChooserManager() {
        this._fileChooser = new JFileChooser();
        FileExtensionFilter txtFilter = new FileExtensionFilter("Text files", new String[]{FILE_ENDING_TXT});
        this._fileChooser.addChoosableFileFilter(txtFilter);
        this._fileAppenixes.put(txtFilter, FILE_ENDING_TXT);
        FileExtensionFilter sqlFilter = new FileExtensionFilter("SQL files", new String[]{FILE_ENDING_SQL});
        this._fileChooser.addChoosableFileFilter(sqlFilter);
        this._fileAppenixes.put(sqlFilter, FILE_ENDING_SQL);
        String fileEndingPref = Preferences.userRoot().get(PREF_PRE_SELECTED_FILE_FILTER, FILE_ENDING_NONE);
        if (FILE_ENDING_SQL.equals(fileEndingPref)) {
            this._fileChooser.setFileFilter(sqlFilter);
        } else if (FILE_ENDING_TXT.equals(fileEndingPref)) {
            this._fileChooser.setFileFilter(txtFilter);
        }
    }

    public String getSelectedFileEnding() {
        return this._fileAppenixes.get(this._fileChooser.getFileFilter());
    }

    public JFileChooser getFileChooser() {
        return this._fileChooser;
    }

    public void saveWasApproved() {
        if (null != this.getSelectedFileEnding()) {
            Preferences.userRoot().put(PREF_PRE_SELECTED_FILE_FILTER, this.getSelectedFileEnding());
        } else {
            Preferences.userRoot().put(PREF_PRE_SELECTED_FILE_FILTER, FILE_ENDING_NONE);
        }
    }
}

