/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.fw.datasetviewer;

import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.Timer;
import net.sourceforge.squirrel_sql.fw.datasetviewer.ContinueReadChannel;

public class ContinueReadHandler {
    private JTable _table;
    private Timer _timer;
    private ContinueReadChannel _continueReadChannel;
    private AdjustmentListener _adjustmentListener;

    public ContinueReadHandler(JTable table) {
        this._table = table;
        this._timer = new Timer(300, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ContinueReadHandler.this.onCheckTableEndReached();
            }
        });
        this._timer.setRepeats(false);
        this._adjustmentListener = new AdjustmentListener(){

            @Override
            public void adjustmentValueChanged(AdjustmentEvent e) {
                ContinueReadHandler.this.runTimer();
            }
        };
    }

    public void setContinueReadChannel(ContinueReadChannel continueReadChannel) {
        this._continueReadChannel = continueReadChannel;
        if (this.readyForAdjustmentListening()) {
            JScrollPane scrollPane = (JScrollPane)this._table.getParent().getParent();
            scrollPane.getVerticalScrollBar().addAdjustmentListener(this._adjustmentListener);
        }
    }

    private boolean readyForAdjustmentListening() {
        return null != this._continueReadChannel && null != this._table.getParent() && false != this._table.getParent().getParent() instanceof JScrollPane;
    }

    private void runTimer() {
        this._timer.restart();
    }

    private void onCheckTableEndReached() {
        if (null == this._continueReadChannel) {
            return;
        }
        Rectangle visibleRect = this._table.getVisibleRect();
        int row = this._table.rowAtPoint(new Point(0, visibleRect.y + visibleRect.height - 3));
        if (row == this._table.getRowCount() - 1) {
            this._continueReadChannel.readMoreResults();
        }
    }

    public void disableContinueRead() {
        if (this.readyForAdjustmentListening()) {
            JScrollPane scrollPane = (JScrollPane)this._table.getParent().getParent();
            scrollPane.getVerticalScrollBar().removeAdjustmentListener(this._adjustmentListener);
        }
    }
}

