/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.fw.dialects;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.sourceforge.squirrel_sql.fw.dialects.CommonHibernateDialect;
import net.sourceforge.squirrel_sql.fw.dialects.CreateScriptPreferences;
import net.sourceforge.squirrel_sql.fw.dialects.DatabaseObjectQualifier;
import net.sourceforge.squirrel_sql.fw.dialects.DialectType;
import net.sourceforge.squirrel_sql.fw.dialects.DialectUtils;
import net.sourceforge.squirrel_sql.fw.dialects.HibernateDialect;
import net.sourceforge.squirrel_sql.fw.dialects.SqlGenerationPreferences;
import net.sourceforge.squirrel_sql.fw.sql.DatabaseObjectType;
import net.sourceforge.squirrel_sql.fw.sql.IDatabaseObjectInfo;
import net.sourceforge.squirrel_sql.fw.sql.ISQLDatabaseMetaData;
import net.sourceforge.squirrel_sql.fw.sql.ITableInfo;
import net.sourceforge.squirrel_sql.fw.sql.TableColumnInfo;
import org.antlr.stringtemplate.StringTemplate;
import org.hibernate.HibernateException;
import org.hibernate.dialect.InformixDialect;

public class InformixDialectExt
extends CommonHibernateDialect
implements HibernateDialect {
    private InformixDialectHelper _dialect = new InformixDialectHelper();

    @Override
    public String getTypeName(int code, int length, int precision, int scale) throws HibernateException {
        return this._dialect.getTypeName(code, length, precision, scale);
    }

    @Override
    public boolean canPasteTo(IDatabaseObjectInfo info) {
        return info.getDatabaseObjectType() == DatabaseObjectType.SCHEMA;
    }

    @Override
    public int getMaxPrecision(int dataType) {
        if (dataType == 3 || dataType == 2) {
            return 32;
        }
        if (dataType == 8) {
            return 16;
        }
        return 32;
    }

    @Override
    public int getMaxScale(int dataType) {
        return this.getMaxPrecision(dataType);
    }

    @Override
    public int getPrecisionDigits(int columnSize, int dataType) {
        return columnSize;
    }

    @Override
    public int getColumnLength(int columnSize, int dataType) {
        return columnSize;
    }

    @Override
    public String getDisplayName() {
        return "Informix";
    }

    @Override
    public boolean supportsProduct(String databaseProductName, String databaseProductVersion) {
        if (databaseProductName == null) {
            return false;
        }
        return databaseProductName.toLowerCase().contains("informix");
    }

    @Override
    public boolean supportsDropColumn() {
        return true;
    }

    @Override
    public String getColumnDropSQL(String tableName, String columnName, DatabaseObjectQualifier qualifier, SqlGenerationPreferences prefs) {
        prefs.setQuoteColumnNames(false);
        return DialectUtils.getColumnDropSQL(tableName, columnName, qualifier, prefs, this);
    }

    @Override
    public List<String> getTableDropSQL(ITableInfo iTableInfo, boolean cascadeConstraints, boolean isMaterializedView, DatabaseObjectQualifier qualifier, SqlGenerationPreferences prefs) {
        return DialectUtils.getTableDropSQL(iTableInfo, true, cascadeConstraints, false, "CASCADE", false, qualifier, prefs, this);
    }

    @Override
    public String[] getAddPrimaryKeySQL(String pkName, TableColumnInfo[] columns, ITableInfo ti, DatabaseObjectQualifier qualifier, SqlGenerationPreferences prefs) {
        prefs.setQuoteColumnNames(false);
        prefs.setQuoteConstraintNames(false);
        return new String[]{DialectUtils.getAddIndexSQL(pkName, true, columns, qualifier, prefs, this), DialectUtils.getAddPrimaryKeySQL(ti, pkName, columns, true, qualifier, prefs, this)};
    }

    @Override
    public boolean supportsColumnComment() {
        return false;
    }

    @Override
    public String getColumnCommentAlterSQL(TableColumnInfo info, DatabaseObjectQualifier qualifier, SqlGenerationPreferences prefs) throws UnsupportedOperationException {
        int featureId = 0;
        String msg = DialectUtils.getUnsupportedMessage(this, featureId);
        throw new UnsupportedOperationException(msg);
    }

    @Override
    public boolean supportsAlterColumnNull() {
        return true;
    }

    @Override
    public String[] getColumnNullableAlterSQL(TableColumnInfo info, DatabaseObjectQualifier qualifier, SqlGenerationPreferences prefs) {
        String alterClause = "MODIFY";
        return new String[]{DialectUtils.getColumnNullableAlterSQL(info, this, alterClause, true, qualifier, prefs)};
    }

    @Override
    public boolean supportsRenameColumn() {
        return true;
    }

    @Override
    public String getColumnNameAlterSQL(TableColumnInfo from, TableColumnInfo to, DatabaseObjectQualifier qualifier, SqlGenerationPreferences prefs) {
        prefs.setQuoteColumnNames(false);
        return DialectUtils.getColumnRenameSQL(from, to, qualifier, prefs, this);
    }

    @Override
    public boolean supportsAlterColumnType() {
        return true;
    }

    @Override
    public List<String> getColumnTypeAlterSQL(TableColumnInfo from, TableColumnInfo to, DatabaseObjectQualifier qualifier, SqlGenerationPreferences prefs) throws UnsupportedOperationException {
        String alterClause = "MODIFY";
        String setClause = null;
        prefs.setQuoteColumnNames(false);
        return DialectUtils.getColumnTypeAlterSQL(this, alterClause, setClause, false, from, to, qualifier, prefs);
    }

    @Override
    public boolean supportsAlterColumnDefault() {
        return true;
    }

    @Override
    public String getColumnDefaultAlterSQL(TableColumnInfo info, DatabaseObjectQualifier qualifier, SqlGenerationPreferences prefs) {
        String alterClause = "MODIFY";
        String defaultClause = "DEFAULT";
        prefs.setQuoteColumnNames(false);
        return DialectUtils.getColumnDefaultAlterSQL(this, info, alterClause, true, defaultClause, qualifier, prefs);
    }

    @Override
    public String getDropPrimaryKeySQL(String pkName, String tableName, DatabaseObjectQualifier qualifier, SqlGenerationPreferences prefs) {
        prefs.setQuoteConstraintNames(false);
        return DialectUtils.getDropPrimaryKeySQL(pkName, tableName, true, false, qualifier, prefs, this);
    }

    @Override
    public String getDropForeignKeySQL(String fkName, String tableName, DatabaseObjectQualifier qualifier, SqlGenerationPreferences prefs) {
        return DialectUtils.getDropForeignKeySQL(fkName, tableName, qualifier, prefs, this);
    }

    @Override
    public List<String> getCreateTableSQL(List<ITableInfo> tables, ISQLDatabaseMetaData md, CreateScriptPreferences prefs, boolean isJdbcOdbc) throws SQLException {
        return DialectUtils.getCreateTableSQL(tables, md, this, prefs, isJdbcOdbc);
    }

    @Override
    public DialectType getDialectType() {
        return DialectType.INFORMIX;
    }

    @Override
    public String[] getIndexAccessMethodsTypes() {
        return new String[]{"NORMAL", "CLUSTERED"};
    }

    @Override
    public String[] getIndexStorageOptions() {
        return null;
    }

    @Override
    public String[] getAddAutoIncrementSQL(TableColumnInfo column, DatabaseObjectQualifier qualifier, SqlGenerationPreferences prefs) {
        StringBuilder result = new StringBuilder();
        result.append("ALTER TABLE");
        result.append(" ");
        result.append(DialectUtils.shapeQualifiableIdentifier(column.getTableName(), qualifier, prefs, this));
        result.append(" ");
        result.append("MODIFY");
        result.append(" ");
        result.append(column.getColumnName());
        result.append(" SERIAL");
        return new String[]{result.toString()};
    }

    @Override
    public String[] getAddColumnSQL(TableColumnInfo column, DatabaseObjectQualifier qualifier, SqlGenerationPreferences prefs) {
        boolean addDefaultClause = true;
        boolean supportsNullQualifier = false;
        boolean addNullClause = true;
        prefs.setQuoteColumnNames(false);
        String sql = DialectUtils.getAddColumSQL(column, this, addDefaultClause, supportsNullQualifier, addNullClause, qualifier, prefs);
        return new String[]{sql};
    }

    @Override
    public String[] getAddForeignKeyConstraintSQL(String localTableName, String refTableName, String constraintName, Boolean deferrable, Boolean initiallyDeferred, Boolean matchFull, boolean autoFKIndex, String fkIndexName, Collection<String[]> localRefColumns, String onUpdateAction, String onDeleteAction, DatabaseObjectQualifier qualifier, SqlGenerationPreferences prefs) {
        prefs.setQuoteColumnNames(false);
        prefs.setQuoteConstraintNames(false);
        StringBuilder result = new StringBuilder();
        result.append("ALTER TABLE");
        result.append(" ");
        result.append(DialectUtils.shapeQualifiableIdentifier(localTableName, qualifier, prefs, this));
        result.append(" ADD CONSTRAINT FOREIGN KEY ");
        result.append(" (");
        ArrayList<String> localColumns = new ArrayList<String>();
        StringBuilder refColumns = new StringBuilder();
        for (String[] columns : localRefColumns) {
            result.append(columns[0]);
            result.append(", ");
            localColumns.add(columns[0]);
            refColumns.append(columns[1]);
            refColumns.append(", ");
        }
        result.setLength(result.length() - 2);
        refColumns.setLength(refColumns.length() - 2);
        result.append(")\n REFERENCES ");
        result.append(DialectUtils.shapeQualifiableIdentifier(refTableName, qualifier, prefs, this));
        result.append(" (");
        result.append(refColumns.toString());
        result.append(")\n");
        result.append(" CONSTRAINT ");
        result.append(constraintName);
        return new String[]{result.toString()};
    }

    @Override
    public String[] getAddUniqueConstraintSQL(String tableName, String constraintName, TableColumnInfo[] columns, DatabaseObjectQualifier qualifier, SqlGenerationPreferences prefs) {
        StringBuilder sql = new StringBuilder();
        sql.append("ALTER TABLE");
        sql.append(" ");
        sql.append(DialectUtils.shapeQualifiableIdentifier(tableName, qualifier, prefs, this));
        sql.append("\n");
        sql.append(" ");
        sql.append("ADD CONSTRAINT");
        sql.append(" ");
        sql.append("UNIQUE");
        sql.append(" (");
        for (TableColumnInfo column : columns) {
            sql.append(column.getColumnName());
            sql.append(", ");
        }
        sql.delete(sql.length() - 2, sql.length());
        sql.append(")");
        sql.append(" CONSTRAINT ");
        sql.append(constraintName);
        return new String[]{sql.toString()};
    }

    @Override
    public String[] getAlterSequenceSQL(String sequenceName, String increment, String minimum, String maximum, String restart, String cache, boolean cycle, DatabaseObjectQualifier qualifier, SqlGenerationPreferences prefs) {
        String cycleClause = "CYCLE";
        if (!cycle) {
            cycleClause = "NOCYCLE";
        }
        return new String[]{DialectUtils.getAlterSequenceSQL(sequenceName, increment, minimum, maximum, restart, cache, cycleClause, qualifier, prefs, this)};
    }

    @Override
    public String getCreateIndexSQL(String indexName, String tableName, String accessMethod, String[] columns, boolean unique, String tablespace, String constraints, DatabaseObjectQualifier qualifier, SqlGenerationPreferences prefs) {
        String access = accessMethod == null || accessMethod.equalsIgnoreCase("NORMAL") ? null : "CLUSTER";
        StringBuilder sql = new StringBuilder();
        sql.append("CREATE ");
        if (unique) {
            sql.append("UNIQUE ");
        } else if (access != null) {
            sql.append(access);
        }
        sql.append(" ");
        sql.append("INDEX");
        sql.append(" ");
        sql.append(indexName);
        sql.append(" ON ").append(DialectUtils.shapeQualifiableIdentifier(tableName, qualifier, prefs, this));
        sql.append("(");
        for (String column : columns) {
            sql.append(column);
            sql.append(", ");
        }
        sql.delete(sql.length() - 2, sql.length());
        sql.append(")");
        return sql.toString();
    }

    @Override
    public String getCreateSequenceSQL(String sequenceName, String increment, String minimum, String maximum, String start, String cache, boolean cycle, DatabaseObjectQualifier qualifier, SqlGenerationPreferences prefs) {
        String cycleClause = "CYCLE";
        if (!cycle) {
            cycleClause = "NOCYCLE";
        }
        String minimumClause = "MINVALUE";
        if (minimum == null || "".equals("NOMINVALUE")) {
            minimumClause = "NOMINVALUE";
        }
        String maximumClause = "MAXVALUE";
        if (maximum == null || "".equals(maximum)) {
            maximumClause = "NOMAXVALUE";
        }
        return DialectUtils.getCreateSequenceSQL(sequenceName, increment, minimumClause, minimum, maximumClause, maximum, start, cache, cycleClause, qualifier, prefs, this);
    }

    @Override
    public String getCreateTableSQL(String tableName, List<TableColumnInfo> columns, List<TableColumnInfo> primaryKeys, SqlGenerationPreferences prefs, DatabaseObjectQualifier qualifier) {
        return DialectUtils.getCreateTableSQL(tableName, columns, primaryKeys, prefs, qualifier, this);
    }

    @Override
    public String getCreateViewSQL(String viewName, String definition, String checkOption, DatabaseObjectQualifier qualifier, SqlGenerationPreferences prefs) {
        return DialectUtils.getCreateViewSQL(viewName, definition, checkOption, qualifier, prefs, this);
    }

    @Override
    public String getDropConstraintSQL(String tableName, String constraintName, DatabaseObjectQualifier qualifier, SqlGenerationPreferences prefs) {
        prefs.setQuoteConstraintNames(false);
        return DialectUtils.getDropConstraintSQL(tableName, constraintName, qualifier, prefs, this);
    }

    @Override
    public String getDropIndexSQL(String tableName, String indexName, boolean cascade, DatabaseObjectQualifier qualifier, SqlGenerationPreferences prefs) {
        Boolean cascadeNotSupported = null;
        return DialectUtils.getDropIndexSQL(indexName, cascadeNotSupported, qualifier, prefs, this);
    }

    @Override
    public String getDropSequenceSQL(String sequenceName, boolean cascade, DatabaseObjectQualifier qualifier, SqlGenerationPreferences prefs) {
        Boolean cascadeNotSupported = null;
        return DialectUtils.getDropSequenceSQL(sequenceName, cascadeNotSupported, qualifier, prefs, this);
    }

    @Override
    public String getDropViewSQL(String viewName, boolean cascade, DatabaseObjectQualifier qualifier, SqlGenerationPreferences prefs) {
        return DialectUtils.getDropViewSQL(viewName, cascade, qualifier, prefs, this);
    }

    @Override
    public String getInsertIntoSQL(String tableName, List<String> columns, String valuesPart, DatabaseObjectQualifier qualifier, SqlGenerationPreferences prefs) {
        return DialectUtils.getInsertIntoSQL(tableName, columns, valuesPart, qualifier, prefs, this);
    }

    @Override
    public String getRenameTableSQL(String oldTableName, String newTableName, DatabaseObjectQualifier qualifier, SqlGenerationPreferences prefs) {
        StringBuilder result = new StringBuilder();
        result.append("RENAME TABLE ");
        result.append(DialectUtils.shapeQualifiableIdentifier(oldTableName, qualifier, prefs, this));
        result.append(" TO ");
        result.append(newTableName);
        return result.toString();
    }

    @Override
    public String[] getRenameViewSQL(String oldViewName, String newViewName, DatabaseObjectQualifier qualifier, SqlGenerationPreferences prefs) {
        return null;
    }

    @Override
    public String getSequenceInformationSQL(String sequenceName, DatabaseObjectQualifier qualifier, SqlGenerationPreferences prefs) {
        StringBuilder result = new StringBuilder();
        result.append("SELECT  ");
        result.append(sequenceName);
        result.append(".CURRVAL");
        result.append(" as last_value, ");
        result.append("T1.max_val   AS max_value, ");
        result.append("T1.min_val   AS min_value, ");
        result.append("T1.cache     AS cache_size, ");
        result.append("T1.inc_val   AS increment_by, ");
        result.append("T1.cycle \t AS is_cycled ");
        result.append("FROM    informix.syssequences AS T1, informix.systables AS T2 ");
        result.append("WHERE   T2.tabid     = T1.tabid ");
        result.append("and T2.owner = ");
        result.append("'");
        result.append(qualifier.getSchema());
        result.append("'");
        result.append("and T2.tabname =");
        result.append("'");
        result.append(sequenceName);
        result.append("'");
        return result.toString();
    }

    @Override
    public String[] getUpdateSQL(String tableName, String[] setColumns, String[] setValues, String[] fromTables, String[] whereColumns, String[] whereValues, DatabaseObjectQualifier qualifier, SqlGenerationPreferences prefs) {
        String templateStr = "";
        templateStr = fromTables != null ? "UPDATE $destTableName$ SET $columnName$ = (SELECT $columnName$ FROM $sourceTableName$ where $sourceTableName$.$whereColumnName$ = $destTableName$.$whereValue$)" : "UPDATE $destTableName$ SET $columnName$ = $columnValue$ where $whereColumnName$ = $whereValue$";
        StringTemplate st = new StringTemplate(templateStr);
        return DialectUtils.getUpdateSQL(st, tableName, setColumns, setValues, fromTables, whereColumns, whereValues, qualifier, prefs, this);
    }

    @Override
    public boolean supportsAccessMethods() {
        return false;
    }

    @Override
    public boolean supportsAddForeignKeyConstraint() {
        return true;
    }

    @Override
    public boolean supportsAddUniqueConstraint() {
        return true;
    }

    @Override
    public boolean supportsAlterSequence() {
        return true;
    }

    @Override
    public boolean supportsAutoIncrement() {
        return true;
    }

    @Override
    public boolean supportsCheckOptionsForViews() {
        return false;
    }

    @Override
    public boolean supportsCreateIndex() {
        return true;
    }

    @Override
    public boolean supportsCreateSequence() {
        return true;
    }

    @Override
    public boolean supportsCreateTable() {
        return true;
    }

    @Override
    public boolean supportsCreateView() {
        return true;
    }

    @Override
    public boolean supportsDropConstraint() {
        return true;
    }

    @Override
    public boolean supportsDropIndex() {
        return true;
    }

    @Override
    public boolean supportsDropSequence() {
        return true;
    }

    @Override
    public boolean supportsDropView() {
        return true;
    }

    @Override
    public boolean supportsEmptyTables() {
        return false;
    }

    @Override
    public boolean supportsIndexes() {
        return true;
    }

    @Override
    public boolean supportsInsertInto() {
        return true;
    }

    @Override
    public boolean supportsMultipleRowInserts() {
        return false;
    }

    @Override
    public boolean supportsRenameTable() {
        return true;
    }

    @Override
    public boolean supportsRenameView() {
        return false;
    }

    @Override
    public boolean supportsSequence() {
        return true;
    }

    @Override
    public boolean supportsSequenceInformation() {
        return true;
    }

    @Override
    public boolean supportsTablespace() {
        return false;
    }

    @Override
    public boolean supportsUpdate() {
        return true;
    }

    @Override
    public boolean supportsAddColumn() {
        return true;
    }

    @Override
    public boolean supportsViewDefinition() {
        return true;
    }

    @Override
    public String getViewDefinitionSQL(String viewName, DatabaseObjectQualifier qualifier, SqlGenerationPreferences prefs) {
        StringBuilder result = new StringBuilder();
        result.append("SELECT viewtext ");
        result.append("FROM informix.systables AS T1, informix.sysviews AS T2 ");
        result.append("WHERE tabname = '");
        result.append(viewName);
        result.append("' ");
        result.append("AND T2.tabid = T1.tabid");
        return result.toString();
    }

    @Override
    public String getQualifiedIdentifier(String identifier, DatabaseObjectQualifier qualifier, SqlGenerationPreferences prefs) {
        StringBuilder result = new StringBuilder();
        if (prefs.isQualifyTableNames()) {
            String catalog = qualifier.getCatalog();
            String schema = qualifier.getSchema();
            if (catalog != null && schema != null) {
                result.append(catalog);
                result.append(":");
                result.append(schema);
                result.append(".");
                result.append(identifier);
            }
        } else {
            result.append(identifier);
        }
        return result.toString();
    }

    @Override
    public boolean supportsCorrelatedSubQuery() {
        return true;
    }

    @Override
    public int getTimestampMaximumFractionalDigits() {
        return 8;
    }

    private class InformixDialectHelper
    extends InformixDialect {
        public InformixDialectHelper() {
            this.registerColumnType(-5, "integer");
            this.registerColumnType(-2, "byte");
            this.registerColumnType(-7, "smallint");
            this.registerColumnType(2004, "byte");
            this.registerColumnType(16, "smallint");
            this.registerColumnType(1, 32511, "char($l)");
            this.registerColumnType(1, "char(32511)");
            this.registerColumnType(2005, "text");
            this.registerColumnType(91, "date");
            this.registerColumnType(3, "decimal($p,$s)");
            this.registerColumnType(8, 15, "float($l)");
            this.registerColumnType(8, "float(15)");
            this.registerColumnType(6, 15, "float($l)");
            this.registerColumnType(6, "float(15)");
            this.registerColumnType(4, "integer");
            this.registerColumnType(-4, "byte");
            this.registerColumnType(-1, "text");
            this.registerColumnType(2, "numeric($p,$s)");
            this.registerColumnType(7, "real");
            this.registerColumnType(5, "smallint");
            this.registerColumnType(92, "datetime hour to second");
            this.registerColumnType(93, "datetime year to fraction(5)");
            this.registerColumnType(-6, "smallint");
            this.registerColumnType(-3, "byte");
            this.registerColumnType(12, 255, "varchar($l)");
            this.registerColumnType(12, "text");
        }
    }
}

