/*
 * Decompiled with CFR 0.152.
 */
package org.jmeld.ui;

import javax.swing.JPanel;
import javax.swing.event.UndoableEditEvent;
import javax.swing.event.UndoableEditListener;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.CompoundEdit;
import javax.swing.undo.UndoManager;
import javax.swing.undo.UndoableEdit;
import org.jmeld.ui.JMeldContentPanelIF;
import org.jmeld.ui.search.SearchHits;
import org.jmeld.util.ObjectUtil;

public class AbstractContentPanel
extends JPanel
implements JMeldContentPanelIF {
    private MyUndoManager undoManager = new MyUndoManager();
    private String id;

    public void setId(String id) {
        this.id = id;
    }

    public String getId() {
        return this.id;
    }

    public boolean isSaveEnabled() {
        return false;
    }

    public void doSave() {
    }

    public boolean checkSave() {
        return true;
    }

    public boolean isUndoEnabled() {
        return this.getUndoHandler().canUndo();
    }

    public void doUndo() {
        try {
            if (this.getUndoHandler().canUndo()) {
                this.getUndoHandler().undo();
            }
        }
        catch (CannotUndoException ex) {
            System.out.println("Unable to undo: " + ex);
            ex.printStackTrace();
        }
    }

    public boolean isRedoEnabled() {
        return this.getUndoHandler().canRedo();
    }

    public void doRedo() {
        try {
            if (this.getUndoHandler().canRedo()) {
                this.getUndoHandler().redo();
            }
        }
        catch (CannotUndoException ex) {
            System.out.println("Unable to undo: " + ex);
            ex.printStackTrace();
        }
    }

    public void doLeft() {
    }

    public void doRight() {
    }

    public void doUp() {
    }

    public void doDown() {
    }

    public void doZoom(boolean direction) {
    }

    public void doGoToSelected() {
    }

    public void doGoToFirst() {
    }

    public void doGoToLast() {
    }

    public void doGoToLine(int line) {
    }

    public void doStopSearch() {
    }

    public SearchHits doSearch() {
        return null;
    }

    public void doNextSearch() {
    }

    public void doPreviousSearch() {
    }

    public void doRefresh() {
    }

    public void doMergeMode(boolean mergeMode) {
    }

    public boolean checkExit() {
        return true;
    }

    public MyUndoManager getUndoHandler() {
        return this.undoManager;
    }

    public void checkActions() {
    }

    public String getSelectedText() {
        return null;
    }

    public boolean equals(Object o) {
        if (!(o instanceof AbstractContentPanel)) {
            return false;
        }
        return ObjectUtil.equals(((AbstractContentPanel)o).getId(), this.id);
    }

    public class MyUndoManager
    extends UndoManager
    implements UndoableEditListener {
        CompoundEdit activeEdit;

        private MyUndoManager() {
        }

        public void start(String text) {
            this.activeEdit = new CompoundEdit();
        }

        public void add(UndoableEdit edit) {
            this.addEdit(edit);
        }

        public void end(String text) {
            this.activeEdit.end();
            this.addEdit(this.activeEdit);
            this.activeEdit = null;
            AbstractContentPanel.this.checkActions();
        }

        public void undoableEditHappened(UndoableEditEvent e) {
            if (this.activeEdit != null) {
                this.activeEdit.addEdit(e.getEdit());
                return;
            }
            this.addEdit(e.getEdit());
            AbstractContentPanel.this.checkActions();
        }
    }
}

