/*
 * Decompiled with CFR 0.152.
 */
package org.jmeld.ui.text;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.nio.charset.Charset;
import org.jmeld.JMeldException;
import org.jmeld.ui.text.AbstractBufferDocument;
import org.jmeld.util.CharsetDetector;

public class FileDocument
extends AbstractBufferDocument {
    private File file;
    private Charset charset;

    public FileDocument(File file) {
        this.file = file;
        try {
            this.setName(file.getCanonicalPath());
        }
        catch (Exception ex) {
            ex.printStackTrace();
            this.setName(file.getName());
        }
        this.setShortName(file.getName());
    }

    public int getBufferSize() {
        return (int)this.file.length();
    }

    public Reader getReader() throws JMeldException {
        if (!this.file.isFile() || !this.file.canRead()) {
            throw new JMeldException("Could not open file: " + this.file.getAbsolutePath());
        }
        try {
            BufferedInputStream bis = new BufferedInputStream(new FileInputStream(this.file));
            this.charset = CharsetDetector.getInstance().getCharset(bis);
            return new BufferedReader(new InputStreamReader((InputStream)bis, this.charset));
        }
        catch (Exception ex) {
            throw new JMeldException("Could not create FileReader for : " + this.file.getName(), ex);
        }
    }

    protected Writer getWriter() throws JMeldException {
        try {
            BufferedOutputStream bos = new BufferedOutputStream(new FileOutputStream(this.file));
            return new BufferedWriter(new OutputStreamWriter((OutputStream)bos, this.charset));
        }
        catch (IOException ex) {
            throw new JMeldException("Cannot create FileWriter for file: " + this.file.getName(), ex);
        }
    }

    public static void main(String[] args) {
        try {
            FileDocument fd = new FileDocument(new File(args[0]));
            fd.read();
            fd.print();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }
}

