/*
 * Decompiled with CFR 0.152.
 */
package org.jmeld.util.file;

import java.io.CharArrayReader;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.io.Reader;
import java.nio.CharBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import org.jmeld.util.Ignore;
import org.jmeld.util.node.BufferNode;
import org.jmeld.util.node.FileNode;

public class CompareUtil {
    private static final int MAX_LINE_NUMBER = 1000;
    private static char[] leftLine = new char[1000];
    private static char[] rightLine = new char[1000];
    private static CharBuffer leftLineBuffer = CharBuffer.allocate(10000);
    private static CharBuffer rightLineBuffer = CharBuffer.allocate(10000);
    private static CharBuffer leftLineOutputBuffer = CharBuffer.allocate(10000);
    private static CharBuffer rightLineOutputBuffer = CharBuffer.allocate(10000);

    private CompareUtil() {
    }

    public static boolean contentEquals(BufferNode nodeLeft, BufferNode nodeRight, Ignore ignore) {
        if (nodeLeft instanceof FileNode && nodeRight instanceof FileNode) {
            return CompareUtil.contentEquals((FileNode)nodeLeft, (FileNode)nodeRight, ignore);
        }
        try {
            return CompareUtil.contentEquals(nodeLeft.getDocument().getReader(), nodeRight.getDocument().getReader(), ignore);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean contentEquals(FileNode nodeLeft, FileNode nodeRight, Ignore ignore) {
        File fileLeft = nodeLeft.getFile();
        File fileRight = nodeRight.getFile();
        RandomAccessFile fLeft = null;
        RandomAccessFile fRight = null;
        try {
            boolean equals;
            if (fileLeft.isDirectory() || fileRight.isDirectory()) {
                boolean bl = true;
                return bl;
            }
            if (!ignore.ignore && fileLeft.length() != fileRight.length()) {
                boolean bl = false;
                return bl;
            }
            if (!ignore.ignore || fileLeft.length() == fileRight.length()) {
                fLeft = new RandomAccessFile(fileLeft, "r");
                fRight = new RandomAccessFile(fileRight, "r");
                FileChannel fcLeft = fLeft.getChannel();
                FileChannel fcRight = fRight.getChannel();
                MappedByteBuffer bbLeft = fcLeft.map(FileChannel.MapMode.READ_ONLY, 0L, (int)fcLeft.size());
                MappedByteBuffer bbRight = fcRight.map(FileChannel.MapMode.READ_ONLY, 0L, (int)fcRight.size());
                equals = bbLeft.equals(bbRight);
                if (!ignore.ignore || equals) {
                    boolean bl = equals;
                    return bl;
                }
            }
            boolean bl = equals = CompareUtil.contentEquals(nodeLeft.getDocument().getReader(), nodeRight.getDocument().getReader(), ignore);
            return bl;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            boolean bl = false;
            return bl;
        }
        finally {
            try {
                if (fLeft != null) {
                    fLeft.close();
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            try {
                if (fRight != null) {
                    fRight.close();
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    public static boolean contentEquals(char[] left, char[] right, Ignore ignore) {
        try {
            return CompareUtil.contentEquals(new CharArrayReader(left), new CharArrayReader(right), ignore);
        }
        catch (IOException ex) {
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static synchronized boolean contentEquals(Reader readerLeft, Reader readerRight, Ignore ignore) throws IOException {
        try {
            while (true) {
                boolean rightEOF;
                boolean leftEOF = CompareUtil.readLine(readerLeft, leftLineBuffer);
                CompareUtil.removeIgnoredChars(leftLineBuffer, ignore, leftLineOutputBuffer);
                if (leftLineOutputBuffer.remaining() == 0 && !leftEOF) continue;
                do {
                    rightEOF = CompareUtil.readLine(readerRight, rightLineBuffer);
                    CompareUtil.removeIgnoredChars(rightLineBuffer, ignore, rightLineOutputBuffer);
                } while (rightLineOutputBuffer.remaining() == 0 && !rightEOF);
                if (leftLineOutputBuffer.remaining() != 0 && rightLineOutputBuffer.remaining() != 0 && !leftLineOutputBuffer.equals(rightLineOutputBuffer)) {
                    boolean bl = false;
                    return bl;
                }
                if (leftEOF && !rightEOF || !leftEOF && rightEOF) {
                    boolean bl = false;
                    return bl;
                }
                if (leftEOF && rightEOF) break;
            }
            boolean bl = true;
            return bl;
        }
        finally {
            readerLeft.close();
            readerRight.close();
        }
    }

    private static boolean readLine(Reader reader, CharBuffer lineBuffer) throws IOException {
        int c;
        lineBuffer.clear();
        while ((c = reader.read()) != -1) {
            lineBuffer.put((char)c);
            if (c == 10) break;
            if (c != 13) continue;
            reader.mark(1);
            int nextChar = reader.read();
            if (nextChar == 10) {
                lineBuffer.put((char)nextChar);
                break;
            }
            reader.reset();
            break;
        }
        return c == -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static synchronized boolean contentEquals_old(Reader readerLeft, Reader readerRight, Ignore ignore) throws IOException {
        boolean equals;
        block35: {
            int leftLineIndex = 0;
            int rightLineIndex = 0;
            equals = false;
            int leftChar = 0;
            int rightChar = 0;
            boolean previousEolLeft = true;
            boolean previousEolRight = true;
            try {
                while (true) {
                    int nextChar;
                    boolean eol;
                    boolean leftFound = false;
                    boolean whitespaceAtBegin = true;
                    int whitespaceIndex = -1;
                    while ((leftChar = readerLeft.read()) != -1) {
                        eol = CompareUtil.isEOL(leftChar);
                        if ((ignore.ignoreEOL || ignore.ignoreBlankLines || ignore.ignoreWhitespace) && eol) {
                            readerLeft.mark(1);
                            nextChar = readerLeft.read();
                            if (!(leftChar == 10 && nextChar == 13 || leftChar == 13 && nextChar == 10)) {
                                readerLeft.reset();
                            }
                            leftChar = 10;
                        }
                        if (ignore.ignoreBlankLines && previousEolLeft && eol) continue;
                        if (!eol) {
                            if (ignore.ignoreWhitespace) {
                                if (Character.isWhitespace(leftChar)) {
                                    if (whitespaceIndex == -1) {
                                        whitespaceIndex = leftLineIndex;
                                    }
                                } else if (whitespaceIndex != -1) {
                                    if (whitespaceAtBegin) {
                                        whitespaceAtBegin = false;
                                        if (ignore.ignoreWhitespaceAtBegin) {
                                            leftLineIndex = whitespaceIndex;
                                        }
                                    } else if (ignore.ignoreWhitespaceInBetween) {
                                        leftLineIndex = whitespaceIndex;
                                    }
                                    whitespaceIndex = -1;
                                }
                            }
                            if (ignore.ignoreCase) {
                                leftChar = Character.toLowerCase(leftChar);
                            }
                        }
                        previousEolLeft = eol;
                        CompareUtil.leftLine[leftLineIndex] = (char)leftChar;
                        if (!eol && ++leftLineIndex < 1000) continue;
                        if (whitespaceIndex == -1 || !ignore.ignoreWhitespaceAtEnd) break;
                        leftLineIndex = whitespaceIndex;
                        break;
                    }
                    boolean rightFound = false;
                    whitespaceAtBegin = true;
                    whitespaceIndex = -1;
                    while ((rightChar = readerRight.read()) != -1) {
                        eol = CompareUtil.isEOL(rightChar);
                        if ((ignore.ignoreEOL || ignore.ignoreBlankLines || ignore.ignoreWhitespace) && eol) {
                            readerRight.mark(1);
                            nextChar = readerRight.read();
                            if (!(rightChar == 10 && nextChar == 13 || rightChar == 13 && nextChar == 10)) {
                                readerRight.reset();
                            }
                            rightChar = 10;
                        }
                        if (ignore.ignoreBlankLines && previousEolRight && eol) continue;
                        if (!eol) {
                            if (ignore.ignoreWhitespace) {
                                if (Character.isWhitespace(rightChar)) {
                                    if (whitespaceIndex == -1) {
                                        whitespaceIndex = rightLineIndex;
                                    }
                                } else if (whitespaceIndex != -1) {
                                    if (whitespaceAtBegin) {
                                        whitespaceAtBegin = false;
                                        if (ignore.ignoreWhitespaceAtBegin) {
                                            rightLineIndex = whitespaceIndex;
                                        }
                                    } else if (ignore.ignoreWhitespaceInBetween) {
                                        rightLineIndex = whitespaceIndex;
                                    }
                                    whitespaceIndex = -1;
                                }
                            }
                            if (ignore.ignoreCase) {
                                rightChar = Character.toLowerCase(rightChar);
                            }
                        }
                        previousEolRight = eol;
                        CompareUtil.rightLine[rightLineIndex] = (char)rightChar;
                        if (!eol && ++rightLineIndex < 1000) continue;
                        if (whitespaceIndex == -1 || !ignore.ignoreWhitespaceAtEnd) break;
                        rightLineIndex = whitespaceIndex;
                        break;
                    }
                    if (leftLineIndex > 0 && leftLineIndex == rightLineIndex) {
                        if (CompareUtil.equals(leftLine, rightLine, leftLineIndex)) {
                            leftLineIndex = 0;
                            rightLineIndex = 0;
                            continue;
                        }
                        equals = false;
                        break block35;
                    }
                    if (leftLineIndex != rightLineIndex) {
                        equals = false;
                        break block35;
                    }
                    if (leftLineIndex == 0 && rightLineIndex == 0) break;
                }
                equals = true;
            }
            finally {
                readerLeft.close();
                readerRight.close();
            }
        }
        return equals;
    }

    private static boolean equals(char[] a1, char[] a2, int size) {
        for (int i = 0; i < size; ++i) {
            if (a1[i] == a2[i]) continue;
            return false;
        }
        return true;
    }

    public static boolean isEOL(int character) {
        return character == 10 || character == 13;
    }

    public static void removeIgnoredChars(CharBuffer inputLine, Ignore ignore, CharBuffer outputLine) {
        int index;
        int length;
        inputLine.flip();
        outputLine.clear();
        int lineEndingEndIndex = length = inputLine.remaining();
        boolean blankLine = true;
        boolean whiteSpaceInBetweenIgnored = false;
        char c = '\u0000';
        for (index = lineEndingEndIndex - 1; index >= 0 && CompareUtil.isEOL(inputLine.charAt(index)); --index) {
            --lineEndingEndIndex;
        }
        int whitespaceEndIndex = lineEndingEndIndex;
        for (index = whitespaceEndIndex - 1; index >= 0 && Character.isWhitespace(inputLine.charAt(index)); --index) {
            --whitespaceEndIndex;
        }
        boolean whitespaceAtBegin = true;
        for (int i = 0; i < length; ++i) {
            c = inputLine.get(i);
            if (i < whitespaceEndIndex) {
                if (Character.isWhitespace(c)) {
                    if (whitespaceAtBegin) {
                        if (ignore.ignoreWhitespaceAtBegin) {
                            continue;
                        }
                    } else if (ignore.ignoreWhitespaceInBetween) {
                        whiteSpaceInBetweenIgnored = true;
                        continue;
                    }
                }
                whitespaceAtBegin = false;
                blankLine = false;
            } else if (i < lineEndingEndIndex) {
                if (ignore.ignoreWhitespaceAtEnd) continue;
                blankLine = false;
            } else if (ignore.ignoreEOL) continue;
            if (ignore.ignoreCase) {
                c = Character.toLowerCase(c);
            }
            if (whiteSpaceInBetweenIgnored) {
                whiteSpaceInBetweenIgnored = false;
            }
            outputLine.put(c);
        }
        if (outputLine.position() == 0 && !ignore.ignoreBlankLines) {
            outputLine.put('\n');
        }
        if (blankLine && ignore.ignoreBlankLines) {
            outputLine.clear();
        }
        outputLine.flip();
    }
}

