/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.plugins.sqlscript.table_script;

import net.sourceforge.squirrel_sql.client.session.IObjectTreeAPI;
import net.sourceforge.squirrel_sql.client.session.ISQLPanelAPI;
import net.sourceforge.squirrel_sql.client.session.ISession;
import net.sourceforge.squirrel_sql.fw.gui.GUIUtils;
import net.sourceforge.squirrel_sql.fw.sql.IDatabaseObjectInfo;
import net.sourceforge.squirrel_sql.fw.sql.ISQLConnection;
import net.sourceforge.squirrel_sql.fw.sql.ITableInfo;
import net.sourceforge.squirrel_sql.fw.sql.TableColumnInfo;
import net.sourceforge.squirrel_sql.fw.util.ICommand;
import net.sourceforge.squirrel_sql.plugins.sqlscript.FrameWorkAcessor;
import net.sourceforge.squirrel_sql.plugins.sqlscript.SQLScriptPlugin;
import net.sourceforge.squirrel_sql.plugins.sqlscript.table_script.ScriptUtil;

public class CreateSelectScriptCommand
implements ICommand {
    private ISession _session;
    private final SQLScriptPlugin _plugin;

    public CreateSelectScriptCommand(ISession session, SQLScriptPlugin plugin) {
        this._session = session;
        this._plugin = plugin;
    }

    public void execute() {
        IObjectTreeAPI api = FrameWorkAcessor.getObjectTreeAPI(this._session, this._plugin);
        IDatabaseObjectInfo[] dbObjs = api.getSelectedDatabaseObjects();
        this.scriptSelectsToSQLEntryArea(dbObjs);
    }

    public void scriptSelectsToSQLEntryArea(final IDatabaseObjectInfo[] dbObjs) {
        this._session.getApplication().getThreadPool().addTask(new Runnable(){

            @Override
            public void run() {
                final String script = CreateSelectScriptCommand.this.createSelectScriptString(dbObjs);
                if (null != script) {
                    GUIUtils.processOnSwingEventThread((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            ISQLPanelAPI api = FrameWorkAcessor.getSQLPanelAPI(CreateSelectScriptCommand.this._session, CreateSelectScriptCommand.this._plugin);
                            api.appendSQLScript(script, true);
                            CreateSelectScriptCommand.this._session.selectMainTab(1);
                        }
                    });
                }
            }
        });
    }

    public String createSelectScriptString(IDatabaseObjectInfo[] dbObjs) {
        StringBuffer sbScript = new StringBuffer(1000);
        StringBuffer sbConstraints = new StringBuffer(1000);
        ISQLConnection conn = this._session.getSQLConnection();
        try {
            boolean isJdbcOdbc = conn.getSQLMetaData().getURL().startsWith("jdbc:odbc:");
            if (isJdbcOdbc) {
                this._session.showErrorMessage("JDBC-ODBC Bridge doesn't provide necessary meta data. Script will be incomplete");
            }
            for (int k = 0; k < dbObjs.length; ++k) {
                if (!(dbObjs[k] instanceof ITableInfo)) continue;
                ITableInfo ti = (ITableInfo)dbObjs[k];
                sbScript.append("SELECT ");
                TableColumnInfo[] infos = conn.getSQLMetaData().getColumnInfo(ti);
                for (int i = 0; i < infos.length; ++i) {
                    if (0 < i) {
                        sbScript.append(',');
                    }
                    sbScript.append(infos[i].getColumnName());
                }
                sbScript.append(" FROM ").append(ScriptUtil.getTableName(ti));
                sbScript.append(ScriptUtil.getStatementSeparator(this._session)).append('\n');
            }
        }
        catch (Exception e) {
            this._session.showErrorMessage((Throwable)e);
        }
        return sbScript.append("\n").append(sbConstraints).toString();
    }
}

