/*
 * Decompiled with CFR 0.152.
 */
package com.l2fprod.util;

import com.l2fprod.gui.plaf.skin.SkinTitlePane;
import com.l2fprod.gui.plaf.skin.SkinWindowButton;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.Window;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLayeredPane;
import javax.swing.JRootPane;

public class WindowUtils {
    public static void centerOnScreen(Window w) {
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension size = w.getSize();
        w.setLocation((screenSize.width - size.width) / 2, (screenSize.height - size.height) / 2);
    }

    public static void sizeTo(Window w, double x, double y) {
        Dimension size = Toolkit.getDefaultToolkit().getScreenSize();
        w.setSize((int)((double)size.width * x), (int)((double)size.height * y));
    }

    public static JButton getWindowButton(JFrame window, String name) {
        return WindowUtils.getWindowButton(window.getRootPane(), name);
    }

    public static JButton getWindowButton(JDialog window, String name) {
        return WindowUtils.getWindowButton(window.getRootPane(), name);
    }

    public static JButton getWindowButton(JRootPane rootPane, String name) {
        JLayeredPane jlp = rootPane.getLayeredPane();
        for (int i = 0; i < jlp.getComponentCount(); ++i) {
            Component comp = jlp.getComponent(i);
            if (!(comp instanceof SkinTitlePane)) continue;
            SkinTitlePane stp = (SkinTitlePane)comp;
            for (int j = 0; j < stp.getComponentCount(); ++j) {
                SkinWindowButton swb;
                Component comp2 = stp.getComponent(j);
                if (!(comp2 instanceof SkinWindowButton) || !name.equals((swb = (SkinWindowButton)comp2).getActionCommand())) continue;
                return swb;
            }
        }
        return null;
    }
}

