/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.plugins.graph.link;

import java.awt.Toolkit;
import java.awt.datatransfer.DataFlavor;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.FileWriter;
import net.sourceforge.squirrel_sql.client.IApplication;
import net.sourceforge.squirrel_sql.client.action.SquirrelAction;
import net.sourceforge.squirrel_sql.client.plugin.PluginResources;
import net.sourceforge.squirrel_sql.client.session.ISession;
import net.sourceforge.squirrel_sql.client.session.action.ISessionAction;
import net.sourceforge.squirrel_sql.fw.util.IResources;
import net.sourceforge.squirrel_sql.fw.util.log.ILogger;
import net.sourceforge.squirrel_sql.fw.util.log.LoggerController;
import net.sourceforge.squirrel_sql.fw.xml.XMLBeanReader;
import net.sourceforge.squirrel_sql.fw.xml.XMLBeanWriter;
import net.sourceforge.squirrel_sql.plugins.graph.GraphPlugin;
import net.sourceforge.squirrel_sql.plugins.graph.xmlbeans.GraphControllerXmlBean;
import net.sourceforge.squirrel_sql.plugins.graph.xmlbeans.GraphXmlSerializer;

public class PasteGraphAction
extends SquirrelAction
implements ISessionAction {
    private static final ILogger s_log = LoggerController.createLogger(PasteGraphAction.class);
    private GraphPlugin _plugin;
    private ISession _session;

    public PasteGraphAction(IApplication app, PluginResources resources, GraphPlugin plugin) {
        super(app, (IResources)resources);
        this._plugin = plugin;
    }

    public void actionPerformed(ActionEvent e) {
        try {
            if (null == this._session) {
                return;
            }
            String data = (String)Toolkit.getDefaultToolkit().getSystemClipboard().getData(DataFlavor.stringFlavor);
            File graphTmp = File.createTempFile("graphTmp_", "_.xml");
            FileWriter fw = new FileWriter(graphTmp);
            fw.write(data);
            fw.flush();
            fw.close();
            XMLBeanReader br = new XMLBeanReader();
            try {
                br.load(graphTmp, ((Object)((Object)this)).getClass().getClassLoader());
            }
            catch (Exception exc) {
                this._session.showWarningMessage("Could not interpret clipboard as Graph: " + exc.getMessage());
                s_log.warn((Object)"Could not interpret clipboard as Graph: ", (Throwable)exc);
                return;
            }
            GraphControllerXmlBean bean = (GraphControllerXmlBean)br.iterator().next();
            String title = this._plugin.patchName(bean.getTitle(), this._session);
            if (!title.equals(bean.getTitle())) {
                bean.setTitle(title);
                XMLBeanWriter xbw = new XMLBeanWriter((Object)bean);
                xbw.save(graphTmp);
            }
            String graphFile = graphTmp.getAbsolutePath();
            GraphXmlSerializer graphXmlSerializer = new GraphXmlSerializer(this._plugin, this._session, graphFile);
            this._plugin.createNewGraphControllerForSession(this._session, graphXmlSerializer, true);
        }
        catch (Exception exc) {
            throw new RuntimeException(exc);
        }
    }

    public void setSession(ISession session) {
        this._session = session;
    }
}

