/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.converter;

import com.jidesoft.converter.ObjectConverterManager;
import com.jidesoft.swing.JideSwingUtilities;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class XmlUtils {
    private static final Pattern mutatorPattern = Pattern.compile("^set([A-Z0-9_][A-Za-z0-9_]*)$");
    private static final int MUTATOR = 2;
    private static final int ANYOTHER = 0;

    public static void readElement(Object object, Element element) {
        Method[] methods;
        if (object == null) {
            return;
        }
        NamedNodeMap map = element.getAttributes();
        HashMap<String, String> properties = new HashMap<String, String>();
        for (int i = 0; i < map.getLength(); ++i) {
            Node node = map.item(i);
            String name = node.getNodeName();
            properties.put(name, node.getNodeValue());
        }
        for (Method method : methods = object.getClass().getMethods()) {
            Object value;
            String name;
            int methodType = 0;
            Class<?> type = null;
            if (!Modifier.isPublic(method.getModifiers()) || Modifier.isStatic(method.getModifiers())) continue;
            Matcher matcher = mutatorPattern.matcher(method.getName());
            if (matcher.matches() && method.getReturnType() == Void.TYPE && method.getParameterTypes().length == 1) {
                methodType = 2;
                type = method.getParameterTypes()[0];
            }
            if (methodType != 2 || (name = matcher.group(1)).equals("Class") || (value = properties.get(name = name.substring(0, 1).toLowerCase() + name.substring(1))) == null) continue;
            try {
                method.invoke(object, ObjectConverterManager.fromString((String)value, type));
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
            catch (InvocationTargetException e) {
                JideSwingUtilities.ignoreException(e);
            }
        }
    }
}

