/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.swing;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Panel;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import javax.swing.JComponent;

public class HeavyweightWrapper
extends Panel {
    private Component _component;
    private boolean _heavyweight;

    public HeavyweightWrapper(Component component, boolean heavyweight) {
        this._component = component;
        ((JComponent)this._component).putClientProperty("HeavyweightWrapper", this);
        if (this._component != null) {
            this._component.addComponentListener(new ComponentListener(){

                @Override
                public void componentResized(ComponentEvent e) {
                }

                @Override
                public void componentMoved(ComponentEvent e) {
                }

                @Override
                public void componentShown(ComponentEvent e) {
                    HeavyweightWrapper.this.setVisible(true);
                }

                @Override
                public void componentHidden(ComponentEvent e) {
                    HeavyweightWrapper.this.setVisible(false);
                }
            });
        }
        this.setLayout(new BorderLayout());
        this._heavyweight = heavyweight;
    }

    public HeavyweightWrapper(Component component) {
        this(component, false);
    }

    public boolean isHeavyweight() {
        return this._heavyweight;
    }

    public void setHeavyweight(boolean heavyweight) {
        this._heavyweight = heavyweight;
    }

    public void delegateAdd(Container parent, Object constraints) {
        if (this.isHeavyweight()) {
            if (this._component.getParent() != this) {
                this.add(this._component);
            }
            if (this.getParent() != parent) {
                parent.add((Component)this, constraints);
            }
        } else {
            parent.add(this._component, constraints);
        }
    }

    public void delegateRemove(Container parent) {
        if (this.isHeavyweight()) {
            this.remove(this._component);
            parent.remove(this);
        } else {
            parent.remove(this._component);
        }
    }

    public void delegateSetVisible(boolean visible) {
        if (this.isHeavyweight()) {
            this.setVisible(visible);
            this._component.setVisible(visible);
        } else {
            this._component.setVisible(visible);
        }
    }

    public void delegateSetBounds(Rectangle bounds) {
        if (this.isHeavyweight()) {
            this.setBounds(bounds);
            this._component.setBounds(0, 0, bounds.width, bounds.height);
        } else {
            this._component.setBounds(bounds);
        }
    }

    public void delegateSetBounds(int x, int y, int width, int height) {
        if (this.isHeavyweight()) {
            this.setBounds(x, y, width, height);
            this._component.setBounds(0, 0, width, height);
        } else {
            this._component.setBounds(x, y, width, height);
        }
    }

    public void delegateSetLocation(int x, int y) {
        if (this.isHeavyweight()) {
            this.setLocation(x, y);
            this._component.setLocation(0, 0);
        } else {
            this._component.setLocation(x, y);
        }
    }

    public void delegateSetLocation(Point p) {
        if (this.isHeavyweight()) {
            this.setLocation(p);
            this._component.setLocation(0, 0);
        } else {
            this._component.setLocation(p);
        }
    }

    public void delegateSetCursor(Cursor cursor) {
        this._component.setCursor(cursor);
    }

    public void delegateSetNull() {
        ((JComponent)this._component).putClientProperty("HeavyweightWrapper", null);
        this._component = null;
    }

    public Container delegateGetParent() {
        if (this.isHeavyweight()) {
            return this.getParent();
        }
        return this._component.getParent();
    }

    public boolean delegateIsVisible() {
        if (this.isHeavyweight()) {
            return this.isVisible();
        }
        return this._component.isVisible();
    }

    public Rectangle delegateGetBounds() {
        if (this.isHeavyweight()) {
            return this.getBounds();
        }
        return this._component.getBounds();
    }

    public void delegateRepaint() {
        if (this.isHeavyweight()) {
            this.repaint();
            this._component.repaint();
        } else {
            this._component.repaint();
        }
    }

    public Component getComponent() {
        return this._component;
    }

    public void setComponent(Component component) {
        this._component = component;
    }
}

