/*
 * Decompiled with CFR 0.152.
 */
package com.digitprop.tonic;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import javax.swing.JButton;
import javax.swing.SwingConstants;
import javax.swing.UIManager;

class ArrowButton
extends JButton
implements SwingConstants {
    protected int direction;
    private Color shadow;
    private Color darkShadow;
    private Color highlight;
    protected boolean drawLeftBorder = true;
    protected boolean drawRightBorder = true;
    protected boolean drawTopBorder = true;
    protected boolean drawBottomBorder = true;

    public ArrowButton(int direction, Color background, Color shadow, Color darkShadow, Color highlight) {
        this.setRequestFocusEnabled(false);
        this.setDirection(direction);
        this.setBackground(background);
        this.shadow = shadow;
        this.darkShadow = darkShadow;
        this.highlight = highlight;
    }

    public ArrowButton(int direction) {
        this(direction, UIManager.getColor("control"), UIManager.getColor("controlShadow"), UIManager.getColor("controlDkShadow"), UIManager.getColor("controlLtHighlight"));
    }

    public void setDrawBottomBorder(boolean drawBottomBorder) {
        this.drawBottomBorder = drawBottomBorder;
    }

    public int getDirection() {
        return this.direction;
    }

    public void setDirection(int dir) {
        this.direction = dir;
    }

    public void paint(Graphics g) {
        int w = this.getSize().width;
        int h = this.getSize().height;
        Color origColor = g.getColor();
        boolean isPressed = this.getModel().isPressed();
        boolean isEnabled = this.isEnabled();
        g.setColor(this.getBackground());
        g.fillRect(0, 0, w, h);
        g.setColor(UIManager.getColor("Button.borderColor"));
        if (this.drawLeftBorder) {
            g.drawLine(0, 0, 0, h);
        }
        if (this.drawTopBorder) {
            g.drawLine(0, 0, w, 0);
        }
        if (this.drawRightBorder) {
            g.drawLine(w - 1, 0, w - 1, h);
        }
        if (this.drawBottomBorder) {
            g.drawLine(0, h - 1, w - 1, h - 1);
        }
        if (h < 5 || w < 5) {
            g.setColor(origColor);
            return;
        }
        if (isPressed) {
            g.translate(1, 1);
        }
        int size = Math.min((h - 4) / 3, (w - 4) / 3);
        size = Math.max(size, 2);
        this.paintTriangle(g, (w - size) / 2, (h - size) / 2, size, this.direction, isEnabled);
        if (isPressed) {
            g.translate(-1, -1);
        }
        g.setColor(origColor);
    }

    public Dimension getPreferredSize() {
        return new Dimension(16, 16);
    }

    public Dimension getMinimumSize() {
        return new Dimension(5, 5);
    }

    public Dimension getMaximumSize() {
        return new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE);
    }

    public boolean isFocusTraversable() {
        return false;
    }

    public void paintTriangle(Graphics g, int x, int y, int size, int direction, boolean isEnabled) {
        Color oldColor = g.getColor();
        int j = 0;
        size = Math.max(size, 2);
        int mid = size / 2 - 1;
        g.translate(x, y);
        if (isEnabled) {
            g.setColor(this.darkShadow);
        } else {
            g.setColor(this.shadow);
        }
        switch (direction) {
            case 1: {
                int i = 0;
                while (i < size) {
                    g.drawLine(mid - i, i, mid + i, i);
                    ++i;
                }
                if (isEnabled) break;
                g.setColor(this.highlight);
                g.drawLine(mid - i + 2, i, mid + i, i);
                break;
            }
            case 5: {
                int i;
                if (!isEnabled) {
                    g.translate(1, 1);
                    g.setColor(this.highlight);
                    i = size - 1;
                    while (i >= 0) {
                        g.drawLine(mid - i, j, mid + i, j);
                        ++j;
                        --i;
                    }
                    g.translate(-1, -1);
                    g.setColor(this.shadow);
                }
                j = 0;
                i = size - 1;
                while (i >= 0) {
                    g.drawLine(mid - i, j, mid + i, j);
                    ++j;
                    --i;
                }
                break;
            }
            case 7: {
                int i = 0;
                while (i < size) {
                    g.drawLine(i, mid - i, i, mid + i);
                    ++i;
                }
                if (isEnabled) break;
                g.setColor(this.highlight);
                g.drawLine(i, mid - i + 2, i, mid + i);
                break;
            }
            case 3: {
                int i;
                if (!isEnabled) {
                    g.translate(1, 1);
                    g.setColor(this.highlight);
                    i = size - 1;
                    while (i >= 0) {
                        g.drawLine(j, mid - i, j, mid + i);
                        ++j;
                        --i;
                    }
                    g.translate(-1, -1);
                    g.setColor(this.shadow);
                }
                j = 0;
                i = size - 1;
                while (i >= 0) {
                    g.drawLine(j, mid - i, j, mid + i);
                    ++j;
                    --i;
                }
                break;
            }
        }
        g.translate(-x, -y);
        g.setColor(oldColor);
    }
}

