/*
 * Decompiled with CFR 0.152.
 */
package com.digitprop.tonic;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.Insets;

public class VariableGridLayout
extends GridLayout {
    int hgap;
    int vgap;
    int rows;
    int cols;

    public VariableGridLayout() {
        this(1, 0, 0, 0);
    }

    public VariableGridLayout(int rows, int cols) {
        this(rows, cols, 0, 0);
    }

    public VariableGridLayout(int rows, int cols, int hgap, int vgap) {
        if (rows == 0 && cols == 0) {
            throw new IllegalArgumentException("rows and cols cannot both be zero");
        }
        this.rows = rows;
        this.cols = cols;
        this.hgap = hgap;
        this.vgap = vgap;
    }

    public int getRows() {
        return this.rows;
    }

    public void setRows(int rows) {
        if (rows == 0 && this.cols == 0) {
            throw new IllegalArgumentException("rows and cols cannot both be zero");
        }
        this.rows = rows;
    }

    public int getColumns() {
        return this.cols;
    }

    public void setColumns(int cols) {
        if (cols == 0 && this.rows == 0) {
            throw new IllegalArgumentException("rows and cols cannot both be zero");
        }
        this.cols = cols;
    }

    public int getHgap() {
        return this.hgap;
    }

    public void setHgap(int hgap) {
        this.hgap = hgap;
    }

    public int getVgap() {
        return this.vgap;
    }

    public void setVgap(int vgap) {
        this.vgap = vgap;
    }

    public void addLayoutComponent(String name, Component comp) {
    }

    public void removeLayoutComponent(Component comp) {
    }

    public Dimension preferredLayoutSize(Container parent) {
        Object object = parent.getTreeLock();
        synchronized (object) {
            Insets insets = parent.getInsets();
            int ncomponents = parent.getComponentCount();
            int nrows = this.rows;
            int ncols = this.cols;
            if (nrows > 0) {
                ncols = (ncomponents + nrows - 1) / nrows;
            } else {
                nrows = (ncomponents + ncols - 1) / ncols;
            }
            int w = 0;
            int h = 0;
            int[] colWidths = this.getColWidths(ncols, nrows, parent);
            int i = 0;
            while (i < colWidths.length) {
                w += colWidths[i];
                ++i;
            }
            int[] rowHeights = this.getRowHeights(ncols, nrows, parent);
            int i2 = 0;
            while (i2 < rowHeights.length) {
                h += rowHeights[i2];
                ++i2;
            }
            return new Dimension(insets.left + insets.right + w + (ncols - 1) * this.hgap, insets.top + insets.bottom + h + (nrows - 1) * this.vgap);
        }
    }

    private int[] getRowHeights(int ncols, int nrows, Container parent) {
        int[] result = new int[nrows];
        int ncomponents = parent.getComponentCount();
        int y = 0;
        while (y < nrows) {
            int currHeight = 0;
            int x = 0;
            while (x < ncols) {
                if (x + y * ncols < ncomponents) {
                    Component c = parent.getComponent(x + y * ncols);
                    int h = c.getPreferredSize().height;
                    currHeight = Math.max(currHeight, h);
                }
                ++x;
            }
            result[y] = currHeight;
            ++y;
        }
        return result;
    }

    private int[] getColWidths(int ncols, int nrows, Container parent) {
        int[] result = new int[ncols];
        int ncomponents = parent.getComponentCount();
        int x = 0;
        while (x < ncols) {
            int currWidth = 0;
            int y = 0;
            while (y < nrows) {
                if (x + y * ncols < ncomponents) {
                    currWidth = Math.max(currWidth, parent.getComponent((int)(x + y * ncols)).getPreferredSize().width);
                }
                ++y;
            }
            result[x] = currWidth;
            ++x;
        }
        return result;
    }

    public Dimension minimumLayoutSize(Container parent) {
        return this.preferredLayoutSize(parent);
    }

    public void layoutContainer(Container parent) {
        Object object = parent.getTreeLock();
        synchronized (object) {
            Insets insets = parent.getInsets();
            int ncomponents = parent.getComponentCount();
            int nrows = this.rows;
            int ncols = this.cols;
            boolean ltr = parent.getComponentOrientation().isLeftToRight();
            if (ncomponents == 0) {
                return;
            }
            if (nrows > 0) {
                ncols = (ncomponents + nrows - 1) / nrows;
            } else {
                nrows = (ncomponents + ncols - 1) / ncols;
            }
            int[] colWidths = this.getColWidths(ncols, nrows, parent);
            int[] rowHeights = this.getRowHeights(ncols, nrows, parent);
            int w = parent.getWidth() - (insets.left + insets.right);
            int h = parent.getHeight() - (insets.top + insets.bottom);
            w = (w - (ncols - 1) * this.hgap) / ncols;
            h = (h - (nrows - 1) * this.vgap) / nrows;
            int xp = insets.left;
            int x = 0;
            while (x < ncols) {
                int yp = insets.top;
                int y = 0;
                while (y < nrows) {
                    int index = x + y * ncols;
                    if (index < ncomponents) {
                        parent.getComponent(index).setBounds(xp, yp, colWidths[x], rowHeights[y]);
                        yp += this.vgap + rowHeights[y];
                    }
                    ++y;
                }
                xp += this.hgap + colWidths[x];
                ++x;
            }
        }
    }

    public String toString() {
        return String.valueOf(this.getClass().getName()) + "[hgap=" + this.hgap + ",vgap=" + this.vgap + ",rows=" + this.rows + ",cols=" + this.cols + "]";
    }
}

