/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.sql;

import org.hibernate.AssertionFailure;
import org.hibernate.sql.JoinFragment;

public class ANSIJoinFragment
extends JoinFragment {
    private StringBuffer buffer = new StringBuffer();
    private StringBuffer conditions = new StringBuffer();

    public void addJoin(String tableName, String alias, String[] fkColumns, String[] pkColumns, int joinType) {
        this.addJoin(tableName, alias, fkColumns, pkColumns, joinType, null);
    }

    /*
     * WARNING - void declaration
     */
    public void addJoin(String tableName, String alias, String[] fkColumns, String[] pkColumns, int joinType, String on) {
        void var7_7;
        switch (joinType) {
            case 0: {
                String joinString = " inner join ";
                break;
            }
            case 1: {
                String joinString = " left outer join ";
                break;
            }
            case 2: {
                String joinString = " right outer join ";
                break;
            }
            case 4: {
                String joinString = " full outer join ";
                break;
            }
            default: {
                throw new AssertionFailure("undefined join type");
            }
        }
        this.buffer.append((String)var7_7).append(tableName).append(' ').append(alias).append(" on ");
        for (int j = 0; j < fkColumns.length; ++j) {
            this.buffer.append(fkColumns[j]).append('=').append(alias).append('.').append(pkColumns[j]);
            if (j >= fkColumns.length - 1) continue;
            this.buffer.append(" and ");
        }
        this.addCondition(this.buffer, on);
    }

    public String toFromFragmentString() {
        return this.buffer.toString();
    }

    public String toWhereFragmentString() {
        return this.conditions.toString();
    }

    public void addJoins(String fromFragment, String whereFragment) {
        this.buffer.append(fromFragment);
    }

    public JoinFragment copy() {
        ANSIJoinFragment copy = new ANSIJoinFragment();
        copy.buffer = new StringBuffer(this.buffer.toString());
        return copy;
    }

    public void addCondition(String alias, String[] columns, String condition) {
        for (int i = 0; i < columns.length; ++i) {
            this.conditions.append(" and ").append(alias).append('.').append(columns[i]).append(condition);
        }
    }

    public void addCrossJoin(String tableName, String alias) {
        this.buffer.append(", ").append(tableName).append(' ').append(alias);
    }

    public void addCondition(String alias, String[] fkColumns, String[] pkColumns) {
        throw new UnsupportedOperationException();
    }

    public boolean addCondition(String condition) {
        return this.addCondition(this.conditions, condition);
    }

    public void addFromFragmentString(String fromFragmentString) {
        this.buffer.append(fromFragmentString);
    }
}

