/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.transaction;

import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.HibernateException;
import org.hibernate.transaction.JDBCTransactionFactory;
import org.hibernate.transaction.TransactionFactory;
import org.hibernate.util.ReflectHelper;

public final class TransactionFactoryFactory {
    private static final Log log = LogFactory.getLog((Class)TransactionFactoryFactory.class);

    public static TransactionFactory buildTransactionFactory(Properties transactionProps) throws HibernateException {
        TransactionFactory factory;
        String strategyClassName = transactionProps.getProperty("hibernate.transaction.factory_class");
        if (strategyClassName == null) {
            log.info((Object)"Using default transaction strategy (direct JDBC transactions)");
            return new JDBCTransactionFactory();
        }
        log.info((Object)("Transaction strategy: " + strategyClassName));
        try {
            factory = (TransactionFactory)ReflectHelper.classForName(strategyClassName).newInstance();
        }
        catch (ClassNotFoundException e) {
            log.error((Object)"TransactionFactory class not found", (Throwable)e);
            throw new HibernateException("TransactionFactory class not found: " + strategyClassName);
        }
        catch (IllegalAccessException e) {
            log.error((Object)"Failed to instantiate TransactionFactory", (Throwable)e);
            throw new HibernateException("Failed to instantiate TransactionFactory: " + e);
        }
        catch (InstantiationException e) {
            log.error((Object)"Failed to instantiate TransactionFactory", (Throwable)e);
            throw new HibernateException("Failed to instantiate TransactionFactory: " + e);
        }
        factory.configure(transactionProps);
        return factory;
    }

    private TransactionFactoryFactory() {
    }
}

