/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.napkinlaf.util;

import java.awt.Color;
import javax.swing.AbstractButton;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.border.Border;
import net.sourceforge.napkinlaf.borders.NapkinBorder;
import net.sourceforge.napkinlaf.sketch.SketchifiedIcon;
import net.sourceforge.napkinlaf.util.AlphaColorUIResource;
import net.sourceforge.napkinlaf.util.NapkinConstants;
import net.sourceforge.napkinlaf.util.NapkinIcon;
import net.sourceforge.napkinlaf.util.NapkinUtil;
import net.sourceforge.napkinlaf.util.SmartStickyListener;

class NapkinSmartListeners {
    private NapkinSmartListeners() {
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class DisabledSelectedIconListener
    extends SmartStickyListener<Icon> {
        public DisabledSelectedIconListener() {
            super("net.sourceforge.napkinlaf.disabledSelectedIcon", "disabledSelectedIcon");
        }

        @Override
        protected void overrideValue(JComponent c, Icon newValue) {
            if (newValue != null && !(newValue instanceof NapkinIcon)) {
                ((AbstractButton)c).setDisabledSelectedIcon(new SketchifiedIcon(c, newValue));
            }
        }

        @Override
        protected boolean shouldRecord(Icon newValue) {
            return newValue != null && !(newValue instanceof SketchifiedIcon);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class DisabledIconListener
    extends SmartStickyListener<Icon> {
        public DisabledIconListener() {
            super("net.sourceforge.napkinlaf.disabledIcon", "disabledIcon");
        }

        @Override
        protected void overrideValue(JComponent c, Icon newValue) {
            if (newValue != null && !(newValue instanceof NapkinIcon)) {
                ((AbstractButton)c).setDisabledIcon(new SketchifiedIcon(c, newValue));
            }
        }

        @Override
        protected boolean shouldRecord(Icon newValue) {
            return newValue != null && !(newValue instanceof SketchifiedIcon);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class RolloverSelectedIconListener
    extends SmartStickyListener<Icon> {
        public RolloverSelectedIconListener() {
            super("net.sourceforge.napkinlaf.rolloverSelectedIcon", "rolloverSelectedIcon");
        }

        @Override
        protected void overrideValue(JComponent c, Icon newValue) {
            if (newValue != null && !(newValue instanceof NapkinIcon)) {
                ((AbstractButton)c).setRolloverSelectedIcon(new SketchifiedIcon(c, newValue));
            }
        }

        @Override
        protected boolean shouldRecord(Icon newValue) {
            return newValue != null && !(newValue instanceof SketchifiedIcon);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class RolloverIconListener
    extends SmartStickyListener<Icon> {
        public RolloverIconListener() {
            super("net.sourceforge.napkinlaf.rolloverIcon", "rolloverIcon");
        }

        @Override
        protected void overrideValue(JComponent c, Icon newValue) {
            if (newValue != null && !(newValue instanceof NapkinIcon)) {
                ((AbstractButton)c).setRolloverIcon(new SketchifiedIcon(c, newValue));
            }
        }

        @Override
        protected boolean shouldRecord(Icon newValue) {
            return newValue != null && !(newValue instanceof SketchifiedIcon);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class SelectedIconListener
    extends SmartStickyListener<Icon> {
        public SelectedIconListener() {
            super("net.sourceforge.napkinlaf.selectedIcon", "selectedIcon");
        }

        @Override
        protected void overrideValue(JComponent c, Icon newValue) {
            if (newValue != null && !(newValue instanceof NapkinIcon)) {
                ((AbstractButton)c).setSelectedIcon(new SketchifiedIcon(c, newValue));
            }
        }

        @Override
        protected boolean shouldRecord(Icon newValue) {
            return newValue != null && !(newValue instanceof SketchifiedIcon);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class PressedIconListener
    extends SmartStickyListener<Icon> {
        public PressedIconListener() {
            super("net.sourceforge.napkinlaf.pressedIcon", "pressedIcon");
        }

        @Override
        protected void overrideValue(JComponent c, Icon newValue) {
            if (newValue != null && !(newValue instanceof NapkinIcon)) {
                ((AbstractButton)c).setPressedIcon(new SketchifiedIcon(c, newValue));
            }
        }

        @Override
        protected boolean shouldRecord(Icon newValue) {
            return newValue != null && !(newValue instanceof SketchifiedIcon);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ButtonIconListener
    extends SmartStickyListener<Icon> {
        public ButtonIconListener() {
            super("net.sourceforge.napkinlaf.buttonIcon", "icon");
        }

        @Override
        protected void overrideValue(JComponent c, Icon newValue) {
            if (newValue != null && !(newValue instanceof NapkinIcon)) {
                ((AbstractButton)c).setIcon(new SketchifiedIcon(c, newValue));
            }
        }

        @Override
        protected boolean shouldRecord(Icon newValue) {
            return newValue != null && !(newValue instanceof SketchifiedIcon);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class RolloverListener
    extends SmartStickyListener<Boolean> {
        public RolloverListener() {
            super("net.sourceforge.napkinlaf.wasRolloverEnabled", "rolloverEnabled");
        }

        @Override
        protected void overrideValue(JComponent c, Boolean newValue) {
            if (!Boolean.TRUE.equals(newValue)) {
                ((AbstractButton)c).setRolloverEnabled(true);
            }
        }

        @Override
        protected boolean shouldRecord(Boolean newValue) {
            return true;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class BorderListener
    extends SmartStickyListener<Border> {
        public BorderListener() {
            super("net.sourceforge.napkinlaf.border", "border");
        }

        @Override
        protected void overrideValue(JComponent c, Border newValue) {
            Border newBorder;
            if (this.shouldRecord(newValue) && (newBorder = NapkinUtil.wrapBorder(newValue)) != newValue) {
                c.setBorder(newBorder);
            }
        }

        @Override
        protected boolean shouldRecord(Border newValue) {
            return newValue != null && !(newValue instanceof NapkinBorder);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class BackgroundListener
    extends SmartStickyListener<Color> {
        public BackgroundListener() {
            super("net.sourceforge.napkinlaf.background", "background");
        }

        @Override
        protected void overrideValue(JComponent c, Color newValue) {
            if (NapkinUtil.replaceBackground(newValue)) {
                c.setBackground(NapkinConstants.CLEAR);
            }
        }

        @Override
        protected boolean shouldRecord(Color newValue) {
            return !(newValue instanceof AlphaColorUIResource);
        }
    }
}

