/*
 * Decompiled with CFR 0.152.
 */
package org.fife.rtext;

import java.awt.Font;
import java.awt.Graphics;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.print.PageFormat;
import java.io.IOException;
import javax.swing.JComponent;
import org.fife.print.RPrintUtilities;
import org.fife.rtext.MainPanelTransferHandler;
import org.fife.rtext.RText;
import org.fife.ui.rsyntaxtextarea.FileLocation;
import org.fife.ui.rsyntaxtextarea.TextEditorPane;
import org.fife.ui.rtextarea.RTATextTransferHandler;

public class RTextEditorPane
extends TextEditorPane {
    private RText rtext;

    public RTextEditorPane(RText rtext, boolean wordWrapEnabled, int textMode, FileLocation loc, String encoding) throws IOException {
        super(textMode, wordWrapEnabled, loc, encoding);
        this.rtext = rtext;
        this.setTransferHandler(new RTextEditorPaneTransferHandler());
    }

    public int print(Graphics g, PageFormat pageFormat, int pageIndex) {
        Font printWithMeFont = this.rtext.getMainView().getPrintFont();
        if (printWithMeFont == null) {
            printWithMeFont = this.getFont();
        }
        return RPrintUtilities.printDocumentWordWrap(g, this, printWithMeFont, pageIndex, pageFormat, this.getTabSize());
    }

    class RTextEditorPaneTransferHandler
    extends RTATextTransferHandler {
        RTextEditorPaneTransferHandler() {
        }

        public boolean canImport(JComponent c, DataFlavor[] flavors) {
            return MainPanelTransferHandler.hasFileFlavor(flavors) || super.canImport(c, flavors);
        }

        public boolean importData(JComponent c, Transferable t) {
            return MainPanelTransferHandler.importDataImpl(RTextEditorPane.this.rtext.getMainView(), c, t) || super.importData(c, t);
        }
    }
}

