/*
 * Decompiled with CFR 0.152.
 */
package org.fife.rtext.optionsdialog;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Font;
import java.awt.Frame;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ResourceBundle;
import javax.swing.Box;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.border.Border;
import org.fife.rtext.AbstractMainView;
import org.fife.rtext.RText;
import org.fife.ui.FontSelector;
import org.fife.ui.OptionsDialogPanel;
import org.fife.ui.UIUtil;

class PrintingOptionPanel
extends OptionsDialogPanel
implements PropertyChangeListener {
    private FontSelector fontSelector;
    private JCheckBox headerCheckBox;
    private JCheckBox footerCheckBox;
    private static final String FONT_PROPERTY = "PrintingOptionPanel.font";

    public PrintingOptionPanel(RText rtext, ResourceBundle msg) {
        super(msg.getString("OptPrName"));
        ComponentOrientation orientation = ComponentOrientation.getOrientation(this.getLocale());
        this.setLayout(new BorderLayout());
        this.setBorder(UIUtil.getEmpty5Border());
        Box printFontPanel = new Box(2);
        printFontPanel.setBorder((Border)new OptionsDialogPanel.OptionPanelBorder(msg.getString("OptPrFTitle")));
        printFontPanel.setAlignmentX(0.0f);
        this.fontSelector = new FontSelector();
        this.fontSelector.addPropertyChangeListener("font", (PropertyChangeListener)this);
        printFontPanel.add((Component)this.fontSelector);
        printFontPanel.add(Box.createHorizontalGlue());
        Box temp = Box.createVerticalBox();
        this.headerCheckBox = new JCheckBox(msg.getString("OptPrPH"));
        this.footerCheckBox = new JCheckBox(msg.getString("OptPrPF"));
        this.headerCheckBox.setEnabled(false);
        this.footerCheckBox.setEnabled(false);
        temp.add(this.headerCheckBox);
        temp.add(this.footerCheckBox);
        Box printHeaderFooterPanel = this.createHorizontalBox();
        printHeaderFooterPanel.setAlignmentX(0.0f);
        printHeaderFooterPanel.setBorder((Border)new OptionsDialogPanel.OptionPanelBorder(msg.getString("OptPrHFL")));
        printHeaderFooterPanel.add(temp);
        printHeaderFooterPanel.add(Box.createHorizontalGlue());
        temp = Box.createVerticalBox();
        temp.add(printFontPanel);
        temp.add(printHeaderFooterPanel);
        this.add(temp, "North");
        this.applyComponentOrientation(orientation);
    }

    protected void doApplyImpl(Frame owner) {
        RText rtext = (RText)((Object)owner);
        AbstractMainView mainView = rtext.getMainView();
        mainView.setPrintFont(this.getPrintFont());
    }

    public void propertyChange(PropertyChangeEvent e) {
        String propertyName = e.getPropertyName();
        if (propertyName.equals("font")) {
            this.hasUnsavedChanges = true;
            Font font = this.fontSelector.getDisplayedFont();
            this.firePropertyChange(FONT_PROPERTY, null, font);
        }
    }

    protected OptionsDialogPanel.OptionsPanelCheckResult ensureValidInputsImpl() {
        return null;
    }

    public Font getPrintFont() {
        return this.fontSelector.getDisplayedFont();
    }

    public JComponent getTopJComponent() {
        return this.fontSelector;
    }

    private void setPrintFont(Font printFont) {
        if (printFont == null) {
            printFont = new Font("Monospaced", 0, 9);
        }
        this.fontSelector.setDisplayedFont(printFont, false);
    }

    protected void setValuesImpl(Frame owner) {
        RText rtext = (RText)((Object)owner);
        AbstractMainView mainView = rtext.getMainView();
        this.setPrintFont(mainView.getPrintFont());
    }
}

