#!/bin/bash
#
# This file is a part of the CM-LGC font package
# version 0.5 (May 07, 2005)
#
# Copyright (c) 2003--2005 Alexej Kryukov <basileia@yandex.ru>.
# 
# This package is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
# 
# As a special exception, permission is granted to include these font
# programs in a Postscript or PDF file that consists of a document that
# contains text to be displayed or printed using these fonts, regardless
# of the conditions or license applying to the document itself.
#
# This package is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

function getplbyfont () {
	FONT_NAME=$1
	mktextfm $FONT_NAME > /dev/null
	tftopl $FONT_NAME.tfm $FONT_NAME.pl > /dev/null
}

CUR_DIR=$PWD
PACK_NAME=cm-lgc-raw

cd $CUR_DIR/tex
FONT_SIZE="10"

# CM Roman
getplbyfont cmr$FONT_SIZE
getplbyfont cmti$FONT_SIZE
getplbyfont cmbx$FONT_SIZE
getplbyfont cmbxti$FONT_SIZE
getplbyfont cmcsc$FONT_SIZE
getplbyfont cmbcsc$FONT_SIZE

# CM Sans
getplbyfont cmss$FONT_SIZE
getplbyfont cmssi$FONT_SIZE
getplbyfont cmssbx$FONT_SIZE
getplbyfont cmssbxo$FONT_SIZE

# CM Typewriter
getplbyfont cmtt$FONT_SIZE
getplbyfont cmitt$FONT_SIZE
getplbyfont cmtcsc$FONT_SIZE

# IBYCUS
#getplbyfont fibr84
#getplbyfont fibb84

FONT_SIZE="1000"

# EC Roman
getplbyfont ecrm$FONT_SIZE
getplbyfont ecbx$FONT_SIZE
getplbyfont ecti$FONT_SIZE
getplbyfont ecbi$FONT_SIZE
getplbyfont eccc$FONT_SIZE
getplbyfont ecxc$FONT_SIZE

getplbyfont tcrm$FONT_SIZE
getplbyfont tcbx$FONT_SIZE
getplbyfont tcti$FONT_SIZE
getplbyfont tcbi$FONT_SIZE

# LH Roman
getplbyfont rxrm$FONT_SIZE
getplbyfont rxbx$FONT_SIZE
getplbyfont rxti$FONT_SIZE
getplbyfont rxbi$FONT_SIZE
getplbyfont rxcc$FONT_SIZE
getplbyfont rxxc$FONT_SIZE

# CB Roman
getplbyfont grmn$FONT_SIZE
getplbyfont grxn$FONT_SIZE
getplbyfont grml$FONT_SIZE
getplbyfont grxl$FONT_SIZE
getplbyfont grmc$FONT_SIZE
getplbyfont grxc$FONT_SIZE

# EC Sans
getplbyfont ecss$FONT_SIZE
getplbyfont ecsi$FONT_SIZE
getplbyfont ecsx$FONT_SIZE
getplbyfont ecso$FONT_SIZE

getplbyfont tcss$FONT_SIZE
getplbyfont tcsi$FONT_SIZE
getplbyfont tcsx$FONT_SIZE
getplbyfont tcso$FONT_SIZE

# LH Sans
getplbyfont rxss$FONT_SIZE
getplbyfont rxsi$FONT_SIZE
getplbyfont rxsx$FONT_SIZE
getplbyfont rxso$FONT_SIZE

# CB Sans
getplbyfont gsmn$FONT_SIZE
getplbyfont gsmo$FONT_SIZE
getplbyfont gsxn$FONT_SIZE
getplbyfont gsxo$FONT_SIZE

# EC Typewriter
getplbyfont ectt$FONT_SIZE
getplbyfont ecit$FONT_SIZE
getplbyfont ectc$FONT_SIZE

getplbyfont tctt$FONT_SIZE
getplbyfont tcit$FONT_SIZE

# LH Typewriter
getplbyfont rxtt$FONT_SIZE
getplbyfont rxit$FONT_SIZE
getplbyfont rxtc$FONT_SIZE

# CB Typewriter
getplbyfont gttn$FONT_SIZE
getplbyfont gtti$FONT_SIZE
getplbyfont gttc$FONT_SIZE

latex $PACK_NAME.tex

for i in *.vpl ; do
  vptovf $i ${i%.vpl}.vf ${i%.vpl}.tfm
  echo "processing $i"
done

if !([ -d $HOME/texmf ]); then
    mkdir $HOME/texmf
fi

if !([ -d $HOME/texmf/fonts ]); then
    mkdir $HOME/texmf/fonts
fi

for dir in 'tfm' 'vf'; do
    if !([ -d $HOME/texmf/fonts/$dir ]); then
        mkdir $HOME/texmf/fonts/$dir
    fi
    
    if !([ -d $HOME/texmf/fonts/$dir/public ]); then
        mkdir $HOME/texmf/fonts/$dir/public
    fi
    
    if !([ -d $HOME/texmf/fonts/$dir/public/$PACK_NAME ]); then
        mkdir $HOME/texmf/fonts/$dir/public/$PACK_NAME
    fi
done

mv -f *.vf $HOME/texmf/fonts/vf/public/$PACK_NAME
mv -f *.tfm $HOME/texmf/fonts/tfm/public/$PACK_NAME

texhash $HOME/texmf

rm -f *.vpl
rm -f *.pl
rm -f *lat.mtx *ceu.mtx *cyr.mtx *asi.mtx *grk.mtx *10.mtx *1000.mtx
rm -f *.fd
