/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.heapviewer.utils;

import java.util.Iterator;
import org.graalvm.visualvm.heapviewer.model.Progress;

public final class ProgressIterator<T>
implements Iterator<T> {
    private final Iterator<T> iterator;
    private final Progress progress;

    public ProgressIterator(Iterator<T> iterator, Progress progress) {
        this(iterator, 0, false, progress);
    }

    public ProgressIterator(Iterator<T> iterator, int index, boolean needsForward, Progress progress) {
        this.iterator = iterator;
        this.progress = progress;
        if (index > 0) {
            if (needsForward) {
                this.forward(index);
            } else {
                progress.steps(index);
            }
        }
    }

    @Override
    public boolean hasNext() {
        return this.iterator.hasNext();
    }

    @Override
    public T next() {
        this.progress.step();
        return this.iterator.next();
    }

    private void forward(int steps) {
        while (steps-- > 0) {
            if (!this.hasNext()) continue;
            this.next();
        }
    }
}

