/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.options.advanced;

import java.awt.BorderLayout;
import java.awt.Component;
import java.beans.PropertyChangeListener;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.modules.options.OptionsPanelControllerAccessor;
import org.netbeans.modules.options.advanced.Model;
import org.netbeans.spi.options.OptionsPanelController;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;
import org.openide.util.NbBundle;

public final class AdvancedPanel
extends JPanel {
    JTabbedPane tabbedPanel;
    private static final Logger LOGGER = Logger.getLogger(AdvancedPanel.class.getName());
    private LookupListener listener = new LookupListenerImpl();
    private Model model;
    private String subpath;
    private ChangeListener changeListener = new ChangeListener(){

        @Override
        public void stateChanged(ChangeEvent changeEvent) {
            AdvancedPanel.this.handleTabSwitched(null, null);
        }
    };

    AdvancedPanel(String string) {
        this.subpath = string;
        this.model = new Model(string, this.listener);
    }

    public void update() {
        int n = this.tabbedPanel.getSelectedIndex();
        if (n != -1) {
            String string = this.tabbedPanel.getTitleAt(n);
            this.model.update(string);
        }
    }

    public void applyChanges() {
        this.model.applyChanges();
    }

    public void cancel() {
        this.model.cancel();
    }

    public HelpCtx getHelpCtx() {
        return this.model.getHelpCtx(this.tabbedPanel != null ? (JComponent)this.tabbedPanel.getSelectedComponent() : null);
    }

    public boolean dataValid() {
        return this.model.isValid();
    }

    public boolean isChanged() {
        return this.model.isChanged();
    }

    public void addModelPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.model.addPropertyChangeListener(propertyChangeListener);
    }

    public void removeModelPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.model.removePropertyChangeListener(propertyChangeListener);
    }

    public Lookup getLookup() {
        return this.model.getLookup();
    }

    void init() {
        this.tabbedPanel = new JTabbedPane();
        this.tabbedPanel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(AdvancedPanel.class, (String)"AdvancedPanel.tabbedPanel.AD"));
        this.setLayout(new BorderLayout());
        this.removeAll();
        this.add((Component)this.tabbedPanel, "Center");
        this.initTabbedPane();
    }

    private void initTabbedPane() {
        this.tabbedPanel.removeChangeListener(this.changeListener);
        this.tabbedPanel.removeAll();
        List<String> list = this.model.getCategories();
        this.tabbedPanel.setVisible(list.size() > 0);
        for (String string : list) {
            this.tabbedPanel.addTab(string, new JLabel(string));
        }
        this.tabbedPanel.addChangeListener(this.changeListener);
        this.handleTabSwitched(null, null);
    }

    public void setCurrentSubcategory(String string) {
        String string2;
        String string3 = string.indexOf(47) == -1 ? string : string.substring(0, string.indexOf(47));
        String string4 = string.indexOf(47) == -1 ? null : string.substring(string.indexOf(47) + 1);
        LOGGER.fine("Set current subcategory: " + string);
        if (!this.model.getIDs().contains(string3)) {
            LOGGER.warning("Subcategory " + string3 + " not found.");
            return;
        }
        String string5 = this.model.getDisplayName(string3);
        if (!string5.equals(string2 = this.getSelectedDisplayName())) {
            for (int i = 0; i < this.tabbedPanel.getComponentCount(); ++i) {
                if (!this.tabbedPanel.getTitleAt(i).equals(string5)) continue;
                this.tabbedPanel.setSelectedIndex(i);
                break;
            }
        }
        if (string4 != null) {
            OptionsPanelControllerAccessor.getDefault().setCurrentSubcategory(this.model.getController(string3), string4);
        }
    }

    private String getSelectedDisplayName() {
        String string = null;
        int n = this.tabbedPanel.getSelectedIndex();
        if (n != -1) {
            string = this.tabbedPanel.getTitleAt(n);
        }
        return string;
    }

    private void handleTabSwitched(String string, List<String> list) {
        int n;
        int n2 = n = this.tabbedPanel.getSelectedIndex() >= 0 ? this.tabbedPanel.getSelectedIndex() : -1;
        if (n != -1) {
            Object object;
            String string2 = this.tabbedPanel.getTitleAt(n);
            if (this.tabbedPanel.getSelectedComponent() instanceof JLabel) {
                object = this.model.getPanel(string2);
                if (null == ((JComponent)object).getBorder()) {
                    ((JComponent)object).setBorder(BorderFactory.createEmptyBorder(11, 11, 11, 11));
                }
                JScrollPane jScrollPane = new JScrollPane((Component)object);
                jScrollPane.setOpaque(false);
                jScrollPane.getViewport().setOpaque(false);
                jScrollPane.setBorder(BorderFactory.createEmptyBorder());
                jScrollPane.getVerticalScrollBar().setUnitIncrement(16);
                jScrollPane.getHorizontalScrollBar().setUnitIncrement(16);
                this.tabbedPanel.setComponentAt(this.tabbedPanel.getSelectedIndex(), jScrollPane);
            }
            this.model.update(string2);
            if (string != null && list != null) {
                object = this.model.getController(this.model.getID(string2));
                if (object == null) {
                    LOGGER.log(Level.WARNING, "No controller found for category: {0}", string2);
                } else {
                    ((OptionsPanelController)object).handleSuccessfulSearch(string, list);
                }
            }
            this.firePropertyChange("helpCtx", null, null);
        }
    }

    void handleSearch(String string, List<String> list) {
        this.handleTabSwitched(string, list);
    }

    private class LookupListenerImpl
    implements LookupListener {
        private LookupListenerImpl() {
        }

        public void resultChanged(LookupEvent lookupEvent) {
            AdvancedPanel.this.model = new Model(AdvancedPanel.this.subpath, AdvancedPanel.this.listener);
            if (SwingUtilities.isEventDispatchThread()) {
                AdvancedPanel.this.initTabbedPane();
            } else {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        AdvancedPanel.this.initTabbedPane();
                    }
                });
            }
        }
    }
}

