/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.jfr.model.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.graalvm.visualvm.tools.attach.AttachModel;
import org.graalvm.visualvm.tools.jfr.JfrModel;
import org.graalvm.visualvm.tools.jmx.JmxModel;

public class JfrModelImpl
extends JfrModel {
    private static final int ATTACH_CMD = 0;
    private static final int JMX_CMD = 1;
    private static final String[] JCMD_JFR_DUMP = new String[]{"JFR.dump", "jfrDump"};
    private static final String JCMD_JFR_DUMP_FILENAME = "filename";
    private static final String JCMD_JFR_DUMP_RECORDING = "recording";
    private static final String JCMD_JFR_DUMP_NAME = "name";
    private static final String[] JCMD_JFR_CHECK = new String[]{"JFR.check", "jfrCheck"};
    private static final String JCMD_JFR_CHECK_RECORDING_ID = "recording=";
    private static final String JCMD_JFR_CHECK_RECORDING_ID1 = "Recording ";
    private static final String JCMD_JFR_CHECK_HELP_OPTIONS_ID = "Options: ";
    private static final String JCMD_JFR_CHECK_HELP_RECORDING_ID = "recording : ";
    private static final String[] JCMD_JFR_START = new String[]{"JFR.start", "jfrStart"};
    private static final String JCMD_JFR_START_NAME = "name";
    private static final String JCMD_JFR_START_SETTINGS = "settings";
    private static final String JCMD_JFR_START_DELAY = "delay";
    private static final String JCMD_JFR_START_DURATION = "duration";
    private static final String JCMD_JFR_START_DISK = "disk";
    private static final String JCMD_JFR_START_FILENAME = "filename";
    private static final String JCMD_JFR_START_MAXAGE = "maxage";
    private static final String JCMD_JFR_START_MAXSIZE = "maxsize";
    private static final String JCMD_JFR_START_DUMPONEXIT = "dumponexit";
    private static final String[] JCMD_JFR_STOP = new String[]{"JFR.stop", "jfrStop"};
    private static final String JCMD_JFR_STOP_NAME = "name";
    private static final String JCMD_JFR_UNLOCK_ID = "Use VM.unlock_commercial_features to enable";
    private static final String[] JCMD_UNLOCK_CF = new String[]{"VM.unlock_commercial_features", "vmUnlockCommercialFeatures"};
    private static final String[] JCMD_HELP = new String[]{"help", "help"};
    private static final String JCMD_CF_ID = " unlocked.";
    private static final String JCMD_JFR_UNKNOWN_COMMAND = "Unknown diagnostic command";
    private static final Map<String, Object> EMPTY_PARS = Collections.singletonMap("", null);
    private boolean oldJFR;
    private AttachModel attach;
    private JmxModel jmx;

    JfrModelImpl(AttachModel attachModel) {
        this.attach = attachModel;
    }

    JfrModelImpl(JmxModel jmxModel) {
        this.jmx = jmxModel;
    }

    boolean isJfrAvailable() {
        String recordings = this.executeJCmd(JCMD_JFR_CHECK, EMPTY_PARS);
        if (recordings == null) {
            return false;
        }
        boolean jfrAvailable = recordings.contains(JCMD_JFR_UNLOCK_ID) ? this.unlockCommercialFeature() : !recordings.contains(JCMD_JFR_UNKNOWN_COMMAND);
        if (jfrAvailable) {
            this.oldJFR = this.checkForOldJFR();
        }
        return jfrAvailable;
    }

    public List<Long> jfrCheck() {
        String recordings = this.executeJCmd(JCMD_JFR_CHECK, EMPTY_PARS);
        if (recordings == null) {
            return Collections.emptyList();
        }
        String[] lines = recordings.split("\\r?\\n");
        ArrayList<Long> recNumbers = new ArrayList<Long>(lines.length);
        for (String line : lines) {
            String recordingNum;
            int recEnd;
            int recStart;
            int index = line.indexOf(JCMD_JFR_CHECK_RECORDING_ID);
            if (index >= 0) {
                recStart = index + JCMD_JFR_CHECK_RECORDING_ID.length();
                recEnd = line.indexOf(32, recStart);
                if (recEnd <= recStart) continue;
                recordingNum = line.substring(recStart, recEnd);
                recNumbers.add(Long.valueOf(recordingNum));
                continue;
            }
            if (!line.startsWith(JCMD_JFR_CHECK_RECORDING_ID1) || (recEnd = line.indexOf(58, recStart = JCMD_JFR_CHECK_RECORDING_ID1.length())) <= recStart) continue;
            recordingNum = line.substring(recStart, recEnd);
            recNumbers.add(Long.valueOf(recordingNum));
        }
        return recNumbers;
    }

    public String takeJfrDump(long recording, String fileName) {
        HashMap<String, Object> pars = new HashMap<String, Object>();
        pars.put("filename", fileName);
        pars.put(this.oldJFR ? JCMD_JFR_DUMP_RECORDING : "name", recording);
        return this.executeJCmd(JCMD_JFR_DUMP, pars);
    }

    public boolean startJfrRecording(String name, String[] settings, String delay, String duration, Boolean disk, String path, String maxAge, String maxSize, Boolean dumpOnExit) {
        HashMap<String, Object> pars = new HashMap<String, Object>();
        if (name != null) {
            pars.put("name", name);
        }
        if (settings != null) {
            for (String setting : settings) {
                pars.put(JCMD_JFR_START_SETTINGS, setting);
            }
        }
        if (delay != null) {
            pars.put(JCMD_JFR_START_DELAY, delay);
        }
        if (duration != null) {
            pars.put(JCMD_JFR_START_DURATION, duration);
        }
        if (maxAge != null) {
            pars.put(JCMD_JFR_START_MAXAGE, maxAge);
        }
        if (maxSize != null) {
            pars.put(JCMD_JFR_START_MAXSIZE, maxSize);
        }
        if (dumpOnExit != null) {
            pars.put(JCMD_JFR_START_DUMPONEXIT, dumpOnExit);
        }
        if (path != null) {
            pars.put("filename", path);
        }
        if (disk != null && !this.oldJFR) {
            pars.put(JCMD_JFR_START_DISK, disk);
        }
        if (pars.isEmpty()) {
            pars = EMPTY_PARS;
        }
        this.executeJCmd(JCMD_JFR_START, pars);
        return true;
    }

    public boolean stopJfrRecording() {
        String recKey = this.oldJFR ? JCMD_JFR_DUMP_RECORDING : "name";
        for (Long recording : this.jfrCheck()) {
            Map<String, Object> pars = Collections.singletonMap(recKey, recording);
            this.executeJCmd(JCMD_JFR_STOP, pars);
        }
        return true;
    }

    private boolean checkForOldJFR() {
        String ret = this.getJCmdHelp(JCMD_JFR_CHECK);
        if (ret != null) {
            int options = ret.indexOf(JCMD_JFR_CHECK_HELP_OPTIONS_ID);
            int recording = ret.indexOf(JCMD_JFR_CHECK_HELP_RECORDING_ID);
            return options != -1 && options < recording;
        }
        return false;
    }

    private boolean unlockCommercialFeature() {
        String ret = this.executeJCmd(JCMD_UNLOCK_CF);
        return ret.contains(JCMD_CF_ID);
    }

    private String getJCmdHelp(String[] command) {
        return this.executeJCmd(JCMD_HELP, Collections.singletonMap(command[0], null));
    }

    private String executeJCmd(String[] command, Map<String, Object> pars) {
        if (this.attach != null) {
            return this.attach.executeJCmd(command[0], pars);
        }
        return this.jmx.executeJCmd(command[1], pars);
    }

    private String executeJCmd(String[] string) {
        return this.executeJCmd(string, Collections.emptyMap());
    }
}

