/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.startup;

import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.netbeans.Stamps;
import org.netbeans.Util;
import org.netbeans.core.startup.preferences.RelPaths;
import org.openide.filesystems.FileUtil;
import org.openide.modules.InstalledFileLocator;

public final class InstalledFileLocatorImpl
extends InstalledFileLocator {
    private static final Logger LOG = Logger.getLogger(InstalledFileLocatorImpl.class.getName());
    private final File[] dirs;
    private static Map<String, Map<File, Set<String>>> fileCache = null;
    private static Map<String, List<File>> clusterCache = null;
    private static boolean cacheMiss;
    private static final Pattern FILE_PATTERN;
    private static final Map<File, Map<String, Set<String>>> ownershipByModuleByCluster;

    public InstalledFileLocatorImpl() {
        List<File> list = InstalledFileLocatorImpl.computeDirs();
        this.dirs = list.toArray(new File[0]);
    }

    private static void addDir(List<File> list, String string) {
        File file;
        if (string != null && (file = new File(string).getAbsoluteFile()).isDirectory()) {
            list.add(FileUtil.normalizeFile((File)file));
        }
    }

    public static synchronized void prepareCache() {
        assert (fileCache == null);
        fileCache = new HashMap<String, Map<File, Set<String>>>();
        clusterCache = new HashMap<String, List<File>>();
        try {
            int n;
            Object object;
            int n2;
            InputStream inputStream = Stamps.getModulesJARs().asStream("all-files.dat");
            if (inputStream == null) {
                return;
            }
            DataInputStream dataInputStream = new DataInputStream(inputStream);
            int n3 = dataInputStream.readInt();
            for (n2 = 0; n2 < n3; ++n2) {
                String string = dataInputStream.readUTF();
                object = new HashMap();
                n = dataInputStream.readInt();
                for (int i = 0; i < n; ++i) {
                    String string2 = RelPaths.readRelativePath(dataInputStream);
                    File file = new File(string2);
                    int n4 = dataInputStream.readInt();
                    ArrayList<String> arrayList = new ArrayList<String>(n4);
                    for (int j = 0; j < n4; ++j) {
                        arrayList.add(dataInputStream.readUTF());
                    }
                    object.put(file, new HashSet(arrayList));
                }
                fileCache.put(string, (Map<File, Set<String>>)object);
            }
            n2 = dataInputStream.readInt();
            for (int i = 0; i < n2; ++i) {
                object = dataInputStream.readUTF();
                n = dataInputStream.readInt();
                ArrayList<File> arrayList = new ArrayList<File>(n);
                for (int j = 0; j < n; ++j) {
                    arrayList.add(new File(RelPaths.readRelativePath(dataInputStream)));
                }
                clusterCache.put((String)object, arrayList);
            }
        }
        catch (IOException iOException) {
            LOG.log(Level.INFO, null, iOException);
            fileCache.clear();
            clusterCache.clear();
        }
    }

    private static synchronized void persistCache(DataOutputStream dataOutputStream, Map<String, Map<File, Set<String>>> map, Map<String, List<File>> map2) throws IOException {
        dataOutputStream.writeInt(map.size());
        for (Map.Entry<String, Map<File, Set<String>>> entry : map.entrySet()) {
            dataOutputStream.writeUTF(entry.getKey());
            Map<File, Set<String>> map3 = entry.getValue();
            dataOutputStream.writeInt(map3.size());
            for (Map.Entry<File, Set<String>> entry2 : map3.entrySet()) {
                String[] stringArray = RelPaths.findRelativePath(entry2.getKey().getPath());
                assert (stringArray != null) : "No relative for " + entry2.getKey();
                dataOutputStream.writeUTF(stringArray[0]);
                dataOutputStream.writeUTF(stringArray[1]);
                dataOutputStream.writeInt(entry2.getValue().size());
                for (String string : entry2.getValue()) {
                    dataOutputStream.writeUTF(string);
                }
            }
        }
        dataOutputStream.writeInt(map2.size());
        for (Map.Entry<String, Object> entry : map2.entrySet()) {
            dataOutputStream.writeUTF(entry.getKey());
            dataOutputStream.writeInt(((List)entry.getValue()).size());
            for (Object object : (List)entry.getValue()) {
                String[] stringArray = RelPaths.findRelativePath(((File)object).getPath());
                dataOutputStream.writeUTF(stringArray[0]);
                dataOutputStream.writeUTF(stringArray[1]);
            }
        }
    }

    public static synchronized void discardCache() {
        assert (fileCache != null);
        if (cacheMiss) {
            final Map<String, Map<File, Set<String>>> map = fileCache;
            final Map<String, List<File>> map2 = clusterCache;
            Stamps.getModulesJARs().scheduleSave(new Stamps.Updater(){

                public void flushCaches(DataOutputStream dataOutputStream) throws IOException {
                    InstalledFileLocatorImpl.persistCache(dataOutputStream, map, map2);
                }

                public void cacheReady() {
                }
            }, "all-files.dat", false);
        }
        fileCache = null;
        clusterCache = null;
    }

    public File locate(String string, String string2, boolean bl) {
        Set<File> set = this.doLocate(string, bl, true, string2);
        return set.isEmpty() ? null : set.iterator().next();
    }

    public Set<File> locateAll(String string, String string2, boolean bl) {
        return this.doLocate(string, bl, false, string2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Set<File> doLocate(String string, boolean bl, boolean bl2, String string2) {
        String[] stringArray = InstalledFileLocatorImpl.prefixAndName(string);
        String string3 = stringArray[0];
        String string4 = stringArray[1];
        Class<InstalledFileLocatorImpl> clazz = InstalledFileLocatorImpl.class;
        synchronized (InstalledFileLocatorImpl.class) {
            if (bl) {
                String string5;
                String string6;
                int n = string4.lastIndexOf(46);
                if (n == -1) {
                    string6 = string4;
                    string5 = "";
                } else {
                    string6 = string4.substring(0, n);
                    string5 = string4.substring(n);
                }
                Set<File> set = null;
                for (String string7 : Util.getLocalizingSuffixesFast()) {
                    String string8 = string6 + string7 + string5;
                    Set<File> set2 = this.locateExactPath(string3, string8, bl2, string2);
                    if (set2.isEmpty()) continue;
                    if (bl2) {
                        // ** MonitorExit[var8_8] (shouldn't be in output)
                        return set2;
                    }
                    if (set == null) {
                        set = set2;
                        continue;
                    }
                    set = new LinkedHashSet<File>(set);
                    set.addAll(set2);
                }
                // ** MonitorExit[var8_8] (shouldn't be in output)
                return set != null ? set : Collections.emptySet();
            }
            // ** MonitorExit[var8_8] (shouldn't be in output)
            return this.locateExactPath(string3, string4, bl2, string2);
        }
    }

    private Set<File> locateExactPath(String string, String string2, boolean bl, String string3) {
        assert (Thread.holdsLock(InstalledFileLocatorImpl.class));
        Set<File> set = null;
        String string4 = string + string2;
        if (fileCache != null) {
            Map<File, Set<String>> map = this.fileCachePerPrefix(string);
            for (File file : this.clustersFor(string3, string4)) {
                Set<String> set2 = map.get(file);
                if (set2 == null || !set2.contains(string2)) continue;
                assert (InstalledFileLocatorImpl.owned(string3, file, string4));
                File file2 = InstalledFileLocatorImpl.makeFile(file, string4);
                if (bl) {
                    return Collections.singleton(file2);
                }
                if (set == null) {
                    set = Collections.singleton(file2);
                    continue;
                }
                set = new LinkedHashSet<File>(set);
                set.add(file2);
            }
        } else {
            for (File file : this.clustersFor(string3, string4)) {
                File file3 = InstalledFileLocatorImpl.makeFile(file, string4);
                if (!file3.exists()) continue;
                assert (InstalledFileLocatorImpl.owned(string3, file, string4));
                if (bl) {
                    return Collections.singleton(file3);
                }
                if (set == null) {
                    set = Collections.singleton(file3);
                    continue;
                }
                set = new LinkedHashSet<File>(set);
                set.add(file3);
            }
        }
        return set != null ? set : Collections.emptySet();
    }

    private List<File> clustersFor(String string, String string2) {
        List<File> list;
        assert (Thread.holdsLock(InstalledFileLocatorImpl.class));
        if (string == null) {
            return Arrays.asList(this.dirs);
        }
        String string3 = string.replace('.', '-');
        if (string2.matches("(modules/(locale/)?)?" + string3 + "(_[^/]+)?[.]jar")) {
            return Arrays.asList(this.dirs);
        }
        List<File> list2 = list = clusterCache != null ? clusterCache.get(string) : null;
        if (list == null) {
            list = new ArrayList<File>(1);
            String string4 = "update_tracking/" + string3 + ".xml";
            for (File file : this.dirs) {
                File file2 = new File(file, string4);
                if (LOG.isLoggable(Level.FINE)) {
                    LOG.log(Level.FINE, "checking {0} due to {1} cache={2}", new Object[]{file2, string2, clusterCache != null});
                }
                if (!file2.isFile()) continue;
                list.add(file);
            }
            if (clusterCache != null) {
                clusterCache.put(string, list);
                InstalledFileLocatorImpl.scheduleSave();
            }
        }
        if (list.isEmpty()) {
            return Arrays.asList(this.dirs);
        }
        return list;
    }

    private static String[] prefixAndName(String string) {
        String string2;
        String string3;
        if (string.length() == 0) {
            throw new IllegalArgumentException("Cannot look up \"\" in InstalledFileLocator.locate");
        }
        if (string.charAt(0) == '/') {
            throw new IllegalArgumentException("Paths passed to InstalledFileLocator.locate should not start with '/': " + string);
        }
        int n = string.lastIndexOf(47);
        if (n == string.length() - 1) {
            throw new IllegalArgumentException("Paths passed to InstalledFileLocator.locate should not end in '/': " + string);
        }
        if (n != -1) {
            string3 = string.substring(0, n + 1);
            string2 = string.substring(n + 1);
            assert (string2.length() > 0);
        } else {
            string3 = "";
            string2 = string;
        }
        return new String[]{string3, string2};
    }

    private Map<File, Set<String>> fileCachePerPrefix(String string) {
        assert (Thread.holdsLock(InstalledFileLocatorImpl.class));
        Map<File, Set<String>> map = fileCache.get(string);
        if (map == null) {
            map = new HashMap<File, Set<String>>(this.dirs.length * 2);
            for (int i = 0; i < this.dirs.length; ++i) {
                boolean bl;
                File file;
                File file2 = this.dirs[i];
                if (string.length() > 0) {
                    assert (string.charAt(string.length() - 1) == '/');
                    file = new File(file2, string.substring(0, string.length() - 1).replace('/', File.separatorChar));
                    bl = file.isDirectory();
                } else {
                    file = file2;
                    bl = true;
                }
                if (!bl) continue;
                String[] stringArray = file.list();
                if (stringArray != null) {
                    map.put(file2, new HashSet<String>(Arrays.asList(stringArray)));
                    continue;
                }
                Util.err.log(Level.WARNING, "could not read files in {0} at {1}", new Object[]{file, InstalledFileLocatorImpl.findCaller()});
            }
            fileCache.put(string, map);
            InstalledFileLocatorImpl.scheduleSave();
        }
        return map;
    }

    private static File makeFile(File file, String string) {
        return new File(file, string.replace('/', File.separatorChar));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static synchronized boolean owned(String string, File file, String string2) {
        Object object;
        Set<String> set;
        if (string == null) {
            LOG.log(Level.WARNING, "no code name base passed when looking up {0} at {1}", new Object[]{string2, InstalledFileLocatorImpl.findCaller()});
            return true;
        }
        if (string2.lastIndexOf(95) > string2.lastIndexOf(47)) {
            return true;
        }
        String string3 = string.replace('.', '-');
        if (string2.equals("modules/" + string3 + ".jar")) {
            return true;
        }
        if (string2.equals("update_tracking/" + string3 + ".xml")) {
            return true;
        }
        Map<String, Set<String>> map = ownershipByModuleByCluster.get(file);
        File file2 = new File(file, "update_tracking");
        if (map == null) {
            if (!file2.isDirectory()) {
                LOG.log(Level.FINE, "No update tracking found in {0}", file);
                return true;
            }
            map = new HashMap<String, Set<String>>();
            ownershipByModuleByCluster.put(file, map);
        }
        if ((set = map.get(string)) == null) {
            File file3 = new File(file2, string3 + ".xml");
            if (!file3.isFile()) {
                LOG.log(Level.WARNING, "no such module {0} at {1}", new Object[]{file3, InstalledFileLocatorImpl.findCaller()});
                return true;
            }
            set = new HashSet<String>();
            try {
                if (LOG.isLoggable(Level.FINE)) {
                    LOG.log(Level.FINE, "Parsing {0} due to {1}", new Object[]{file3, string2});
                }
                object = new FileReader(file3);
                try {
                    String string4;
                    BufferedReader bufferedReader = new BufferedReader((Reader)object);
                    while ((string4 = bufferedReader.readLine()) != null) {
                        Matcher matcher = FILE_PATTERN.matcher(string4);
                        if (!matcher.matches()) continue;
                        set.add(matcher.group(1));
                    }
                    bufferedReader.close();
                }
                finally {
                    ((Reader)object).close();
                }
            }
            catch (IOException iOException) {
                LOG.log(Level.INFO, "could not parse " + file3, iOException);
                return true;
            }
            if (LOG.isLoggable(Level.FINER)) {
                LOG.log(Level.FINER, "parsed {0} -> {1}", new Object[]{file3, set});
            }
            map.put(string, set);
        }
        if (!set.contains(string2)) {
            boolean bl = false;
            if (InstalledFileLocatorImpl.makeFile(file, string2).isDirectory()) {
                object = string2 + "/";
                for (String string4 : set) {
                    if (!string4.startsWith((String)object)) continue;
                    bl = true;
                    break;
                }
            }
            if (!bl) {
                LOG.log(Level.WARNING, "module {0} in {1} does not own {2} at {3}", new Object[]{string, file, string2, InstalledFileLocatorImpl.findCaller()});
            }
        }
        return true;
    }

    private static String findCaller() {
        for (StackTraceElement stackTraceElement : Thread.currentThread().getStackTrace()) {
            if (stackTraceElement.getClassName().matches(".*InstalledFileLocator.*|java[.].+")) continue;
            return stackTraceElement.toString();
        }
        return "???";
    }

    private static synchronized void scheduleSave() {
        cacheMiss = true;
    }

    static List<File> computeDirs() {
        ArrayList<File> arrayList = new ArrayList<File>();
        InstalledFileLocatorImpl.addDir(arrayList, System.getProperty("netbeans.user"));
        String string = System.getProperty("netbeans.dirs");
        if (string != null) {
            StringTokenizer stringTokenizer = new StringTokenizer(string, File.pathSeparator);
            while (stringTokenizer.hasMoreTokens()) {
                InstalledFileLocatorImpl.addDir(arrayList, stringTokenizer.nextToken());
            }
        }
        InstalledFileLocatorImpl.addDir(arrayList, System.getProperty("netbeans.home"));
        return arrayList;
    }

    static {
        FILE_PATTERN = Pattern.compile("\\s*<file.+name=[\"']([^\"']+)[\"'].*/>");
        ownershipByModuleByCluster = new HashMap<File, Map<String, Set<String>>>();
    }
}

