/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.application.views.overview;

import java.util.Set;
import org.graalvm.visualvm.application.Application;
import org.graalvm.visualvm.application.snapshot.ApplicationSnapshot;
import org.graalvm.visualvm.application.views.overview.ApplicationOverviewModel;
import org.graalvm.visualvm.application.views.overview.ApplicationOverviewView;
import org.graalvm.visualvm.core.datasource.DataSource;
import org.graalvm.visualvm.core.snapshot.Snapshot;
import org.graalvm.visualvm.core.ui.DataSourceView;
import org.graalvm.visualvm.core.ui.PluggableDataSourceViewProvider;

public class ApplicationOverviewViewProvider
extends PluggableDataSourceViewProvider<Application> {
    protected boolean supportsViewFor(Application application) {
        return true;
    }

    protected DataSourceView createView(Application application) {
        return new ApplicationOverviewView((DataSource)application, ApplicationOverviewModel.create(application));
    }

    public Set<Integer> getPluggableLocations(DataSourceView view) {
        return ALL_LOCATIONS;
    }

    protected boolean supportsSaveViewFor(Application application, Class<? extends Snapshot> snapshotClass) {
        return ApplicationSnapshot.class.isAssignableFrom(snapshotClass);
    }

    protected void saveView(Application application, Snapshot snapshot) {
        ApplicationOverviewView view = (ApplicationOverviewView)this.getCachedView((DataSource)application);
        if (view != null) {
            view.getModel().save(snapshot);
        } else {
            ApplicationOverviewModel.create(application).save(snapshot);
        }
    }
}

