/*
 * Decompiled with CFR 0.152.
 */
package org.openide.text;

import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.openide.text.Line;
import org.openide.util.BaseUtilities;

final class LineVector {
    private static final Logger LOG = Logger.getLogger(LineVector.class.getName());
    private Ref[] refArray;
    private int gapStart;
    private int gapLength;
    private int disposedRefCount;
    private boolean refArrayUnsorted;
    private Thread lockThread;
    private int lockDepth;
    private List<LineUpdater> pendingLineUpdaters = new ArrayList<LineUpdater>(2);

    LineVector() {
        this.refArray = new Ref[4];
        this.gapLength = this.refArray.length;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Line findOrCreateLine(int n, LineCreator lineCreator) {
        this.lockCheckUpdate();
        try {
            int n2 = this.refCount() - 1;
            int n3 = 0;
            int n4 = n2;
            if (!this.refArrayUnsorted) {
                int n5 = -1;
                int n6 = Integer.MAX_VALUE;
                while (n3 <= n4) {
                    int n7;
                    int n8 = n3 + n4 >>> 1;
                    Ref ref = this.refArray[this.rawIndex(n8)];
                    Line line = (Line)ref.get();
                    if (line == null) {
                        for (n7 = n8 - 1; n7 >= 0 && (line = (Line)(ref = this.refArray[this.rawIndex(n7)]).get()) == null; --n7) {
                        }
                    }
                    int n9 = n7 = line != null ? line.getLineNumber() : -1;
                    if (n7 < n5 || n7 > n6) {
                        if (LOG.isLoggable(Level.FINE)) {
                            String string = "!!!LineVector: ARRAY BECAME UNSORTED!!!\n  " + this.toStringDetail() + "    lineIndex=" + n7 + ", lowLineIndex=" + n5 + ", highLineIndex=" + n6 + "\n    low=" + n3 + ", high=" + n4 + ", mid=" + n8 + "\n";
                            LOG.log(Level.INFO, string, new Throwable());
                        }
                        this.refArrayUnsorted = true;
                        break;
                    }
                    if (n7 < n) {
                        n3 = n8 + 1;
                        n5 = n7;
                        continue;
                    }
                    if (n7 > n) {
                        n4 = n8 - 1;
                        n6 = n7;
                        continue;
                    }
                    Line line2 = line;
                    return line2;
                }
            }
            if (this.refArrayUnsorted) {
                while (n3 <= n2) {
                    Ref ref = this.refArray[this.rawIndex(n3)];
                    Line line = (Line)ref.get();
                    if (line != null && line.getLineNumber() == n) {
                        Line line3 = line;
                        return line3;
                    }
                    ++n3;
                }
                n3 = this.gapStart;
            }
            Line line = lineCreator != null ? this.addLine(n3, lineCreator.createLine(n)) : null;
            return line;
        }
        finally {
            this.unlockCheckUpdate();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void updateLines(LineUpdater lineUpdater) {
        LineVector lineVector = this;
        synchronized (lineVector) {
            this.pendingLineUpdaters.add(lineUpdater);
            if (this.lockThread == null) {
                this.lockCheckUpdate();
                this.unlockCheckUpdate();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateLinesCheck() {
        ArrayList<LineUpdater> arrayList;
        LineVector lineVector = this;
        synchronized (lineVector) {
            if (this.pendingLineUpdaters.size() > 0) {
                arrayList = new ArrayList<LineUpdater>(this.pendingLineUpdaters);
                this.pendingLineUpdaters.clear();
            } else {
                arrayList = null;
            }
        }
        if (arrayList != null) {
            for (LineUpdater lineUpdater : arrayList) {
                Line line;
                int n;
                for (n = 0; n < this.gapStart; ++n) {
                    line = (Line)this.refArray[n].get();
                    lineUpdater.updateLine(line);
                }
                for (n = this.gapStart + this.gapLength; n < this.refArray.length; ++n) {
                    line = (Line)this.refArray[n].get();
                    lineUpdater.updateLine(line);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    List<Line> getLinesInRange(int n, int n2) {
        this.lockCheckUpdate();
        try {
            int n3;
            ArrayList<Line> arrayList = new ArrayList<Line>();
            int n4 = this.refCount() - 1;
            int n5 = 0;
            int n6 = n4;
            if (!this.refArrayUnsorted) {
                int n7 = -1;
                n3 = Integer.MAX_VALUE;
                while (n5 <= n6) {
                    int n8;
                    int n9 = n5 + n6 >>> 1;
                    Ref ref = this.refArray[this.rawIndex(n9)];
                    Line line = (Line)ref.get();
                    if (line == null) {
                        for (n8 = n9 - 1; n8 >= 0 && (line = (Line)(ref = this.refArray[this.rawIndex(n8)]).get()) == null; --n8) {
                        }
                    }
                    int n10 = n8 = line != null ? line.getLineNumber() : -1;
                    if (n8 < n7 || n8 > n3) {
                        this.refArrayUnsorted = true;
                        if (!LOG.isLoggable(Level.FINE)) break;
                        String string = "!!!LineVector: ARRAY BECAME UNSORTED!!!\n  " + this.toStringDetail() + "    lineIndex=" + n8 + ", lowLineIndex=" + n7 + ", highLineIndex=" + n3 + "\n    low=" + n5 + ", high=" + n6 + ", mid=" + n9 + "\n";
                        LOG.log(Level.INFO, string, new Throwable());
                        break;
                    }
                    if (n8 < n) {
                        n5 = n9 + 1;
                        n7 = n8;
                        continue;
                    }
                    if (n8 > n) {
                        n6 = n9 - 1;
                        n3 = n8;
                        continue;
                    }
                    while (--n9 >= 0 && ((line = (Line)(ref = this.refArray[this.rawIndex(n9)]).get()) == null || line.getLineNumber() >= n)) {
                    }
                    n5 = n9 + 1;
                    break;
                }
                if (!this.refArrayUnsorted) {
                    while (n5 <= n4) {
                        Line line = (Line)this.refArray[this.rawIndex(n5)].get();
                        if (line != null) {
                            int n11 = line.getLineNumber();
                            if (n > n11 || n11 > n2) break;
                            arrayList.add(line);
                        }
                        ++n5;
                    }
                }
            }
            if (this.refArrayUnsorted) {
                while (n5 <= n4) {
                    Line line = (Line)this.refArray[this.rawIndex(n5)].get();
                    if (line != null && n <= (n3 = line.getLineNumber()) && n3 <= n2) {
                        arrayList.add(line);
                    }
                    ++n5;
                }
            }
            ArrayList<Line> arrayList2 = arrayList;
            return arrayList2;
        }
        finally {
            this.unlockCheckUpdate();
        }
    }

    private Line addLine(int n, Line line) {
        this.moveGap(n);
        if (this.gapLength == 0) {
            this.reallocate(this.refArray.length + 8 >> 2);
        }
        this.refArray[this.gapStart++] = new Ref(line);
        --this.gapLength;
        return line;
    }

    private int refCount() {
        return this.refArray.length - this.gapLength;
    }

    private int rawIndex(int n) {
        return n < this.gapStart ? n : n + this.gapLength;
    }

    private void moveGap(int n) {
        if (n <= this.gapStart) {
            int n2 = this.gapStart - n;
            System.arraycopy(this.refArray, n, this.refArray, this.gapStart + this.gapLength - n2, n2);
        } else {
            int n3 = n - this.gapStart;
            System.arraycopy(this.refArray, this.gapStart + this.gapLength, this.refArray, this.gapStart, n3);
        }
        this.gapStart = n;
    }

    synchronized void refGC() {
        ++this.disposedRefCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkRemoveEmptyRefs() {
        int n;
        LineVector lineVector = this;
        synchronized (lineVector) {
            n = this.disposedRefCount;
        }
        if (n > 4 && n > this.refCount() >>> 3) {
            this.removeEmptyRefs();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeEmptyRefs() {
        int n;
        int n2;
        int n3 = 0;
        int n4 = 0;
        int n5 = this.gapStart + this.gapLength;
        for (n2 = 0; n2 < this.gapStart; ++n2) {
            Ref ref = this.refArray[n2];
            if (ref.get() != null) {
                if (n2 != n3) {
                    this.refArray[n3] = ref;
                }
                ++n3;
                continue;
            }
            ++n4;
        }
        this.gapStart = n3;
        int n6 = n2 = this.refArray.length;
        while (--n2 >= n5) {
            Ref ref = this.refArray[n2];
            if (ref.get() != null) {
                if (n2 == --n6) continue;
                this.refArray[n6] = ref;
                continue;
            }
            ++n4;
        }
        this.gapLength = n = n6 - this.gapStart;
        while (n3 < n6) {
            this.refArray[n3++] = null;
        }
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("LineVector.removeDisposedRefsLockAcquired() refCount=" + this.refCount() + ", emptyCount=" + n4 + "\n");
        }
        LineVector lineVector = this;
        synchronized (lineVector) {
            this.disposedRefCount -= n4;
        }
    }

    private void reallocate(int n) {
        int n2 = this.gapStart + this.gapLength;
        int n3 = this.refArray.length - n2;
        int n4 = this.gapStart + n3 + n;
        Ref[] refArray = new Ref[n4];
        System.arraycopy(this.refArray, 0, refArray, 0, this.gapStart);
        System.arraycopy(this.refArray, n2, refArray, n4 - n3, n3);
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("LineVector.reallocate() from refArray.length=" + this.refArray.length + " to newLength=" + n4 + "\n");
        }
        this.gapLength = n;
        this.refArray = refArray;
    }

    private void lockCheckUpdate() {
        this.lock();
        this.checkRemoveEmptyRefs();
    }

    private synchronized void lock() {
        Thread thread = Thread.currentThread();
        while (this.lockThread != null && thread != this.lockThread) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {
                throw new Error("Interrupted attempt to aquire lock");
            }
        }
        if (this.lockThread != null) {
            throw new IllegalStateException("Recursive line vector locking prohibited. LineVector: " + this);
        }
        this.lockThread = thread;
        ++this.lockDepth;
    }

    private void unlockCheckUpdate() {
        this.updateLinesCheck();
        this.unlock();
    }

    private synchronized void unlock() {
        --this.lockDepth;
        if (this.lockDepth == 0) {
            this.lockThread = null;
            this.notifyAll();
        }
    }

    public String toString() {
        return "refArray.length=" + this.refArray.length + ", gapStart=" + this.gapStart + ", gapLength=" + this.gapLength + ", disposedRefCount=" + this.disposedRefCount + ", activeRefCount=" + (this.refCount() - this.disposedRefCount) + "\n  refArrayUnsorted=" + this.refArrayUnsorted + ", lockThread=" + this.lockThread + ", lockDepth=" + this.lockDepth + ", pendingLineUpdaters=" + this.pendingLineUpdaters;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String toStringDetail() {
        StringBuilder stringBuilder = new StringBuilder(256);
        this.lock();
        try {
            stringBuilder.append(this.toString()).append('\n');
            for (int i = 0; i < this.refCount(); ++i) {
                Ref ref = this.refArray[this.rawIndex(i)];
                Line line = (Line)ref.get();
                stringBuilder.append("[").append(i).append("]:\t").append(line).append('\n');
            }
        }
        finally {
            this.unlock();
        }
        return stringBuilder.toString();
    }

    static interface LineUpdater {
        public void updateLine(Line var1);
    }

    static interface LineCreator {
        public Line createLine(int var1);
    }

    private final class Ref
    extends WeakReference<Line>
    implements Runnable {
        public Ref(Line line) {
            super(line, BaseUtilities.activeReferenceQueue());
        }

        @Override
        public void run() {
            LineVector.this.refGC();
        }
    }
}

