/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.lib.jfluid.results.memory;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.graalvm.visualvm.lib.jfluid.results.memory.AllocMemoryResultsSnapshot;
import org.graalvm.visualvm.lib.jfluid.results.memory.DiffObjAllocCCTNode;
import org.graalvm.visualvm.lib.jfluid.results.memory.JMethodIdTable;
import org.graalvm.visualvm.lib.jfluid.results.memory.PresoObjAllocCCTNode;
import org.graalvm.visualvm.lib.jfluid.results.memory.RuntimeMemoryCCTNode;

public class AllocMemoryResultsDiff
extends AllocMemoryResultsSnapshot {
    private final AllocMemoryResultsSnapshot snapshot1;
    private final AllocMemoryResultsSnapshot snapshot2;
    private String[] classNames;
    private int[] objectsCounts;
    private long[] objectsSizePerClass;
    private int nClasses;
    private long maxObjectsSizePerClassDiff;
    private long minObjectsSizePerClassDiff;

    public AllocMemoryResultsDiff(AllocMemoryResultsSnapshot snapshot1, AllocMemoryResultsSnapshot snapshot2) {
        this.snapshot1 = snapshot1;
        this.snapshot2 = snapshot2;
        this.computeDiff(snapshot1, snapshot2);
    }

    @Override
    public long getBeginTime() {
        return -1L;
    }

    @Override
    public String getClassName(int classId) {
        return this.classNames[classId];
    }

    @Override
    public String[] getClassNames() {
        return this.classNames;
    }

    @Override
    public JMethodIdTable getJMethodIdTable() {
        return null;
    }

    public long getMaxObjectsSizePerClassDiff() {
        return this.maxObjectsSizePerClassDiff;
    }

    public long getMinObjectsSizePerClassDiff() {
        return this.minObjectsSizePerClassDiff;
    }

    @Override
    public int getNProfiledClasses() {
        return this.nClasses;
    }

    @Override
    public int[] getObjectsCounts() {
        return this.objectsCounts;
    }

    @Override
    public long[] getObjectsSizePerClass() {
        return this.objectsSizePerClass;
    }

    @Override
    public long getTimeTaken() {
        return -1L;
    }

    @Override
    public boolean containsStacks() {
        return this.snapshot1.containsStacks() && this.snapshot2.containsStacks();
    }

    @Override
    public PresoObjAllocCCTNode createPresentationCCT(int classId, boolean dontShowZeroLiveObjAllocPaths) {
        int selectId1 = this.classId1(classId);
        int selectId2 = this.classId2(classId);
        PresoObjAllocCCTNode node1 = null;
        PresoObjAllocCCTNode node2 = null;
        if (selectId1 != -1) {
            node1 = this.snapshot1.createPresentationCCT(selectId1, dontShowZeroLiveObjAllocPaths);
        }
        if (selectId2 != -1) {
            node2 = this.snapshot2.createPresentationCCT(selectId2, dontShowZeroLiveObjAllocPaths);
        }
        return new DiffObjAllocCCTNode(node1, node2);
    }

    @Override
    public void readFromStream(DataInputStream in) throws IOException {
        throw new UnsupportedOperationException("Persistence not supported for snapshot comparison");
    }

    @Override
    public void writeToStream(DataOutputStream out) throws IOException {
        throw new UnsupportedOperationException("Persistence not supported for snapshot comparison");
    }

    @Override
    protected PresoObjAllocCCTNode createPresentationCCT(RuntimeMemoryCCTNode rootNode, int classId, boolean dontShowZeroLiveObjAllocPaths) {
        int selectId1 = this.classId1(classId);
        int selectId2 = this.classId2(classId);
        PresoObjAllocCCTNode node1 = null;
        PresoObjAllocCCTNode node2 = null;
        if (selectId1 != -1) {
            node1 = this.snapshot1.createPresentationCCT(rootNode, selectId1, dontShowZeroLiveObjAllocPaths);
        }
        if (selectId2 != -1) {
            node2 = this.snapshot2.createPresentationCCT(rootNode, selectId2, dontShowZeroLiveObjAllocPaths);
        }
        return new DiffObjAllocCCTNode(node1, node2);
    }

    private int classId1(int classId) {
        return this.classId(classId, this.snapshot1);
    }

    private int classId2(int classId) {
        return this.classId(classId, this.snapshot2);
    }

    private int classId(int classId, AllocMemoryResultsSnapshot snapshot) {
        if (snapshot == null) {
            return -1;
        }
        String className = this.getClassName(classId);
        String[] classNames = snapshot.getClassNames();
        if (classNames == null) {
            return -1;
        }
        for (int i = 0; i < classNames.length; ++i) {
            if (!classNames[i].equals(className)) continue;
            return i;
        }
        return -1;
    }

    private void computeDiff(AllocMemoryResultsSnapshot snapshot1, AllocMemoryResultsSnapshot snapshot2) {
        int s1nClasses = Math.min(snapshot1.getNProfiledClasses(), snapshot1.getObjectsCounts().length);
        s1nClasses = Math.min(s1nClasses, snapshot1.getObjectsSizePerClass().length);
        int s2nClasses = Math.min(snapshot2.getNProfiledClasses(), snapshot2.getObjectsCounts().length);
        s2nClasses = Math.min(s2nClasses, snapshot2.getObjectsSizePerClass().length);
        HashMap<String, Integer> classNamesIdxMap = new HashMap<String, Integer>(s1nClasses);
        ArrayList<Integer> objCountsArr = new ArrayList<Integer>(s1nClasses);
        ArrayList<Long> objSizesArr = new ArrayList<Long>(s1nClasses);
        String[] s1ClassNames = snapshot1.getClassNames();
        int[] s1ObjectsCount = snapshot1.getObjectsCounts();
        long[] s1ObjectsSizes = snapshot1.getObjectsSizePerClass();
        for (int i = 0; i < s1nClasses; ++i) {
            Integer classIdx = (Integer)classNamesIdxMap.get(s1ClassNames[i]);
            if (classIdx != null) {
                objCountsArr.set(classIdx, (Integer)objCountsArr.get(classIdx) - s1ObjectsCount[i]);
                objSizesArr.set(classIdx, (Long)objSizesArr.get(classIdx) - s1ObjectsSizes[i]);
                continue;
            }
            classNamesIdxMap.put(s1ClassNames[i], objCountsArr.size());
            objCountsArr.add(-s1ObjectsCount[i]);
            objSizesArr.add(-s1ObjectsSizes[i]);
        }
        String[] s2ClassNames = snapshot2.getClassNames();
        int[] s2ObjectsCount = snapshot2.getObjectsCounts();
        long[] s2ObjectsSizes = snapshot2.getObjectsSizePerClass();
        for (int i = 0; i < s2nClasses; ++i) {
            Integer classIdx = (Integer)classNamesIdxMap.get(s2ClassNames[i]);
            if (classIdx != null) {
                objCountsArr.set(classIdx, (Integer)objCountsArr.get(classIdx) + s2ObjectsCount[i]);
                objSizesArr.set(classIdx, (Long)objSizesArr.get(classIdx) + s2ObjectsSizes[i]);
                continue;
            }
            classNamesIdxMap.put(s2ClassNames[i], objCountsArr.size());
            objCountsArr.add(s2ObjectsCount[i]);
            objSizesArr.add(s2ObjectsSizes[i]);
        }
        this.nClasses = classNamesIdxMap.size();
        this.classNames = new String[this.nClasses];
        this.objectsCounts = new int[this.nClasses];
        this.objectsSizePerClass = new long[this.nClasses];
        this.minObjectsSizePerClassDiff = Long.MAX_VALUE;
        this.maxObjectsSizePerClassDiff = Long.MIN_VALUE;
        Iterator classNamesIter = classNamesIdxMap.entrySet().iterator();
        int index = 0;
        while (classNamesIter.hasNext()) {
            Map.Entry entry = classNamesIter.next();
            int classIndex = (Integer)entry.getValue();
            this.classNames[index] = (String)entry.getKey();
            this.objectsCounts[index] = (Integer)objCountsArr.get(classIndex);
            this.objectsSizePerClass[index] = (Long)objSizesArr.get(classIndex);
            this.minObjectsSizePerClassDiff = Math.min(this.minObjectsSizePerClassDiff, this.objectsSizePerClass[index]);
            this.maxObjectsSizePerClassDiff = Math.max(this.maxObjectsSizePerClassDiff, this.objectsSizePerClass[index]);
            ++index;
        }
        if (this.minObjectsSizePerClassDiff > 0L && this.maxObjectsSizePerClassDiff > 0L) {
            this.minObjectsSizePerClassDiff = 0L;
        } else if (this.minObjectsSizePerClassDiff < 0L && this.maxObjectsSizePerClassDiff < 0L) {
            this.maxObjectsSizePerClassDiff = 0L;
        }
    }
}

