/*
 * Decompiled with CFR 0.152.
 */
package jflex.anttask;

import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.LineNumberReader;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import jflex.GeneratorException;
import jflex.Main;
import jflex.Options;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;

public class JFlexTask
extends Task {
    private static final Pattern PACKAGE_PATTERN = Pattern.compile("package\\s+(\\S+)\\s*;");
    private static final Pattern CLASS_PATTERN = Pattern.compile("%class\\s+(\\S+)");
    private File inputFile;
    private String className = null;
    private String packageName = null;
    private File destinationDir;
    private File outputDir = null;

    public JFlexTask() {
        this.setVerbose(false);
        Options.progress = false;
    }

    public void execute() throws BuildException {
        try {
            if (this.inputFile == null) {
                throw new BuildException("Input file needed. Use <jflex file=\"your_scanner.flex\"/>");
            }
            if (!this.inputFile.canRead()) {
                throw new BuildException("Cannot read input file " + this.inputFile);
            }
            try {
                this.findPackageAndClass();
                this.normalizeOutdir();
                File destFile = new File(this.outputDir, this.className + ".java");
                if (this.inputFile.lastModified() > destFile.lastModified()) {
                    Main.generate(this.inputFile);
                    if (!Options.verbose) {
                        System.out.println("Generated: " + destFile.getName());
                    }
                }
            }
            catch (IOException e1) {
                throw new BuildException("IOException: " + e1.toString());
            }
        }
        catch (GeneratorException e) {
            throw new BuildException("JFlex: generation failed!");
        }
    }

    public void findPackageAndClass() throws IOException {
        String line;
        this.packageName = null;
        this.className = null;
        LineNumberReader reader = new LineNumberReader(new FileReader(this.inputFile));
        while ((this.className == null || this.packageName == null) && (line = reader.readLine()) != null) {
            Matcher matcher;
            if (this.packageName == null && (matcher = PACKAGE_PATTERN.matcher(line)).find()) {
                this.packageName = matcher.group(1);
            }
            if (this.className != null || !(matcher = CLASS_PATTERN.matcher(line)).find()) continue;
            this.className = matcher.group(1);
        }
        if (this.className == null) {
            this.className = "Yylex";
        }
    }

    public void normalizeOutdir() {
        File destDir;
        if (this.outputDir != null) {
            return;
        }
        if (this.destinationDir != null) {
            if (this.packageName == null) {
                destDir = this.destinationDir;
            } else {
                String path = this.packageName.replace('.', File.separatorChar);
                destDir = new File(this.destinationDir, path);
            }
        } else {
            destDir = new File(this.inputFile.getParent());
        }
        this.setOutdir(destDir);
    }

    public String getPackage() {
        return this.packageName;
    }

    public String getClassName() {
        return this.className;
    }

    public void setDestdir(File destinationDir) {
        this.destinationDir = destinationDir;
    }

    public void setOutdir(File outDir) {
        this.outputDir = outDir;
        Options.setDir(this.outputDir);
    }

    public void setFile(File file) {
        this.inputFile = file;
    }

    public void setGenerateDot(boolean genDot) {
        this.setDot(genDot);
    }

    public void setTimeStatistics(boolean displayTime) {
        Options.time = displayTime;
    }

    public void setTime(boolean displayTime) {
        this.setTimeStatistics(displayTime);
    }

    public void setVerbose(boolean verbose) {
        Options.verbose = verbose;
    }

    public void setSkeleton(File skeleton) {
        Options.setSkeleton(skeleton);
    }

    public void setSkel(File skeleton) {
        this.setSkeleton(skeleton);
    }

    public void setSkipMinimization(boolean skipMin) {
        this.setNomin(skipMin);
    }

    public void setNomin(boolean b) {
        Options.no_minimize = b;
    }

    public void setNobak(boolean b) {
        Options.no_backup = b;
    }

    public void setPack(boolean b) {
    }

    public void setDot(boolean b) {
        Options.dot = b;
    }

    public void setDump(boolean b) {
        Options.dump = b;
    }

    public void setJLex(boolean b) {
        Options.jlex = b;
    }

    public void setLegacyDot(boolean b) {
        Options.legacy_dot = b;
    }

    public void setInputStreamCtor(boolean b) {
        Options.emitInputStreamCtor = b;
    }
}

