/*
 * Decompiled with CFR 0.152.
 */
package org.diylc.components.semiconductors;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Composite;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.geom.Area;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RoundRectangle2D;
import org.diylc.appframework.miscutils.ConfigurationManager;
import org.diylc.common.Display;
import org.diylc.common.ObjectCache;
import org.diylc.common.Orientation;
import org.diylc.components.AbstractTransparentComponent;
import org.diylc.core.ComponentState;
import org.diylc.core.IDrawingObserver;
import org.diylc.core.Project;
import org.diylc.core.Theme;
import org.diylc.core.VisibilityPolicy;
import org.diylc.core.annotations.ComponentDescriptor;
import org.diylc.core.annotations.EditableProperty;
import org.diylc.core.measures.Size;
import org.diylc.core.measures.SizeUnit;
import org.diylc.utils.Constants;

@ComponentDescriptor(name="DIP IC", author="Branislav Stojkovic", category="Semiconductors", instanceNamePrefix="IC", description="Dual-in-line package IC", stretchable=false, zOrder=4.0)
public class DIL_IC
extends AbstractTransparentComponent<String> {
    private static final long serialVersionUID = 1L;
    public static Color BODY_COLOR = Color.gray;
    public static Color BORDER_COLOR = Color.gray.darker();
    public static Color PIN_COLOR = Color.decode("#00B2EE");
    public static Color PIN_BORDER_COLOR = PIN_COLOR.darker();
    public static Color INDENT_COLOR = Color.gray.darker();
    public static Color LABEL_COLOR = Color.white;
    public static int EDGE_RADIUS = 6;
    public static Size PIN_SIZE = new Size(Double.valueOf(0.04), SizeUnit.in);
    public static Size INDENT_SIZE = new Size(Double.valueOf(0.07), SizeUnit.in);
    private String value = "";
    private Orientation orientation = Orientation.DEFAULT;
    private PinCount pinCount = PinCount._8;
    private Size pinSpacing = new Size(Double.valueOf(0.1), SizeUnit.in);
    private Size rowSpacing = new Size(Double.valueOf(0.3), SizeUnit.in);
    private Point[] controlPoints = new Point[]{new Point(0, 0)};
    protected Display display = Display.NAME;
    private Color bodyColor = BODY_COLOR;
    private Color borderColor = BORDER_COLOR;
    private Color labelColor = LABEL_COLOR;
    private Color indentColor = INDENT_COLOR;
    private transient Area[] body;

    public DIL_IC() {
        this.updateControlPoints();
    }

    @EditableProperty
    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    @EditableProperty
    public Orientation getOrientation() {
        return this.orientation;
    }

    public void setOrientation(Orientation orientation) {
        this.orientation = orientation;
        this.updateControlPoints();
        this.body = null;
    }

    @EditableProperty(name="Pins")
    public PinCount getPinCount() {
        return this.pinCount;
    }

    public void setPinCount(PinCount pinCount) {
        this.pinCount = pinCount;
        this.updateControlPoints();
        this.body = null;
    }

    @EditableProperty(name="Pin spacing")
    public Size getPinSpacing() {
        return this.pinSpacing;
    }

    public void setPinSpacing(Size pinSpacing) {
        this.pinSpacing = pinSpacing;
    }

    @EditableProperty(name="Row spacing")
    public Size getRowSpacing() {
        return this.rowSpacing;
    }

    public void setRowSpacing(Size rowSpacing) {
        this.rowSpacing = rowSpacing;
        this.updateControlPoints();
        this.body = null;
    }

    @EditableProperty
    public Display getDisplay() {
        if (this.display == null) {
            this.display = Display.VALUE;
        }
        return this.display;
    }

    public void setDisplay(Display display) {
        this.display = display;
    }

    public int getControlPointCount() {
        return this.controlPoints.length;
    }

    public Point getControlPoint(int index) {
        return this.controlPoints[index];
    }

    public boolean isControlPointSticky(int index) {
        return true;
    }

    public VisibilityPolicy getControlPointVisibilityPolicy(int index) {
        return VisibilityPolicy.NEVER;
    }

    public void setControlPoint(Point point, int index) {
        this.controlPoints[index].setLocation(point);
        this.body = null;
    }

    private void updateControlPoints() {
        Point firstPoint = this.controlPoints[0];
        this.controlPoints = new Point[this.pinCount.getValue()];
        this.controlPoints[0] = firstPoint;
        int pinSpacing = (int)this.pinSpacing.convertToPixels();
        int rowSpacing = (int)this.rowSpacing.convertToPixels();
        for (int i = 0; i < this.pinCount.getValue() / 2; ++i) {
            int dy2;
            int dx2;
            int dy1;
            int dx1;
            switch (this.orientation) {
                case DEFAULT: {
                    dx1 = 0;
                    dy1 = i * pinSpacing;
                    dx2 = rowSpacing;
                    dy2 = i * pinSpacing;
                    break;
                }
                case _90: {
                    dx1 = -i * pinSpacing;
                    dy1 = 0;
                    dx2 = -i * pinSpacing;
                    dy2 = rowSpacing;
                    break;
                }
                case _180: {
                    dx1 = 0;
                    dy1 = -i * pinSpacing;
                    dx2 = -rowSpacing;
                    dy2 = -i * pinSpacing;
                    break;
                }
                case _270: {
                    dx1 = i * pinSpacing;
                    dy1 = 0;
                    dx2 = i * pinSpacing;
                    dy2 = -rowSpacing;
                    break;
                }
                default: {
                    throw new RuntimeException("Unexpected orientation: " + this.orientation);
                }
            }
            this.controlPoints[i] = new Point(firstPoint.x + dx1, firstPoint.y + dy1);
            this.controlPoints[i + this.pinCount.getValue() / 2] = new Point(firstPoint.x + dx2, firstPoint.y + dy2);
        }
    }

    public Area[] getBody() {
        if (this.body == null) {
            int height;
            int width;
            this.body = new Area[2];
            int x = this.controlPoints[0].x;
            int y = this.controlPoints[0].y;
            int pinSize = (int)PIN_SIZE.convertToPixels();
            int pinSpacing = (int)this.pinSpacing.convertToPixels();
            int rowSpacing = (int)this.rowSpacing.convertToPixels();
            Area indentation = null;
            int indentationSize = this.getClosestOdd(INDENT_SIZE.convertToPixels());
            switch (this.orientation) {
                case DEFAULT: {
                    width = rowSpacing - pinSize;
                    height = this.pinCount.getValue() / 2 * pinSpacing;
                    indentation = new Area(new Ellipse2D.Double((x += pinSize / 2) + width / 2 - indentationSize / 2, (y -= pinSpacing / 2) - indentationSize / 2, indentationSize, indentationSize));
                    break;
                }
                case _90: {
                    width = this.pinCount.getValue() / 2 * pinSpacing;
                    height = rowSpacing - pinSize;
                    indentation = new Area(new Ellipse2D.Double((x -= pinSpacing / 2 + width - pinSpacing) + width - indentationSize / 2, (y += pinSize / 2) + height / 2 - indentationSize / 2, indentationSize, indentationSize));
                    break;
                }
                case _180: {
                    width = rowSpacing - pinSize;
                    height = this.pinCount.getValue() / 2 * pinSpacing;
                    indentation = new Area(new Ellipse2D.Double((x -= rowSpacing - pinSize / 2) + width / 2 - indentationSize / 2, (y -= pinSpacing / 2 + height - pinSpacing) + height - indentationSize / 2, indentationSize, indentationSize));
                    break;
                }
                case _270: {
                    width = this.pinCount.getValue() / 2 * pinSpacing;
                    height = rowSpacing - pinSize;
                    indentation = new Area(new Ellipse2D.Double((x -= pinSpacing / 2) - indentationSize / 2, (y += pinSize / 2 - rowSpacing) + height / 2 - indentationSize / 2, indentationSize, indentationSize));
                    break;
                }
                default: {
                    throw new RuntimeException("Unexpected orientation: " + this.orientation);
                }
            }
            this.body[0] = new Area(new RoundRectangle2D.Double(x, y, width, height, EDGE_RADIUS, EDGE_RADIUS));
            this.body[1] = indentation;
            if (indentation != null) {
                indentation.intersect(this.body[0]);
            }
        }
        return this.body;
    }

    public void draw(Graphics2D g2d, ComponentState componentState, boolean outlineMode, Project project, IDrawingObserver drawingObserver) {
        Color finalLabelColor;
        Color finalBorderColor;
        if (this.checkPointsClipped(g2d.getClip())) {
            return;
        }
        Area mainArea = this.getBody()[0];
        if (!outlineMode) {
            int pinSize = (int)PIN_SIZE.convertToPixels() / 2 * 2;
            for (Point point : this.controlPoints) {
                g2d.setColor(PIN_COLOR);
                g2d.fillRect(point.x - pinSize / 2, point.y - pinSize / 2, pinSize, pinSize);
                g2d.setColor(PIN_BORDER_COLOR);
                g2d.drawRect(point.x - pinSize / 2, point.y - pinSize / 2, pinSize, pinSize);
            }
        }
        Composite oldComposite = g2d.getComposite();
        if (this.alpha < MAX_ALPHA) {
            g2d.setComposite(AlphaComposite.getInstance(3, 1.0f * (float)this.alpha / (float)MAX_ALPHA));
        }
        g2d.setColor(outlineMode ? Constants.TRANSPARENT_COLOR : this.getBodyColor());
        g2d.fill(mainArea);
        g2d.setComposite(oldComposite);
        if (outlineMode) {
            Theme theme = (Theme)ConfigurationManager.getInstance().readObject("theme", (Object)Constants.DEFAULT_THEME);
            finalBorderColor = componentState == ComponentState.SELECTED || componentState == ComponentState.DRAGGING ? SELECTION_COLOR : theme.getOutlineColor();
        } else {
            finalBorderColor = componentState == ComponentState.SELECTED || componentState == ComponentState.DRAGGING ? SELECTION_COLOR : this.getBorderColor();
        }
        g2d.setColor(finalBorderColor);
        g2d.setStroke(ObjectCache.getInstance().fetchBasicStroke(1));
        if (outlineMode) {
            Area area = new Area(mainArea);
            area.subtract(this.getBody()[1]);
            g2d.draw(area);
        } else {
            g2d.draw(mainArea);
            if (this.getBody()[1] != null) {
                g2d.setColor(this.getIndentColor());
                g2d.fill(this.getBody()[1]);
            }
        }
        g2d.setFont(LABEL_FONT);
        if (outlineMode) {
            Theme theme = (Theme)ConfigurationManager.getInstance().readObject("theme", (Object)Constants.DEFAULT_THEME);
            finalLabelColor = componentState == ComponentState.SELECTED || componentState == ComponentState.DRAGGING ? LABEL_COLOR_SELECTED : theme.getOutlineColor();
        } else {
            finalLabelColor = componentState == ComponentState.SELECTED || componentState == ComponentState.DRAGGING ? LABEL_COLOR_SELECTED : this.getLabelColor();
        }
        g2d.setColor(finalLabelColor);
        FontMetrics fontMetrics = g2d.getFontMetrics(g2d.getFont());
        String label = this.display == Display.NAME ? this.getName() : this.getValue();
        Rectangle2D rect = fontMetrics.getStringBounds(label, g2d);
        int textHeight = (int)rect.getHeight();
        int textWidth = (int)rect.getWidth();
        Rectangle bounds = mainArea.getBounds();
        int x = bounds.x + (bounds.width - textWidth) / 2;
        int y = bounds.y + (bounds.height - textHeight) / 2 + fontMetrics.getAscent();
        g2d.drawString(label, x, y);
    }

    public void drawIcon(Graphics2D g2d, int width, int height) {
        int radius = 6 * width / 32;
        g2d.setColor(BODY_COLOR);
        g2d.fillRoundRect(width / 6, 1, 4 * width / 6, height - 4, radius, radius);
        g2d.setColor(BORDER_COLOR);
        g2d.drawRoundRect(width / 6, 1, 4 * width / 6, height - 4, radius, radius);
        int pinSize = 2 * width / 32;
        g2d.setColor(PIN_COLOR);
        for (int i = 0; i < 4; ++i) {
            g2d.fillRect(width / 6 - pinSize, height / 5 * (i + 1) - 1, pinSize, pinSize);
            g2d.fillRect(5 * width / 6 + 1, height / 5 * (i + 1) - 1, pinSize, pinSize);
        }
    }

    @EditableProperty(name="Body")
    public Color getBodyColor() {
        if (this.bodyColor == null) {
            this.bodyColor = BODY_COLOR;
        }
        return this.bodyColor;
    }

    public void setBodyColor(Color bodyColor) {
        this.bodyColor = bodyColor;
    }

    @EditableProperty(name="Border")
    public Color getBorderColor() {
        if (this.borderColor == null) {
            this.borderColor = BORDER_COLOR;
        }
        return this.borderColor;
    }

    public void setBorderColor(Color borderColor) {
        this.borderColor = borderColor;
    }

    @EditableProperty(name="Label")
    public Color getLabelColor() {
        if (this.labelColor == null) {
            this.labelColor = LABEL_COLOR;
        }
        return this.labelColor;
    }

    public void setLabelColor(Color labelColor) {
        this.labelColor = labelColor;
    }

    @EditableProperty(name="Indent")
    public Color getIndentColor() {
        if (this.indentColor == null) {
            this.indentColor = INDENT_COLOR;
        }
        return this.indentColor;
    }

    public void setIndentColor(Color indentColor) {
        this.indentColor = indentColor;
    }

    public static enum PinCount {
        _4,
        _6,
        _8,
        _10,
        _12,
        _14,
        _16,
        _18,
        _20,
        _22,
        _24,
        _26,
        _28,
        _30,
        _32,
        _34,
        _36,
        _38,
        _40,
        _42,
        _44,
        _46,
        _48,
        _50;


        public String toString() {
            return this.name().replace("_", "");
        }

        public int getValue() {
            return Integer.parseInt(this.toString());
        }
    }
}

