/*
 * Decompiled with CFR 0.152.
 */
package free.chess;

import free.chess.AbstractColoredPiecePainter;
import free.chess.ChessPiece;
import free.chess.Piece;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Polygon;
import java.awt.Rectangle;

public abstract class VectorPiecePainter
extends AbstractColoredPiecePainter {
    private Dimension cachedPieceSize = new Dimension(-1, -1);
    private Polygon kingPolygon;
    private Polygon queenPolygon;
    private Polygon rookPolygon;
    private Polygon bishopPolygon;
    private Polygon knightPolygon;
    private Polygon pawnPolygon;

    public VectorPiecePainter() {
        super(Color.white, Color.black);
    }

    public VectorPiecePainter(Color color, Color color2) {
        super(color, color2);
    }

    public VectorPiecePainter(Color color, Color color2, Color color3, Color color4) {
        super(color, color2, color3, color4);
    }

    protected abstract Polygon createKingPolygon(int var1, int var2);

    protected abstract Polygon createQueenPolygon(int var1, int var2);

    protected abstract Polygon createRookPolygon(int var1, int var2);

    protected abstract Polygon createBishopPolygon(int var1, int var2);

    protected abstract Polygon createKnightPolygon(int var1, int var2);

    protected abstract Polygon createPawnPolygon(int var1, int var2);

    private void clearPieceCache() {
        this.kingPolygon = null;
        this.queenPolygon = null;
        this.rookPolygon = null;
        this.bishopPolygon = null;
        this.knightPolygon = null;
        this.pawnPolygon = null;
    }

    public final void paintPiece(Piece piece, Graphics graphics, Component component, Rectangle rectangle, boolean bl) {
        Color color = this.getPieceColor(piece, bl);
        Color color2 = this.getOutlineColor(piece, bl);
        int n = rectangle.x;
        int n2 = rectangle.y;
        int n3 = rectangle.width;
        int n4 = rectangle.height;
        graphics.translate(n, n2);
        if (!(piece instanceof ChessPiece)) {
            return;
        }
        ChessPiece chessPiece = (ChessPiece)piece;
        if (this.cachedPieceSize.width != n3 || this.cachedPieceSize.height != n4) {
            this.clearPieceCache();
            this.cachedPieceSize.width = n3;
            this.cachedPieceSize.height = n4;
        }
        if (chessPiece.isKing()) {
            this.drawKingImage(graphics, n3, n4, color, color2);
        } else if (chessPiece.isQueen()) {
            this.drawQueenImage(graphics, n3, n4, color, color2);
        } else if (chessPiece.isRook()) {
            this.drawRookImage(graphics, n3, n4, color, color2);
        } else if (chessPiece.isBishop()) {
            this.drawBishopImage(graphics, n3, n4, color, color2);
        } else if (chessPiece.isKnight()) {
            this.drawKnightImage(graphics, n3, n4, color, color2);
        } else if (chessPiece.isPawn()) {
            this.drawPawnImage(graphics, n3, n4, color, color2);
        }
        graphics.translate(-n, -n2);
    }

    protected void drawKingImage(Graphics graphics, int n, int n2, Color color, Color color2) {
        if (this.kingPolygon == null) {
            this.kingPolygon = this.createKingPolygon(n, n2);
        }
        graphics.setColor(color);
        graphics.fillPolygon(this.kingPolygon);
        graphics.setColor(color2);
        graphics.drawPolygon(this.kingPolygon);
    }

    protected void drawQueenImage(Graphics graphics, int n, int n2, Color color, Color color2) {
        if (this.queenPolygon == null) {
            this.queenPolygon = this.createQueenPolygon(n, n2);
        }
        graphics.setColor(color);
        graphics.fillPolygon(this.queenPolygon);
        graphics.setColor(color2);
        graphics.drawPolygon(this.queenPolygon);
    }

    protected void drawRookImage(Graphics graphics, int n, int n2, Color color, Color color2) {
        if (this.rookPolygon == null) {
            this.rookPolygon = this.createRookPolygon(n, n2);
        }
        graphics.setColor(color);
        graphics.fillPolygon(this.rookPolygon);
        graphics.setColor(color2);
        graphics.drawPolygon(this.rookPolygon);
    }

    protected void drawBishopImage(Graphics graphics, int n, int n2, Color color, Color color2) {
        if (this.bishopPolygon == null) {
            this.bishopPolygon = this.createBishopPolygon(n, n2);
        }
        graphics.setColor(color);
        graphics.fillPolygon(this.bishopPolygon);
        graphics.setColor(color2);
        graphics.drawPolygon(this.bishopPolygon);
    }

    protected void drawKnightImage(Graphics graphics, int n, int n2, Color color, Color color2) {
        if (this.knightPolygon == null) {
            this.knightPolygon = this.createKnightPolygon(n, n2);
        }
        graphics.setColor(color);
        graphics.fillPolygon(this.knightPolygon);
        graphics.setColor(color2);
        graphics.drawPolygon(this.knightPolygon);
    }

    protected void drawPawnImage(Graphics graphics, int n, int n2, Color color, Color color2) {
        if (this.pawnPolygon == null) {
            this.pawnPolygon = this.createPawnPolygon(n, n2);
        }
        graphics.setColor(color);
        graphics.fillPolygon(this.pawnPolygon);
        graphics.setColor(color2);
        graphics.drawPolygon(this.pawnPolygon);
    }
}

