/*
 * Decompiled with CFR 0.152.
 */
package free.util.swing;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import javax.swing.Icon;

public class BorderIcon
implements Icon {
    private final Icon wrappedIcon;
    private final Color borderColor;

    public BorderIcon(Icon icon, Color color) {
        if (icon == null) {
            throw new IllegalArgumentException("wrappedIcon may not be null");
        }
        if (color == null) {
            throw new IllegalArgumentException("borderColor may not be null");
        }
        this.wrappedIcon = icon;
        this.borderColor = color;
    }

    public int getIconHeight() {
        return this.wrappedIcon.getIconHeight() + 2;
    }

    public int getIconWidth() {
        return this.wrappedIcon.getIconWidth() + 2;
    }

    public Icon getWrappedIcon() {
        return this.wrappedIcon;
    }

    public Color getBorderColor() {
        return this.borderColor;
    }

    public void paintIcon(Component component, Graphics graphics, int n, int n2) {
        this.wrappedIcon.paintIcon(component, graphics, n + 1, n2 + 1);
        graphics.setColor(this.borderColor);
        graphics.drawRect(n, n2, this.getIconWidth() - 1, this.getIconHeight() - 1);
    }
}

