/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.javax.sip.stack;

import gov.nist.core.CommonLogger;
import gov.nist.core.StackLogger;
import gov.nist.javax.sip.stack.ConnectionOrientedMessageChannel;
import gov.nist.javax.sip.stack.NioTcpMessageChannel;
import gov.nist.javax.sip.stack.NioTcpMessageProcessor;
import gov.nist.javax.sip.stack.NioWebSocketMessageChannel;
import gov.nist.javax.sip.stack.SIPTransactionStack;
import java.io.IOException;
import java.net.InetAddress;
import java.nio.channels.SocketChannel;

public class NioWebSocketMessageProcessor
extends NioTcpMessageProcessor {
    private static StackLogger logger = CommonLogger.getLogger(NioWebSocketMessageProcessor.class);

    public NioWebSocketMessageProcessor(InetAddress ipAddress, SIPTransactionStack sipStack, int port2) {
        super(ipAddress, sipStack, port2);
        this.transport = "WS";
    }

    @Override
    public NioTcpMessageChannel createMessageChannel(NioTcpMessageProcessor nioTcpMessageProcessor, SocketChannel client) throws IOException {
        return NioWebSocketMessageChannel.create(this.sipStack, this, client);
    }

    @Override
    ConnectionOrientedMessageChannel constructMessageChannel(InetAddress targetHost, int port2) throws IOException {
        return new NioWebSocketMessageChannel(targetHost, port2, this.sipStack, this);
    }
}

