/*
 * Decompiled with CFR 0.152.
 */
package io.sentry;

import io.sentry.protocol.SdkVersion;
import io.sentry.util.SampleRateUtils;
import java.util.Locale;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class SentryReplayOptions {
    public static final String TEXT_VIEW_CLASS_NAME = "android.widget.TextView";
    public static final String IMAGE_VIEW_CLASS_NAME = "android.widget.ImageView";
    public static final String WEB_VIEW_CLASS_NAME = "android.webkit.WebView";
    public static final String VIDEO_VIEW_CLASS_NAME = "android.widget.VideoView";
    public static final String ANDROIDX_MEDIA_VIEW_CLASS_NAME = "androidx.media3.ui.PlayerView";
    public static final String EXOPLAYER_CLASS_NAME = "com.google.android.exoplayer2.ui.PlayerView";
    public static final String EXOPLAYER_STYLED_CLASS_NAME = "com.google.android.exoplayer2.ui.StyledPlayerView";
    @Nullable
    private Double sessionSampleRate;
    @Nullable
    private Double onErrorSampleRate;
    private Set<String> maskViewClasses = new CopyOnWriteArraySet<String>();
    private Set<String> unmaskViewClasses = new CopyOnWriteArraySet<String>();
    @Nullable
    private String maskViewContainerClass = null;
    @Nullable
    private String unmaskViewContainerClass = null;
    private SentryReplayQuality quality = SentryReplayQuality.MEDIUM;
    private int frameRate = 1;
    private long errorReplayDuration = 30000L;
    private long sessionSegmentDuration = 5000L;
    private long sessionDuration = 3600000L;
    private boolean trackOrientationChange = true;
    @Nullable
    private SdkVersion sdkVersion;

    public SentryReplayOptions(boolean empty, @Nullable SdkVersion sdkVersion) {
        if (!empty) {
            this.setMaskAllText(true);
            this.setMaskAllImages(true);
            this.maskViewClasses.add(WEB_VIEW_CLASS_NAME);
            this.maskViewClasses.add(VIDEO_VIEW_CLASS_NAME);
            this.maskViewClasses.add(ANDROIDX_MEDIA_VIEW_CLASS_NAME);
            this.maskViewClasses.add(EXOPLAYER_CLASS_NAME);
            this.maskViewClasses.add(EXOPLAYER_STYLED_CLASS_NAME);
            this.sdkVersion = sdkVersion;
        }
    }

    public SentryReplayOptions(@Nullable Double sessionSampleRate, @Nullable Double onErrorSampleRate, @Nullable SdkVersion sdkVersion) {
        this(false, sdkVersion);
        this.sessionSampleRate = sessionSampleRate;
        this.onErrorSampleRate = onErrorSampleRate;
        this.sdkVersion = sdkVersion;
    }

    @Nullable
    public Double getOnErrorSampleRate() {
        return this.onErrorSampleRate;
    }

    public boolean isSessionReplayEnabled() {
        return this.getSessionSampleRate() != null && this.getSessionSampleRate() > 0.0;
    }

    public void setOnErrorSampleRate(@Nullable Double onErrorSampleRate) {
        if (!SampleRateUtils.isValidSampleRate(onErrorSampleRate)) {
            throw new IllegalArgumentException("The value " + onErrorSampleRate + " is not valid. Use null to disable or values >= 0.0 and <= 1.0.");
        }
        this.onErrorSampleRate = onErrorSampleRate;
    }

    @Nullable
    public Double getSessionSampleRate() {
        return this.sessionSampleRate;
    }

    public boolean isSessionReplayForErrorsEnabled() {
        return this.getOnErrorSampleRate() != null && this.getOnErrorSampleRate() > 0.0;
    }

    public void setSessionSampleRate(@Nullable Double sessionSampleRate) {
        if (!SampleRateUtils.isValidSampleRate(sessionSampleRate)) {
            throw new IllegalArgumentException("The value " + sessionSampleRate + " is not valid. Use null to disable or values >= 0.0 and <= 1.0.");
        }
        this.sessionSampleRate = sessionSampleRate;
    }

    public void setMaskAllText(boolean maskAllText) {
        if (maskAllText) {
            this.addMaskViewClass(TEXT_VIEW_CLASS_NAME);
            this.unmaskViewClasses.remove(TEXT_VIEW_CLASS_NAME);
        } else {
            this.addUnmaskViewClass(TEXT_VIEW_CLASS_NAME);
            this.maskViewClasses.remove(TEXT_VIEW_CLASS_NAME);
        }
    }

    public void setMaskAllImages(boolean maskAllImages) {
        if (maskAllImages) {
            this.addMaskViewClass(IMAGE_VIEW_CLASS_NAME);
            this.unmaskViewClasses.remove(IMAGE_VIEW_CLASS_NAME);
        } else {
            this.addUnmaskViewClass(IMAGE_VIEW_CLASS_NAME);
            this.maskViewClasses.remove(IMAGE_VIEW_CLASS_NAME);
        }
    }

    @NotNull
    public Set<String> getMaskViewClasses() {
        return this.maskViewClasses;
    }

    public void addMaskViewClass(@NotNull String className) {
        this.maskViewClasses.add(className);
    }

    @NotNull
    public Set<String> getUnmaskViewClasses() {
        return this.unmaskViewClasses;
    }

    public void addUnmaskViewClass(@NotNull String className) {
        this.unmaskViewClasses.add(className);
    }

    @ApiStatus.Internal
    @NotNull
    public SentryReplayQuality getQuality() {
        return this.quality;
    }

    public void setQuality(@NotNull SentryReplayQuality quality) {
        this.quality = quality;
    }

    @ApiStatus.Internal
    public int getFrameRate() {
        return this.frameRate;
    }

    @ApiStatus.Internal
    public long getErrorReplayDuration() {
        return this.errorReplayDuration;
    }

    @ApiStatus.Internal
    public long getSessionSegmentDuration() {
        return this.sessionSegmentDuration;
    }

    @ApiStatus.Internal
    public long getSessionDuration() {
        return this.sessionDuration;
    }

    @ApiStatus.Internal
    public void setMaskViewContainerClass(@NotNull String containerClass) {
        this.addMaskViewClass(containerClass);
        this.maskViewContainerClass = containerClass;
    }

    @ApiStatus.Internal
    public void setUnmaskViewContainerClass(@NotNull String containerClass) {
        this.unmaskViewContainerClass = containerClass;
    }

    @ApiStatus.Internal
    @Nullable
    public String getMaskViewContainerClass() {
        return this.maskViewContainerClass;
    }

    @ApiStatus.Internal
    @Nullable
    public String getUnmaskViewContainerClass() {
        return this.unmaskViewContainerClass;
    }

    @ApiStatus.Internal
    public boolean isTrackOrientationChange() {
        return this.trackOrientationChange;
    }

    @ApiStatus.Internal
    public void setTrackOrientationChange(boolean trackOrientationChange) {
        this.trackOrientationChange = trackOrientationChange;
    }

    @ApiStatus.Internal
    @Nullable
    public SdkVersion getSdkVersion() {
        return this.sdkVersion;
    }

    @ApiStatus.Internal
    public void setSdkVersion(@Nullable SdkVersion sdkVersion) {
        this.sdkVersion = sdkVersion;
    }

    public static enum SentryReplayQuality {
        LOW(0.8f, 50000, 10),
        MEDIUM(1.0f, 75000, 30),
        HIGH(1.0f, 100000, 50);

        public final float sizeScale;
        public final int bitRate;
        public final int screenshotQuality;

        private SentryReplayQuality(float sizeScale, int bitRate, int screenshotQuality) {
            this.sizeScale = sizeScale;
            this.bitRate = bitRate;
            this.screenshotQuality = screenshotQuality;
        }

        @NotNull
        public String serializedName() {
            return this.name().toLowerCase(Locale.ROOT);
        }
    }
}

