/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.nlj.rtp.bandwidthestimation2;

import java.time.Duration;
import java.time.Instant;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jitsi.nlj.rtp.bandwidthestimation2.AimdRateControl;
import org.jitsi.nlj.rtp.bandwidthestimation2.BandwidthUsage;
import org.jitsi.nlj.rtp.bandwidthestimation2.DelayIncreaseDetectorInterface;
import org.jitsi.nlj.rtp.bandwidthestimation2.InterArrivalDelta;
import org.jitsi.nlj.rtp.bandwidthestimation2.PacketResult;
import org.jitsi.nlj.rtp.bandwidthestimation2.RateControlInput;
import org.jitsi.nlj.rtp.bandwidthestimation2.TransportPacketsFeedback;
import org.jitsi.nlj.rtp.bandwidthestimation2.TrendlineEstimator;
import org.jitsi.nlj.util.Bandwidth;
import org.jitsi.nlj.util.BandwidthKt;
import org.jitsi.nlj.util.DataSize;
import org.jitsi.utils.DurationKt;
import org.jitsi.utils.InstantKt;
import org.jitsi.utils.logging.DiagnosticContext;
import org.jitsi.utils.logging.TimeSeriesLogger;
import org.jitsi.utils.logging2.Logger;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000n\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\u0011\u0018\u0000 D2\u00020\u0001:\u0002DEB\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J/\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001f2\b\u0010 \u001a\u0004\u0018\u00010\u00182\b\u0010!\u001a\u0004\u0018\u00010\u00182\u0006\u0010\"\u001a\u00020#\u00a2\u0006\u0002\b$J\u0018\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020\u0012H\u0002J\u001f\u0010*\u001a\u00020\u00182\u0006\u0010)\u001a\u00020\u00122\b\u0010+\u001a\u0004\u0018\u00010\u0018\u00a2\u0006\u0004\b,\u0010-J9\u0010.\u001a\u00020\u001d2\b\u0010 \u001a\u0004\u0018\u00010\u00182\b\u0010!\u001a\u0004\u0018\u00010\u00182\u0006\u0010/\u001a\u00020#2\u0006\u0010\"\u001a\u00020#2\u0006\u0010)\u001a\u00020\u0012H\u0002\u00a2\u0006\u0002\b0J!\u00101\u001a\u0004\u0018\u00010\u00182\u0006\u0010)\u001a\u00020\u00122\b\u0010 \u001a\u0004\u0018\u00010\u0018H\u0002\u00a2\u0006\u0002\b2J\u000e\u00103\u001a\u00020&2\u0006\u00104\u001a\u000205J\r\u00106\u001a\u0004\u0018\u00010\u0018\u00a2\u0006\u0002\b7J\u0015\u00108\u001a\u00020&2\u0006\u00109\u001a\u00020\u0018\u00a2\u0006\u0004\b:\u0010;J\u0015\u0010<\u001a\u00020&2\u0006\u0010=\u001a\u00020\u0018\u00a2\u0006\u0004\b>\u0010;J\u0006\u0010?\u001a\u000205J\r\u0010@\u001a\u00020\u0018\u00a2\u0006\u0004\bA\u0010BJ\u0006\u0010C\u001a\u00020\u001bR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\b\u001a\n \t*\u0004\u0018\u00010\u00030\u0003X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\nR\u0010\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\r\u001a\u00020\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0013\u001a\u00020\u0014\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0010\u0010\u0017\u001a\u00020\u0018X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u0019R\u000e\u0010\u001a\u001a\u00020\u001bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006F"}, d2={"Lorg/jitsi/nlj/rtp/bandwidthestimation2/DelayBasedBwe;", "", "parentLogger", "Lorg/jitsi/utils/logging2/Logger;", "diagnosticContext", "Lorg/jitsi/utils/logging/DiagnosticContext;", "<init>", "(Lorg/jitsi/utils/logging2/Logger;Lorg/jitsi/utils/logging/DiagnosticContext;)V", "logger", "kotlin.jvm.PlatformType", "Lorg/jitsi/utils/logging2/Logger;", "interArrivalDelta", "Lorg/jitsi/nlj/rtp/bandwidthestimation2/InterArrivalDelta;", "delayDetector", "Lorg/jitsi/nlj/rtp/bandwidthestimation2/DelayIncreaseDetectorInterface;", "getDelayDetector", "()Lorg/jitsi/nlj/rtp/bandwidthestimation2/DelayIncreaseDetectorInterface;", "lastSeenPacket", "Ljava/time/Instant;", "rateControl", "Lorg/jitsi/nlj/rtp/bandwidthestimation2/AimdRateControl;", "getRateControl", "()Lorg/jitsi/nlj/rtp/bandwidthestimation2/AimdRateControl;", "prevBitrate", "Lorg/jitsi/nlj/util/Bandwidth;", "J", "prevState", "Lorg/jitsi/nlj/rtp/bandwidthestimation2/BandwidthUsage;", "incomingPacketFeedbackVector", "Lorg/jitsi/nlj/rtp/bandwidthestimation2/DelayBasedBwe$Result;", "msg", "Lorg/jitsi/nlj/rtp/bandwidthestimation2/TransportPacketsFeedback;", "ackedBitrate", "probeBitrate", "inAlr", "", "incomingPacketFeedbackVector-nJqwPh4", "incomingPacketFeedback", "", "packetFeedback", "Lorg/jitsi/nlj/rtp/bandwidthestimation2/PacketResult;", "atTime", "triggerOveruse", "linkCapacity", "triggerOveruse-3qygMC8", "(Ljava/time/Instant;Lorg/jitsi/nlj/util/Bandwidth;)J", "maybeUpdateEstimate", "recoveredFromOveruse", "maybeUpdateEstimate-pp-NUqk", "updateEstimate", "updateEstimate-p1trQLY", "onRttUpdate", "avgRtt", "Ljava/time/Duration;", "latestEstimate", "latestEstimate-4yB3KFE", "setStartBitrate", "startBitrate", "setStartBitrate-_2icLw0", "(J)V", "setMinBitrate", "minBitrate", "setMinBitrate-_2icLw0", "getExpectedBwePeriod", "lastEstimate", "lastEstimate-rlWvAKk", "()J", "lastState", "Companion", "Result", "jitsi-media-transform"})
public final class DelayBasedBwe {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final DiagnosticContext diagnosticContext;
    private final Logger logger;
    @Nullable
    private InterArrivalDelta interArrivalDelta;
    @NotNull
    private final DelayIncreaseDetectorInterface delayDetector;
    @NotNull
    private Instant lastSeenPacket;
    @NotNull
    private final AimdRateControl rateControl;
    private long prevBitrate;
    @NotNull
    private BandwidthUsage prevState;
    @NotNull
    private static final Duration kStreamTimeOut = DurationKt.getSecs(2);
    @NotNull
    private static final Duration kSendTimeGroupLength = DurationKt.getMs(5);
    private static final TimeSeriesLogger timeSeriesLogger = TimeSeriesLogger.getTimeSeriesLogger(DelayBasedBwe.class);

    public DelayBasedBwe(@NotNull Logger parentLogger, @NotNull DiagnosticContext diagnosticContext) {
        Intrinsics.checkNotNullParameter(parentLogger, "parentLogger");
        Intrinsics.checkNotNullParameter(diagnosticContext, "diagnosticContext");
        this.diagnosticContext = diagnosticContext;
        Logger logger = this.logger = parentLogger.createChildLogger(this.getClass().getName());
        Intrinsics.checkNotNullExpressionValue(logger, "logger");
        this.delayDetector = new TrendlineEstimator(logger, this.diagnosticContext);
        this.lastSeenPacket = InstantKt.NEVER;
        this.rateControl = new AimdRateControl(true);
        this.prevBitrate = Bandwidth.Companion.getZERO-rlWvAKk();
        this.prevState = BandwidthUsage.kBwNormal;
    }

    @NotNull
    public final DelayIncreaseDetectorInterface getDelayDetector() {
        return this.delayDetector;
    }

    @NotNull
    public final AimdRateControl getRateControl() {
        return this.rateControl;
    }

    @NotNull
    public final Result incomingPacketFeedbackVector-nJqwPh4(@NotNull TransportPacketsFeedback msg, @Nullable Bandwidth ackedBitrate, @Nullable Bandwidth probeBitrate, boolean inAlr) {
        Intrinsics.checkNotNullParameter(msg, "msg");
        List<PacketResult> packetFeedbackVector = msg.sortedByReceiveTime();
        if (packetFeedbackVector.isEmpty()) {
            this.logger.warn("Very late feedback received.");
            return new Result(false, false, 0L, false, null, 31, null);
        }
        boolean delayedFeedback = true;
        boolean recoveredFromOveruse = false;
        BandwidthUsage prevDetectorState = this.delayDetector.state();
        for (PacketResult packetFeedback : packetFeedbackVector) {
            delayedFeedback = false;
            this.incomingPacketFeedback(packetFeedback, msg.getFeedbackTime());
            if (prevDetectorState == BandwidthUsage.kBwUnderusing && this.delayDetector.state() == BandwidthUsage.kBwNormal) {
                recoveredFromOveruse = true;
            }
            prevDetectorState = this.delayDetector.state();
        }
        if (delayedFeedback) {
            return new Result(false, false, 0L, false, null, 31, null);
        }
        this.rateControl.setInAlr(inAlr);
        return this.maybeUpdateEstimate-pp-NUqk(ackedBitrate, probeBitrate, recoveredFromOveruse, inAlr, msg.getFeedbackTime());
    }

    private final void incomingPacketFeedback(PacketResult packetFeedback, Instant atTime) {
        if (Intrinsics.areEqual(this.lastSeenPacket, InstantKt.NEVER) || Duration.between(this.lastSeenPacket, atTime).compareTo(kStreamTimeOut) > 0) {
            this.interArrivalDelta = new InterArrivalDelta(kSendTimeGroupLength);
        }
        this.lastSeenPacket = atTime;
        DataSize packetSize = packetFeedback.getSentPacket().getSize();
        InterArrivalDelta interArrivalDelta = this.interArrivalDelta;
        Intrinsics.checkNotNull(interArrivalDelta);
        InterArrivalDelta.ComputeDeltasResult calculatedDeltas = interArrivalDelta.computeDeltas(packetFeedback.getSentPacket().getSendTime(), packetFeedback.getReceiveTime(), atTime, (long)packetSize.getBytes());
        this.delayDetector.update(DurationKt.toDoubleMillis(calculatedDeltas.getArrivalTimeDelta()), DurationKt.toDoubleMillis(calculatedDeltas.getSendTimeDelta()), InstantKt.toRoundedEpochMilli(packetFeedback.getSentPacket().getSendTime()), InstantKt.toRoundedEpochMilli(packetFeedback.getReceiveTime()), (long)packetSize.getBytes(), calculatedDeltas.getComputed());
    }

    public final long triggerOveruse-3qygMC8(@NotNull Instant atTime, @Nullable Bandwidth linkCapacity) {
        Intrinsics.checkNotNullParameter(atTime, "atTime");
        RateControlInput input = new RateControlInput(BandwidthUsage.kBwOverusing, linkCapacity, null);
        return this.rateControl.update-MxRVi0s(input, atTime);
    }

    private final Result maybeUpdateEstimate-pp-NUqk(Bandwidth ackedBitrate, Bandwidth probeBitrate, boolean recoveredFromOveruse, boolean inAlr, Instant atTime) {
        Result result;
        Bandwidth targetBitrate;
        if (this.delayDetector.state() == BandwidthUsage.kBwOverusing) {
            if (ackedBitrate != null && this.rateControl.timeToReduceFurther-ERFH51c(atTime, ackedBitrate.unbox-impl())) {
                targetBitrate = this.updateEstimate-p1trQLY(atTime, ackedBitrate);
                result = targetBitrate != null ? new Result(true, false, targetBitrate.unbox-impl(), false, null, 26, null) : new Result(false, false, 0L, false, null, 30, null);
            } else if (ackedBitrate == null && this.rateControl.validEstimate() && this.rateControl.initialTimeToReduceFurther(atTime)) {
                this.rateControl.setEstimate-SimD6oM(Bandwidth.div-WElJv5I(this.rateControl.latestEstimate-rlWvAKk(), 2), atTime);
                result = new Result(true, false, this.rateControl.latestEstimate-rlWvAKk(), false, null, 24, null);
            } else {
                result = new Result(false, false, 0L, false, null, 31, null);
            }
        } else if (probeBitrate != null) {
            this.rateControl.setEstimate-SimD6oM(probeBitrate.unbox-impl(), atTime);
            long targetBitrate2 = this.rateControl.latestEstimate-rlWvAKk();
            result = new Result(true, true, targetBitrate2, false, null, 24, null);
        } else {
            targetBitrate = this.updateEstimate-p1trQLY(atTime, ackedBitrate);
            result = targetBitrate != null ? new Result(true, false, targetBitrate.unbox-impl(), recoveredFromOveruse, null, 18, null) : new Result(false, false, 0L, recoveredFromOveruse, null, 22, null);
        }
        Result result2 = result;
        BandwidthUsage detectorState = this.delayDetector.state();
        if (result2.getUpdated() && !Bandwidth.equals-impl0(this.prevBitrate, result2.getTargetBitrate-rlWvAKk()) || detectorState != this.prevState) {
            long bitrate = result2.getUpdated() ? result2.getTargetBitrate-rlWvAKk() : this.prevBitrate;
            timeSeriesLogger.trace(() -> DelayBasedBwe.maybeUpdateEstimate_pp_NUqk$lambda$0(this, atTime, bitrate, detectorState));
            this.prevBitrate = bitrate;
            this.prevState = detectorState;
        }
        result2.setDelayDetectorState(detectorState);
        return result2;
    }

    private final Bandwidth updateEstimate-p1trQLY(Instant atTime, Bandwidth ackedBitrate) {
        RateControlInput input = new RateControlInput(this.delayDetector.state(), ackedBitrate, null);
        long targetRate = this.rateControl.update-MxRVi0s(input, atTime);
        return this.rateControl.validEstimate() ? Bandwidth.box-impl(targetRate) : null;
    }

    public final void onRttUpdate(@NotNull Duration avgRtt) {
        Intrinsics.checkNotNullParameter(avgRtt, "avgRtt");
        this.rateControl.setRtt(avgRtt);
    }

    @Nullable
    public final Bandwidth latestEstimate-4yB3KFE() {
        if (!this.rateControl.validEstimate()) {
            return null;
        }
        return Bandwidth.box-impl(this.rateControl.latestEstimate-rlWvAKk());
    }

    public final void setStartBitrate-_2icLw0(long startBitrate) {
        this.logger.info("BWE setting start bitrate to " + Bandwidth.toString-impl(startBitrate));
        this.rateControl.setStartBitrate-_2icLw0(startBitrate);
    }

    public final void setMinBitrate-_2icLw0(long minBitrate) {
        this.rateControl.setMinBitrate-_2icLw0(minBitrate);
    }

    @NotNull
    public final Duration getExpectedBwePeriod() {
        return this.rateControl.getExpectedBandwidthPeriod();
    }

    public final long lastEstimate-rlWvAKk() {
        return this.prevBitrate;
    }

    @NotNull
    public final BandwidthUsage lastState() {
        return this.prevState;
    }

    private static final Map maybeUpdateEstimate_pp_NUqk$lambda$0(DelayBasedBwe this$0, Instant $atTime, long $bitrate, BandwidthUsage $detectorState) {
        Intrinsics.checkNotNullParameter(this$0, "this$0");
        Intrinsics.checkNotNullParameter($atTime, "$atTime");
        Intrinsics.checkNotNullParameter((Object)$detectorState, "$detectorState");
        return this$0.diagnosticContext.makeTimeSeriesPoint("bwe_update_delay_based", $atTime).addField("bitrate_bps", $bitrate).addField("detector_state", $detectorState.name());
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\b\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\u0007R\u0018\u0010\n\u001a\n \f*\u0004\u0018\u00010\u000b0\u000bX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\r\u00a8\u0006\u000e"}, d2={"Lorg/jitsi/nlj/rtp/bandwidthestimation2/DelayBasedBwe$Companion;", "", "<init>", "()V", "kStreamTimeOut", "Ljava/time/Duration;", "getKStreamTimeOut", "()Ljava/time/Duration;", "kSendTimeGroupLength", "getKSendTimeGroupLength", "timeSeriesLogger", "Lorg/jitsi/utils/logging/TimeSeriesLogger;", "kotlin.jvm.PlatformType", "Lorg/jitsi/utils/logging/TimeSeriesLogger;", "jitsi-media-transform"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Duration getKStreamTimeOut() {
            return kStreamTimeOut;
        }

        @NotNull
        public final Duration getKSendTimeGroupLength() {
            return kSendTimeGroupLength;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0019\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B9\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0006\u0012\b\b\u0002\u0010\u0007\u001a\u00020\u0003\u0012\b\b\u0002\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\t\u0010\u0017\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0018\u001a\u00020\u0003H\u00c6\u0003J\u0010\u0010\u0019\u001a\u00020\u0006H\u00c6\u0003\u00a2\u0006\u0004\b\u001a\u0010\u0010J\t\u0010\u001b\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u001c\u001a\u00020\tH\u00c6\u0003JB\u0010\u001d\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00062\b\b\u0002\u0010\u0007\u001a\u00020\u00032\b\b\u0002\u0010\b\u001a\u00020\tH\u00c6\u0001\u00a2\u0006\u0004\b\u001e\u0010\u001fJ\u0013\u0010 \u001a\u00020\u00032\b\u0010!\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\"\u001a\u00020#H\u00d6\u0001J\t\u0010$\u001a\u00020%H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\rR\u0013\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\n\n\u0002\u0010\u0011\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0007\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\rR\u001a\u0010\b\u001a\u00020\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u0014\"\u0004\b\u0015\u0010\u0016\u00a8\u0006&"}, d2={"Lorg/jitsi/nlj/rtp/bandwidthestimation2/DelayBasedBwe$Result;", "", "updated", "", "probe", "targetBitrate", "Lorg/jitsi/nlj/util/Bandwidth;", "recoveredFromOveruse", "delayDetectorState", "Lorg/jitsi/nlj/rtp/bandwidthestimation2/BandwidthUsage;", "<init>", "(ZZJZLorg/jitsi/nlj/rtp/bandwidthestimation2/BandwidthUsage;Lkotlin/jvm/internal/DefaultConstructorMarker;)V", "getUpdated", "()Z", "getProbe", "getTargetBitrate-rlWvAKk", "()J", "J", "getRecoveredFromOveruse", "getDelayDetectorState", "()Lorg/jitsi/nlj/rtp/bandwidthestimation2/BandwidthUsage;", "setDelayDetectorState", "(Lorg/jitsi/nlj/rtp/bandwidthestimation2/BandwidthUsage;)V", "component1", "component2", "component3", "component3-rlWvAKk", "component4", "component5", "copy", "copy-Eluxkwk", "(ZZJZLorg/jitsi/nlj/rtp/bandwidthestimation2/BandwidthUsage;)Lorg/jitsi/nlj/rtp/bandwidthestimation2/DelayBasedBwe$Result;", "equals", "other", "hashCode", "", "toString", "", "jitsi-media-transform"})
    public static final class Result {
        private final boolean updated;
        private final boolean probe;
        private final long targetBitrate;
        private final boolean recoveredFromOveruse;
        @NotNull
        private BandwidthUsage delayDetectorState;

        private Result(boolean updated, boolean probe, long targetBitrate, boolean recoveredFromOveruse, BandwidthUsage delayDetectorState) {
            Intrinsics.checkNotNullParameter((Object)delayDetectorState, "delayDetectorState");
            this.updated = updated;
            this.probe = probe;
            this.targetBitrate = targetBitrate;
            this.recoveredFromOveruse = recoveredFromOveruse;
            this.delayDetectorState = delayDetectorState;
        }

        public /* synthetic */ Result(boolean bl, boolean bl2, long l, boolean bl3, BandwidthUsage bandwidthUsage, int n, DefaultConstructorMarker defaultConstructorMarker2) {
            if ((n & 1) != 0) {
                bl = false;
            }
            if ((n & 2) != 0) {
                bl2 = false;
            }
            if ((n & 4) != 0) {
                l = BandwidthKt.getBps(0);
            }
            if ((n & 8) != 0) {
                bl3 = false;
            }
            if ((n & 0x10) != 0) {
                bandwidthUsage = BandwidthUsage.kBwNormal;
            }
            this(bl, bl2, l, bl3, bandwidthUsage, null);
        }

        public final boolean getUpdated() {
            return this.updated;
        }

        public final boolean getProbe() {
            return this.probe;
        }

        public final long getTargetBitrate-rlWvAKk() {
            return this.targetBitrate;
        }

        public final boolean getRecoveredFromOveruse() {
            return this.recoveredFromOveruse;
        }

        @NotNull
        public final BandwidthUsage getDelayDetectorState() {
            return this.delayDetectorState;
        }

        public final void setDelayDetectorState(@NotNull BandwidthUsage bandwidthUsage) {
            Intrinsics.checkNotNullParameter((Object)bandwidthUsage, "<set-?>");
            this.delayDetectorState = bandwidthUsage;
        }

        public final boolean component1() {
            return this.updated;
        }

        public final boolean component2() {
            return this.probe;
        }

        public final long component3-rlWvAKk() {
            return this.targetBitrate;
        }

        public final boolean component4() {
            return this.recoveredFromOveruse;
        }

        @NotNull
        public final BandwidthUsage component5() {
            return this.delayDetectorState;
        }

        @NotNull
        public final Result copy-Eluxkwk(boolean updated, boolean probe, long targetBitrate, boolean recoveredFromOveruse, @NotNull BandwidthUsage delayDetectorState) {
            Intrinsics.checkNotNullParameter((Object)delayDetectorState, "delayDetectorState");
            return new Result(updated, probe, targetBitrate, recoveredFromOveruse, delayDetectorState, null);
        }

        public static /* synthetic */ Result copy-Eluxkwk$default(Result result, boolean bl, boolean bl2, long l, boolean bl3, BandwidthUsage bandwidthUsage, int n, Object object) {
            if ((n & 1) != 0) {
                bl = result.updated;
            }
            if ((n & 2) != 0) {
                bl2 = result.probe;
            }
            if ((n & 4) != 0) {
                l = result.targetBitrate;
            }
            if ((n & 8) != 0) {
                bl3 = result.recoveredFromOveruse;
            }
            if ((n & 0x10) != 0) {
                bandwidthUsage = result.delayDetectorState;
            }
            return result.copy-Eluxkwk(bl, bl2, l, bl3, bandwidthUsage);
        }

        @NotNull
        public String toString() {
            return "Result(updated=" + this.updated + ", probe=" + this.probe + ", targetBitrate=" + Bandwidth.toString-impl(this.targetBitrate) + ", recoveredFromOveruse=" + this.recoveredFromOveruse + ", delayDetectorState=" + this.delayDetectorState + ")";
        }

        public int hashCode() {
            int result = Boolean.hashCode(this.updated);
            result = result * 31 + Boolean.hashCode(this.probe);
            result = result * 31 + Bandwidth.hashCode-impl(this.targetBitrate);
            result = result * 31 + Boolean.hashCode(this.recoveredFromOveruse);
            result = result * 31 + this.delayDetectorState.hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Result)) {
                return false;
            }
            Result result = (Result)other;
            if (this.updated != result.updated) {
                return false;
            }
            if (this.probe != result.probe) {
                return false;
            }
            if (!Bandwidth.equals-impl0(this.targetBitrate, result.targetBitrate)) {
                return false;
            }
            if (this.recoveredFromOveruse != result.recoveredFromOveruse) {
                return false;
            }
            return this.delayDetectorState == result.delayDetectorState;
        }

        public /* synthetic */ Result(boolean updated, boolean probe, long targetBitrate, boolean recoveredFromOveruse, BandwidthUsage delayDetectorState, DefaultConstructorMarker $constructor_marker) {
            this(updated, probe, targetBitrate, recoveredFromOveruse, delayDetectorState);
        }
    }
}

